/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.utils;

import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.encoding.AgnosticTypeMappingRegistry;
import com.ibm.ws.webservices.multiprotocol.handlers.AgnosticHandlerRegistry;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Port;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class ServiceManager {
    protected ServiceContext context;
    protected ServiceProviderManager serviceProviderManager;
    protected AgnosticHandlerRegistry handlerRegistry;
    protected AgnosticTypeMappingRegistry typeMappingRegistry;
    protected Map bindingNamspace2ServiceCache;

    public ServiceManager(ServiceContext serviceContext, ServiceProviderManager serviceProviderManager) {
        this.context = serviceContext;
        this.serviceProviderManager = serviceProviderManager;
        this.bindingNamspace2ServiceCache = new HashMap();
    }

    public AgnosticTypeMappingRegistry getTypeMappingRegistry() {
        if (this.typeMappingRegistry == null) {
            this.typeMappingRegistry = new AgnosticTypeMappingRegistry();
        }
        return this.typeMappingRegistry;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new AgnosticHandlerRegistry();
        }
        return this.handlerRegistry;
    }

    public Service getServiceForPort(String string) throws ServiceException {
        Port port2 = this.context.getWSDLService().getPort(string);
        Service service = this.getServiceForPort(port2);
        return service;
    }

    public Service getServiceForPort(Port port2) throws ServiceException {
        String string = this.context.getPortBindingNamespace(port2);
        Service service = this.getServiceForNamespace(string);
        return service;
    }

    public Service getServiceForNamespace(String string) throws ServiceException {
        Service service = this.discoverServiceForNamespace(string);
        if (service == null) {
            throw new ServiceException(Messages.getMessage("noService", string));
        }
        return service;
    }

    private void initTypeMappings(Service service) {
        TypeMappingRegistry typeMappingRegistry;
        if (this.typeMappingRegistry != null && (typeMappingRegistry = service.getTypeMappingRegistry()) != null) {
            this.typeMappingRegistry.copyContents(typeMappingRegistry);
        }
    }

    private void initHandlerRegistry(Service service) {
        if (this.context.isManagedEnvironment()) {
            return;
        }
        HandlerRegistry handlerRegistry = service.getHandlerRegistry();
        this.getHandlerRegistry();
        this.handlerRegistry.transferContents(handlerRegistry);
    }

    protected synchronized Service discoverServiceForNamespace(String string) throws ServiceException {
        ServiceProvider serviceProvider;
        Service service = (Service)this.bindingNamspace2ServiceCache.get(string);
        if (service == null && (serviceProvider = this.serviceProviderManager.getServiceProvider(string)) != null) {
            service = serviceProvider.createService(this.context);
            this.bindingNamspace2ServiceCache.put(string, service);
            this.initTypeMappings(service);
            this.initHandlerRegistry(service);
        }
        return service;
    }
}

