/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.IgnoreSoapBodyException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPBodyBuilder
extends SOAPBuilder {
    protected static Log log = LogFactory.getLog(SOAPBodyBuilder.class.getName());
    private boolean streaming = false;

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        super.startElement(string, string2, string3, attributes, mappingScope, deserializationContext);
        MessageContext messageContext = deserializationContext.getMessageContext();
        if (messageContext != null) {
            QName qName;
            Boolean bl = (Boolean)messageContext.getProperty("IGNORE_SOAPBODY");
            if (bl != null && bl.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Throwing IgnoreSoapBodyException to bypass parse of SOAP body.");
                }
                throw new IgnoreSoapBodyException();
            }
            List list = MCUtils.getLazyParseQNames(messageContext);
            if (list != null && list.contains(qName = QNameTable.createQName(string, string2))) {
                try {
                    InputStream inputStream = deserializationContext.getLazyParse();
                    if (inputStream != null) {
                        WebServicesInputSource webServicesInputSource = WebServicesInputSource.create(inputStream);
                        if (messageContext.getCurrentMessage() != null) {
                            String string4 = messageContext.getCurrentMessage().getCharacterEncoding();
                            webServicesInputSource.setEncoding(string4);
                        }
                        this.myElement.setAlternateContent(XMLInputSourceAlternateContent.createContentOnly(webServicesInputSource));
                    }
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.startElement", "178", this);
                    throw new SAXException(sOAPException);
                }
            }
        }
        deserializationContext.setSimpleEventOptimization(false);
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        boolean bl;
        QName qName;
        this.myChildElement = null;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPBodyBuilder::onStartChild() " + string + " " + string2);
        }
        QName qName2 = QNameTable.createQName(string, string2);
        MessageContext messageContext = deserializationContext.getMessageContext();
        Message message = null;
        if (messageContext != null) {
            message = messageContext.getCurrentMessage();
        }
        boolean bl2 = messageContext != null && messageContext.getPastPivot() || message != null && MessageType.RESPONSE == message.getMessageType();
        boolean bl3 = true;
        QName qName3 = this.myElement.getSOAPFactory().getSOAPConstants().getEncodingRootQName();
        String string4 = attributes.getValue(qName3.getNamespaceURI(), qName3.getLocalPart());
        if (string4 != null && string4.equals("0")) {
            bl3 = false;
        }
        boolean bl4 = string2.equals((qName = this.myElement.getSOAPFactory().getSOAPConstants().getFaultQName()).getLocalPart()) && string.equals(qName.getNamespaceURI());
        boolean bl5 = this.streaming || messageContext != null && !messageContext.isHighFidelity() && !bl4 && (messageContext.isClient() && bl2 || messageContext.isServer() && !bl2);
        boolean bl6 = false;
        if (messageContext != null) {
            bl6 = messageContext.isDisableSOAPElementLazyParse();
        }
        if (messageContext != null && messageContext.getMessage() != null) {
            boolean bl7 = bl5 = bl5 && messageContext.getMessage().countAttachments() == 0;
        }
        if (log.isDebugEnabled()) {
            log.debug("HighFidelity is:" + (messageContext != null && messageContext.isHighFidelity()));
            log.debug("tryStreaming is:" + bl5);
        }
        OperationDesc[] operationDescArray = null;
        try {
            if (messageContext != null && messageContext.getOperation() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Operation found in MessageContext:" + messageContext.getOperation().toString());
                }
                operationDescArray = new OperationDesc[]{messageContext.getOperation()};
            }
            if (bl5 && operationDescArray == null && (operationDescArray = RequestResponse.getPossibleOperationsByQName(qName2, messageContext)) != null && operationDescArray.length == 1) {
                messageContext.setOperation(operationDescArray[0]);
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.onStartChild", "262", this);
            throw new SAXException(webServicesFault);
        }
        boolean bl8 = bl = operationDescArray != null && operationDescArray.length == 1 && RequestResponse.isNoDataBindingOperation(operationDescArray[0]);
        if (bl5) {
            boolean bl9;
            boolean bl10 = bl9 = operationDescArray != null && operationDescArray.length == 1 && operationDescArray[0].getName() != null && (!bl2 && operationDescArray[0].getNumInParams(false) == 0 || bl2 && operationDescArray[0].getNumOutParams(false) == 0);
            if (!bl9) {
                bl5 = false;
                if (log.isDebugEnabled()) {
                    log.debug("tryStreaming is change to:" + bl5);
                }
            }
        }
        try {
            if (bl3 && ((SOAPBody)this.myElement).getRequestResponse() == null && !bl && !this.myElement.isInAsSOAPElement() && bl5) {
                this.streaming = true;
                RequestResponse requestResponse = new RequestResponse(string, string2, (SOAPBody)this.myElement, bl2, operationDescArray, deserializationContext);
                requestResponse.setNeedDeser(false);
                RequestResponseProcessor requestResponseProcessor = new RequestResponseProcessor(requestResponse, bl2);
                requestResponseProcessor.setOperation(operationDescArray[0]);
                messageContext.setOperation(operationDescArray[0]);
                Style style = operationDescArray[0].getStyle();
                if (style != Style.DOCUMENT) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SOAPBodyBuilder::onStartChild() case: normal streaming");
                    }
                    return requestResponseProcessor;
                }
                deserializationContext.getEventConverter().popDEventProcessor();
                deserializationContext.getEventConverter().pushDEventProcessor(requestResponseProcessor);
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: pure doc/lit streaming");
                }
                return requestResponseProcessor.onStartChild(string, string2, string3, attributes, mappingScope, deserializationContext);
            }
            if (this.streaming) {
                Deserializer deserializer;
                deserializationContext.setSimpleEventOptimization(true);
                String string5 = AttributeUtils.getID(attributes);
                if (string5 != null && (deserializer = deserializationContext.getHrefTable().unregisterFixupByID(string5)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SOAPBodyBuilder::onStartChild() case: streaming multi-ref");
                    }
                    return deserializer;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: streaming multi-ref possible error");
                }
                return new DefaultDeserializer();
            }
            SOAPBuilder sOAPBuilder = null;
            if (bl4) {
                sOAPBuilder = new SOAPFaultBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPFault(string3, attributes, mappingScope, deserializationContext, (SOAPBody)this.myElement);
            } else {
                sOAPBuilder = new SOAPBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPBodyElement(string, string2, string3, attributes, mappingScope, deserializationContext, (SOAPBody)this.myElement);
            }
            if (bl3 && ((SOAPBody)this.myElement).getRequestResponse() == null) {
                RequestResponse requestResponse = new RequestResponse(string, string2, (SOAPBody)this.myElement, bl2, operationDescArray, deserializationContext);
            }
            sOAPBuilder.setMyElement(this.myChildElement);
            if (bl && !bl4 && !bl6) {
                int n = operationDescArray == null || operationDescArray[0].getStyle() == Style.DOCUMENT ? 1 : 2;
                sOAPBuilder.setLazyParseLevel(n);
                if (log.isDebugEnabled()) {
                    log.debug("lazyParseLevel set to " + n);
                }
            } else {
                deserializationContext.setSimpleEventOptimization(true);
            }
            if (log.isDebugEnabled()) {
                if (bl4) {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: normal nonstreaming fault path");
                } else {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: normal nonstreaming path");
                }
            }
            return sOAPBuilder;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.onStartChild", "418", this);
            throw new SAXException(sOAPException);
        }
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.myElement.getAlternateContent() != null || ((SOAPBody)this.myElement).getRequestResponse() != null) {
            return;
        }
        MessageContext messageContext = deserializationContext.getMessageContext();
        Message message = null;
        SOAPPort sOAPPort = null;
        SOAPBody sOAPBody = (SOAPBody)this.myElement;
        RequestResponse requestResponse = null;
        if (messageContext != null) {
            sOAPPort = messageContext.getPort();
            message = messageContext.getCurrentMessage();
            try {
                if (sOAPBody.getRequestResponse() == null && !this.containsChild) {
                    OperationDesc operationDesc;
                    boolean bl = messageContext != null && messageContext.getPastPivot() || message != null && MessageType.RESPONSE == message.getMessageType();
                    String string3 = "";
                    String string4 = "empty";
                    OperationDesc[] operationDescArray = null;
                    if (messageContext != null && messageContext.getOperation() != null && (operationDesc = messageContext.getOperation()) != null) {
                        operationDescArray = new OperationDesc[]{operationDesc};
                        string3 = operationDesc.getElementQName().getNamespaceURI();
                        string4 = operationDesc.getElementQName().getLocalPart();
                    }
                    requestResponse = new RequestResponse(string3, string4, (SOAPBody)this.myElement, bl, operationDescArray, deserializationContext);
                }
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.endElement", "520", this);
                throw new SAXException(sOAPException);
            }
        }
    }

    public void characters(String string) throws SAXException {
        if (XMLUtils.isXMLWhitespace(string)) {
            if (this.streaming) {
                if (log.isDebugEnabled()) {
                    log.debug("Enter: SOAPBodyBuilder::characters() discarding whitespace (" + string + ")");
                }
            } else {
                super.characters(string);
            }
        } else {
            throw new SAXException(Messages.getMessage("nonWSDetected00", string, this.myElement.getQName().toString()));
        }
    }
}

