/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPHeader;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPHeaderBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Node;

public final class SOAPHeader
extends SOAPElement
implements IBMSOAPHeader {
    private static String emptyString = "".intern();

    SOAPHeader(SOAPFactory sOAPFactory) {
        super(sOAPFactory.getSOAPConstants().getHeaderQName().getNamespaceURI(), sOAPFactory.getSOAPConstants().getHeaderQName().getLocalPart(), sOAPFactory);
    }

    public void setParentElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        super.setParentElement((SOAPEnvelope)sOAPElement);
    }

    public javax.xml.soap.SOAPHeaderElement addHeaderElement(Name name2) throws SOAPException {
        String string = this._validateHeaderQName(name2.getURI(), name2.getPrefix(), name2.getLocalName());
        SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.createChildElement(string, name2.getLocalName(), this.soapFactory);
        sOAPHeaderElement.setPrefix(name2.getPrefix());
        sOAPHeaderElement = (SOAPHeaderElement)this.addChildElement(sOAPHeaderElement);
        return sOAPHeaderElement;
    }

    public Iterator examineHeaderElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string == null ? emptyString : string);
        return this.getHeadersByActors(arrayList).iterator();
    }

    public Iterator extractHeaderElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string == null ? emptyString : string);
        Vector vector = this.getHeadersByActors(arrayList);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((SOAPHeaderElement)iterator.next()).detachNode();
        }
        return vector.iterator();
    }

    public Iterator examineAllHeaderElements() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPHeaderElement)) continue;
            arrayList.add(node);
        }
        return arrayList.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String string) {
        if (string == null) {
            string = emptyString;
        }
        ArrayList<SOAPHeaderElement> arrayList = new ArrayList<SOAPHeaderElement>();
        Iterator iterator = this.getChildElements();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement;
            Node node = (Node)iterator.next();
            if (!(node instanceof SOAPHeaderElement) || !(sOAPHeaderElement = (SOAPHeaderElement)node).getMustUnderstand() || !sOAPHeaderElement.getActor().equals(string)) continue;
            arrayList.add(sOAPHeaderElement);
        }
        return arrayList.iterator();
    }

    public Iterator extractAllHeaderElements() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPHeaderElement)) continue;
            arrayList.add(node);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)arrayList.get(i);
            sOAPHeaderElement.detachNode();
        }
        return arrayList.iterator();
    }

    public Vector getHeadersByActors(Collection collection) {
        Vector<SOAPHeaderElement> vector = new Vector<SOAPHeaderElement>();
        if (collection != null && collection.size() > 0) {
            Iterator iterator = this.getChildElements();
            while (iterator.hasNext()) {
                SOAPHeaderElement sOAPHeaderElement;
                String string;
                Node node = (Node)iterator.next();
                if (!(node instanceof SOAPHeaderElement) || !collection.contains(string = (sOAPHeaderElement = (SOAPHeaderElement)node).getActor())) continue;
                vector.add(sOAPHeaderElement);
            }
        }
        return vector;
    }

    public SOAPHeaderElement getHeaderByName(String string, String string2, boolean bl) throws SOAPException {
        return (SOAPHeaderElement)this.getChildElement(string, string2);
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPHeaderBuilder();
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        this._validateHeaderQName(string, null, string2);
        return new SOAPHeaderElement(string, string2, sOAPFactory);
    }

    protected boolean isValidSAAJChild(Node node) {
        Class<?> clazz = node.getClass();
        return (clazz.equals(SOAPHeaderElement.class) || clazz.equals(Text.class) || clazz.equals(Comment.class) || clazz.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public javax.xml.soap.SOAPHeaderElement addHeaderElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addHeaderElement(QName)", "javax.xml.soap.SOAPHeader"));
        }
        String string = this._validateHeaderQName(qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalPart());
        SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.createChildElement(string, qName.getLocalPart(), this.soapFactory);
        sOAPHeaderElement.setPrefix(qName.getPrefix());
        sOAPHeaderElement = (SOAPHeaderElement)this.addChildElement(sOAPHeaderElement);
        return sOAPHeaderElement;
    }

    private String _validateHeaderQName(String string, String string2, String string3) throws SOAPException {
        if (disableSOAPNamespaceValidation) {
            return string;
        }
        String string4 = string;
        if (string == null || string.equals("")) {
            if (string2 == null || string2.equals("")) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", "SOAPHeaderElement", string3, string2, string));
            }
            Mapping mapping = this._getMappingScope().getMappingForPrefix(string2, false);
            if (mapping == null) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", "SOAPHeaderElement", string3, string2, string));
            }
            string4 = mapping.getNamespaceURI();
        }
        return string4;
    }

    public javax.xml.soap.SOAPHeaderElement addNotUnderstoodHeaderElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addNotUnderstoodHeaderElement(QName)", "javax.xml.soap.SOAPHeader"));
        }
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        if (!sOAPConstants.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "addNotUnderstoodHeaderElement(QName)", "javax.xml.soap.Header", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        QName qName2 = new QName(sOAPConstants.getNotUnderstoodHeaderQName().getNamespaceURI(), sOAPConstants.getNotUnderstoodHeaderQName().getLocalPart(), this.getPrefix());
        SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.addHeaderElement(qName2);
        String string = sOAPHeaderElement.getNamespaceURI(qName.getPrefix());
        if (!qName.getNamespaceURI().equals(string)) {
            sOAPHeaderElement.addNamespaceDeclaration(qName.getPrefix(), qName.getNamespaceURI());
        }
        sOAPHeaderElement.setAttribute("qname", qName.getPrefix() + ":" + qName.getLocalPart());
        return sOAPHeaderElement;
    }

    public javax.xml.soap.SOAPHeaderElement addUpgradeHeaderElement(Iterator iterator) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addUpgradeHeaderElement(QName)", "javax.xml.soap.SOAPHeader"));
        }
        SOAPConstants sOAPConstants = this.soapFactory.getSOAPConstants();
        QName qName = new QName(sOAPConstants.getUpgradeHeaderQName().getNamespaceURI(), sOAPConstants.getUpgradeHeaderQName().getLocalPart(), this.getPrefix());
        SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.addHeaderElement(qName);
        while (iterator.hasNext()) {
            String string;
            SOAPElement sOAPElement;
            String string2;
            String string3 = (String)iterator.next();
            if (!string3.equals(string2 = (sOAPElement = (SOAPElement)sOAPHeaderElement.addChildElement(sOAPConstants.getSupportedEnvelopeElementQName().getLocalPart(), this.getPrefix(), sOAPConstants.getSupportedEnvelopeElementQName().getNamespaceURI())).getNamespaceURI(string = "upgrade"))) {
                sOAPElement.addNamespaceDeclaration(string, string3);
            }
            sOAPElement.setAttribute("qname", string + ":Envelope");
        }
        return sOAPHeaderElement;
    }

    public javax.xml.soap.SOAPHeaderElement addUpgradeHeaderElement(String[] stringArray) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addUpgradeHeaderElement(Sgtring[])", "javax.xml.soap.SOAPHeader"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return this.addUpgradeHeaderElement(arrayList.iterator());
    }

    public javax.xml.soap.SOAPHeaderElement addUpgradeHeaderElement(String string) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addUpgradeHeaderElement(String)", "javax.xml.soap.SOAPHeader"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return this.addUpgradeHeaderElement(arrayList.iterator());
    }

    public javax.xml.soap.SOAPElement addTextNode(String string) throws SOAPException {
        if (this.isSOAP12() && !XMLUtils.isXMLWhitespace(string)) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addTextNode(String)", "javax.xml.soap.SOAPHeader"));
        }
        return super.addTextNode(string);
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addEncodingStyle(String)", "javax.xml.soap.SOAPHeader"));
        }
        super.setEncodingStyle(string);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPHeader"));
        }
        if (!qName.getNamespaceURI().equals(this.getNamespaceURI()) || !qName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPHeader"));
        }
        return super.setElementQName(qName);
    }
}

