/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPEnvelope;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;

public final class SOAPEnvelope
extends SOAPElement
implements IBMSOAPEnvelope {
    protected static Log log = LogFactory.getLog(SOAPEnvelope.class.getName());

    SOAPEnvelope(SOAPFactory sOAPFactory) throws SOAPException {
        this(false, sOAPFactory);
    }

    SOAPEnvelope(boolean bl, SOAPFactory sOAPFactory) throws SOAPException {
        super(sOAPFactory.getSOAPConstants().getEnvelopeQName().getNamespaceURI(), sOAPFactory.getSOAPConstants().getEnvelopeQName().getLocalPart(), sOAPFactory);
        this.setPrefix(sOAPFactory.getSOAPConstants().getEnvelopePrefix());
        if (bl) {
            this.bootstrap();
        }
        this.addHeader();
        this.addBody();
        sOAPFactory.getOwnerDocument().appendChild(this);
    }

    private void bootstrap() throws SOAPException {
        this.addNamespaceDeclaration(this.soapFactory.getSOAPConstants().getEnvelopePrefix(), this.soapFactory.getSOAPConstants().getEnvelopeURI());
        this.addNamespaceDeclaration(this.soapFactory.getSOAPConstants().getEncodingPrefix(), this.soapFactory.getSOAPConstants().getEncodingURI());
        this.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public javax.xml.soap.SOAPBody addBody() throws SOAPException {
        SOAPBody sOAPBody = (SOAPBody)this.getBody();
        if (sOAPBody == null) {
            sOAPBody = new SOAPBody(this.soapFactory);
            sOAPBody.setPrefix(this.getPrefix());
            sOAPBody = (SOAPBody)this.addChildElement(sOAPBody);
            return sOAPBody;
        }
        throw new SOAPException(Messages.getMessage("bodyPresent"));
    }

    public javax.xml.soap.SOAPHeader addHeader() throws SOAPException {
        SOAPHeader sOAPHeader = (SOAPHeader)this.getHeader();
        if (sOAPHeader == null) {
            sOAPHeader = new SOAPHeader(this.soapFactory);
            sOAPHeader.setPrefix(this.getPrefix());
            sOAPHeader = (SOAPHeader)this.insertBefore(sOAPHeader, this.getBody());
            return sOAPHeader;
        }
        throw new SOAPException(Messages.getMessage("headerPresent"));
    }

    public javax.xml.soap.Name createName(String string) throws SOAPException {
        return new Name("", string, "");
    }

    public javax.xml.soap.Name createName(String string, String string2, String string3) throws SOAPException {
        return new Name(string3, string, string2);
    }

    public javax.xml.soap.SOAPBody getBody() throws SOAPException {
        Node node;
        for (node = this.getFirstChild(); node != null && !(node instanceof SOAPBody); node = node.getNextSibling()) {
        }
        return (SOAPBody)node;
    }

    public javax.xml.soap.SOAPHeader getHeader() throws SOAPException {
        Node node;
        for (node = this.getFirstChild(); node != null && !(node instanceof SOAPHeader); node = node.getNextSibling()) {
        }
        return (SOAPHeader)node;
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement instanceof SOAPHeader) {
            SOAPHeader sOAPHeader = (SOAPHeader)this.getHeader();
            if (sOAPHeader != null && sOAPHeader != sOAPElement) {
                sOAPHeader.detachNode();
            }
            sOAPElement = super.addChildElement(sOAPElement);
            return sOAPElement;
        }
        if (sOAPElement instanceof SOAPBody) {
            SOAPBody sOAPBody = (SOAPBody)this.getBody();
            if (sOAPBody != null && sOAPBody != sOAPElement) {
                sOAPBody.detachNode();
            }
            sOAPElement = super.addChildElement(sOAPElement);
            return sOAPElement;
        }
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("addChildElement2Err00", sOAPElement.getClass().getName(), this.getClass().getName()));
        }
        sOAPElement = super.addChildElement(sOAPElement);
        return sOAPElement;
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPEnvelopeBuilder(this);
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        QName qName = this.soapFactory.getSOAPConstants().getBodyQName();
        QName qName2 = this.soapFactory.getSOAPConstants().getHeaderQName();
        if (qName.getNamespaceURI().equals(string) && qName.getLocalPart().equals(string2)) {
            return new SOAPBody(sOAPFactory);
        }
        if (qName2.getNamespaceURI().equals(string) && qName2.getLocalPart().equals(string2)) {
            return new SOAPHeader(sOAPFactory);
        }
        return super.createChildElement(string, string2, sOAPFactory);
    }

    protected boolean isValidSAAJChild(Node node) {
        QName qName = this.soapFactory.getSOAPConstants().getBodyQName();
        QName qName2 = this.soapFactory.getSOAPConstants().getHeaderQName();
        Class<?> clazz = node.getClass();
        if (node.getClass().equals(SOAPElement.class)) {
            SOAPElement sOAPElement = (SOAPElement)node;
            if (this.getNamespaceURI().equals(sOAPElement.getNamespaceURI()) && (qName.getLocalPart().equals(sOAPElement.getLocalName()) || qName2.getLocalPart().equals(sOAPElement.getLocalName()))) {
                return false;
            }
        }
        return (clazz.equals(SOAPBody.class) || clazz.equals(SOAPHeader.class) || clazz.equals(SOAPElement.class) || clazz.equals(Text.class) || clazz.equals(Comment.class) || clazz.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    protected void outputImpl(SerializationContext serializationContext, boolean bl) throws Exception {
        try {
            super.outputImpl(serializationContext, bl);
        }
        catch (Exception exception) {
            throw MCUtils.interceptSerializationException(exception, serializationContext);
        }
    }

    public javax.xml.soap.SOAPElement addTextNode(String string) throws SOAPException {
        if (this.isSOAP12() && !XMLUtils.isXMLWhitespace(string)) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addTextNode(String)", "javax.xml.soap.SOAPEnvelope"));
        }
        return super.addTextNode(string);
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setEncodingStyle(String)", "javax.xml.soap.SOAPEnvelope"));
        }
        super.setEncodingStyle(string);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPEnvelope"));
        }
        if (!qName.getNamespaceURI().equals(this.getNamespaceURI()) || !qName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPEnvelope"));
        }
        return super.setElementQName(qName);
    }
}

