/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPBody;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPBody
extends SOAPElement
implements IBMSOAPBody {
    SOAPBody(SOAPFactory sOAPFactory) {
        super(sOAPFactory.getSOAPConstants().getBodyQName().getNamespaceURI(), sOAPFactory.getSOAPConstants().getBodyQName().getLocalPart(), sOAPFactory);
    }

    public RequestResponse getRequestResponse() {
        return this.altContent == null ? null : this.altContent.asRequestResponse();
    }

    public void setParentElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            super.setParentElement((SOAPEnvelope)sOAPElement);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.xmlsoap.SOAPBody.setParentElement", "152", this);
            throw new SOAPException(throwable);
        }
    }

    public javax.xml.soap.SOAPBodyElement addBodyElement(Name name2) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)this.createChildElement(name2.getURI(), name2.getLocalName(), this.soapFactory);
        sOAPBodyElement.setPrefix(name2.getPrefix());
        sOAPBodyElement = (SOAPBodyElement)this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public javax.xml.soap.SOAPBodyElement addDocument(Document document) throws SOAPException {
        Element element = document.getDocumentElement();
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(element, this.soapFactory);
        sOAPBodyElement = (SOAPBodyElement)this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public javax.xml.soap.SOAPFault addFault() throws SOAPException {
        SOAPFault sOAPFault = this.soapFactory.createSOAPFault();
        sOAPFault.setPrefix(this.getPrefix());
        sOAPFault = (SOAPFault)this.addChildElement(sOAPFault);
        sOAPFault.setFaultCode(this.soapFactory.getSOAPConstants().getDefaultFaultCode());
        return sOAPFault;
    }

    public javax.xml.soap.SOAPFault addFault(Name name2, String string, Locale locale) throws SOAPException {
        SOAPFault sOAPFault = this.soapFactory.createSOAPFault();
        sOAPFault.setPrefix(this.getPrefix());
        sOAPFault = (SOAPFault)this.addChildElement(sOAPFault);
        sOAPFault.setFaultCode(name2);
        sOAPFault.setFaultString(string, locale);
        return sOAPFault;
    }

    public javax.xml.soap.SOAPFault addFault(Name name2, String string) throws SOAPException {
        return this.addFault(name2, string, null);
    }

    public javax.xml.soap.SOAPFault getFault() {
        Node node;
        for (node = this.getFirstChild(); node != null && !(node instanceof SOAPFault); node = node.getNextSibling()) {
        }
        return (SOAPFault)node;
    }

    public boolean hasFault() {
        return this.getFault() != null;
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPBodyBuilder();
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        QName qName = sOAPFactory.getSOAPConstants().getFaultQName();
        if (qName.getNamespaceURI().equals(string) && qName.getLocalPart().equals(string2)) {
            return new SOAPFault(sOAPFactory);
        }
        if (string == null || string.length() == 0) {
            return new SOAPBodyElement(null, string2, sOAPFactory);
        }
        return new SOAPBodyElement(string, string2, sOAPFactory);
    }

    protected boolean isValidSAAJChild(Node node) {
        Class<?> clazz = node.getClass();
        boolean bl = (clazz.equals(SOAPBodyElement.class) || clazz.equals(SOAPFault.class) || clazz.equals(Text.class) || clazz.equals(Comment.class) || clazz.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
        return bl;
    }

    protected boolean isObjectContent() throws Exception {
        Object object = this.getAlternateContent();
        if (object == null || object instanceof RequestResponse) {
            return false;
        }
        return super.isObjectContent();
    }

    public javax.xml.soap.SOAPFault addFault(QName qName, String string, Locale locale) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addFault(QName, String, Locale)", "javax.xml.soap.SOAPBody"));
        }
        SOAPFault sOAPFault = this.soapFactory.createSOAPFault();
        sOAPFault.setPrefix(this.getPrefix());
        sOAPFault = (SOAPFault)this.addChildElement(sOAPFault);
        sOAPFault.setFaultCode(qName);
        sOAPFault.setFaultString(string, locale);
        return sOAPFault;
    }

    public javax.xml.soap.SOAPFault addFault(QName qName, String string) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addFault(QName, String)", "javax.xml.soap.SOAPBody"));
        }
        return this.addFault(qName, string, null);
    }

    public javax.xml.soap.SOAPBodyElement addBodyElement(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addBodyElement(QName, String)", "javax.xml.soap.SOAPBody"));
        }
        SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)this.createChildElement(qName.getNamespaceURI(), qName.getLocalPart(), this.soapFactory);
        sOAPBodyElement.setPrefix(qName.getPrefix());
        sOAPBodyElement = (SOAPBodyElement)this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public Document extractContentAsDocument() throws SOAPException {
        Node node;
        SOAPElement sOAPElement = null;
        Iterator iterator = this.getChildElements();
        if (!iterator.hasNext()) {
            throw new SOAPException(Messages.getMessage("extractContentAsDocument", "0"));
        }
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            if (!(node instanceof SOAPElement)) continue;
            if (sOAPElement != null) {
                throw new SOAPException(Messages.getMessage("extractContentAsDocument", ">1"));
            }
            sOAPElement = (SOAPElement)node;
        }
        if (sOAPElement == null) {
            throw new SOAPException(Messages.getMessage("extractContentAsDocument", "0"));
        }
        sOAPElement.detachNode();
        node = new SOAPDocument();
        Node node2 = node.importNode(sOAPElement, true);
        node.appendChild(node2);
        return node;
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setEncodingStyle(String)", "javax.xml.soap.SOAPBody"));
        }
        super.setEncodingStyle(string);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPBody"));
        }
        if (!qName.getNamespaceURI().equals(this.getNamespaceURI()) || !qName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPBody"));
        }
        return super.setElementQName(qName);
    }
}

