/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils.bytecode;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class ParamNameExtractor {
    protected static Log log = LogFactory.getLog(ParamNameExtractor.class.getName());

    public static String[] getParameterNamesFromDebugInfo(Method method) {
        int n = method.getParameterTypes().length;
        if (n == 0) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        try {
            ParamReader paramReader = new ParamReader(clazz);
            String[] stringArray = paramReader.getParameterNames(method);
            return stringArray;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor.getParameterNamesFromDebugInfo", "98");
            log.info(Messages.getMessage("error00") + ":" + iOException);
            return null;
        }
    }

    public static String[] getParameterNamesFromDebugInfo(Constructor constructor) {
        int n = constructor.getParameterTypes().length;
        if (n == 0) {
            return null;
        }
        Class clazz = constructor.getDeclaringClass();
        try {
            ParamReader paramReader = new ParamReader(clazz);
            String[] stringArray = paramReader.getParameterNames(constructor);
            return stringArray;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor.getParameterNamesFromDebugInfo", "98");
            log.info(Messages.getMessage("error00") + ":" + iOException);
            return null;
        }
    }
}

