/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.transport.http.CookieValueList;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HTTPCookieManager
implements SessionContext {
    private static final TraceComponent _tc = Tr.register(HTTPCookieManager.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private HashMap chM = null;
    private String cookie_name = null;
    private CookieValueList cvs = null;

    public HTTPCookieManager(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPCookieManager ctor()");
        }
        this.chM = new HashMap();
        this.setCookies(string, string2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPCookieManager ctor() this : " + this);
        }
    }

    public static boolean newCookieHandling() {
        boolean bl = false;
        String string = System.getProperty("UseNewCookieHandling");
        if (string != null) {
            bl = Boolean.valueOf(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of UseNewCookieHandling: " + string);
            }
        }
        return bl;
    }

    public void setCookies(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCookies this : " + this);
        }
        if (JavaUtils.hasValue(string)) {
            this.cookie_name = HTTPConstants.HEADER_SET_COOKIE;
            this.parseCookieandStore(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, this.cookie_name + " stored : " + string);
            }
        }
        if (JavaUtils.hasValue(string2)) {
            this.cookie_name = HTTPConstants.HEADER_SET_COOKIE2;
            this.parseCookieandStore(string2);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, this.cookie_name + " stored : " + string2);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "cookie LIST " + this.printCookieSet());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCookies");
        }
    }

    public String getCookie(String string, String string2, int n, boolean bl) {
        String string3;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCookie() this : " + this);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.chM.keySet();
        Iterator iterator = set.iterator();
        stringBuffer.append("$Version=\"1\";");
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            CookieValueList cookieValueList = (CookieValueList)this.chM.get(string3);
            stringBuffer.append(cookieValueList.getList(string, string2, n, bl));
        }
        string3 = stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCookie() : " + string3);
        }
        return string3;
    }

    public String printCookieSet() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.chM.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            CookieValueList cookieValueList = (CookieValueList)this.chM.get(string);
            stringBuffer.append(cookieValueList.printList());
        }
        if (stringBuffer.toString() == null || stringBuffer.toString().equals("")) {
            return "";
        }
        string = stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        return string;
    }

    protected List splitMultipleCookies(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                ++n;
            }
            if (c != ',' || n % 2 != 0) continue;
            arrayList.add(string.substring(n2, i));
            n2 = i + 1;
        }
        arrayList.add(string.substring(n2));
        return arrayList;
    }

    protected void parseCookieandStore(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseCookieandStore() this : " + this);
        }
        if (string != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "cookie Received : " + string);
            }
            List list = this.splitMultipleCookies(string);
            String string2 = null;
            for (int i = 0; i < list.size(); ++i) {
                string2 = (String)list.get(i);
                this.cvs = null;
                int n = string2.indexOf(HTTPConstants.ATTR_TOKEN_SEPARATOR);
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if (string3 == null) continue;
                int n2 = string3.indexOf(HTTPConstants.ATTR_VALUE_SEPARATOR);
                String string5 = string3.substring(0, n2).trim();
                String string6 = string3.substring(n2 + 1).trim();
                if (string5 == null) continue;
                if (this.chM != null) {
                    Set set = this.chM.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string7 = (String)iterator.next();
                        if (string5.compareTo(string7) != 0) continue;
                        this.cvs = (CookieValueList)this.chM.get(string7);
                        break;
                    }
                }
                if (this.cvs == null) {
                    this.cvs = new CookieValueList(this.cookie_name);
                }
                this.cvs.setCookieNameValue(string5, string6);
                this.cvs.setCookie(string4);
                this.chM.put(string5, this.cvs);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Stored cookie");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseCookieandStore()");
        }
    }
}

