/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.StringTokenizer;

public class CookieValueItem {
    private static final TraceComponent _tc = Tr.register(CookieValueItem.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private String cookie_name;
    private long cookieCreateTime = 0L;
    private String cookieValue = null;
    private String Comment = null;
    private String CommentURL = null;
    private boolean Discard = false;
    private String Domain = null;
    private long Max_Age = -1L;
    private String Path = null;
    private String PortList = null;
    private boolean Secure = false;
    private String Version = null;

    public CookieValueItem(String string) {
        this.cookie_name = string;
        this.cookieCreateTime = System.currentTimeMillis();
    }

    public void setCookieValue(String string) {
        this.cookieValue = string;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public void setComment(String string) {
        this.Comment = string;
    }

    public String getComment() {
        return this.Comment;
    }

    public void setCommentURL(String string) {
        this.CommentURL = string;
    }

    public String getCommentURL() {
        return this.CommentURL;
    }

    public void setDiscard(boolean bl) {
        this.Discard = bl;
    }

    public boolean getDiscard() {
        return this.Discard;
    }

    public void setDomain(String string) {
        this.Domain = string;
    }

    public String getDomain() {
        return this.Domain;
    }

    public void setMax_Age(long l) {
        this.Max_Age = l;
    }

    public long getMax_Age() {
        return this.Max_Age;
    }

    public void setPath(String string) {
        this.Path = string;
    }

    public String getPath() {
        return this.Path;
    }

    public void setPortList(String string) {
        this.PortList = string;
    }

    public String getPortList() {
        return this.PortList;
    }

    public void setSecure(boolean bl) {
        this.Secure = bl;
    }

    public boolean getSecure() {
        return this.Secure;
    }

    public void setVersion(String string) {
        this.Version = string;
    }

    public String getVersion() {
        return this.Version;
    }

    public boolean hasExpired() {
        if (this.Max_Age == 0L) {
            return true;
        }
        if (this.Max_Age == -1L) {
            return false;
        }
        long l = System.currentTimeMillis() - this.cookieCreateTime;
        return l > this.Max_Age;
    }

    public boolean setCookie(String string) {
        if (string != null) {
            String string2 = null;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, HTTPConstants.ATTR_TOKEN_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf(HTTPConstants.ATTR_VALUE_SEPARATOR);
                if (string4.contains(HTTPConstants.ATTR_VALUE_SEPARATOR)) {
                    string3 = string4.substring(0, n).trim();
                    string2 = string4.substring(n + 1).trim();
                } else {
                    string3 = string4;
                }
                if (string2 == null) continue;
                if (string3.equals("Comment")) {
                    this.setComment(string2);
                    continue;
                }
                if (string3.equals("CommentURL")) {
                    this.setCommentURL(string2);
                    continue;
                }
                if (string3.equals("Discard")) {
                    this.setDiscard(true);
                    continue;
                }
                if (string3.equals("Domain")) {
                    this.setDomain(string2);
                    continue;
                }
                if (string3.equals("Max-Age")) {
                    long l = Long.parseLong(string2);
                    if (l == 0L) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Max-Age is 0. So not storing");
                        }
                        return false;
                    }
                    this.setMax_Age(l * 1000L);
                    continue;
                }
                if (string3.equals("Path")) {
                    this.setPath(string2);
                    continue;
                }
                if (string3.equals("Port")) {
                    this.setPortList(string2);
                    continue;
                }
                if (string3.equals("Secure")) {
                    this.setSecure(true);
                    continue;
                }
                if (!string3.equals("Version")) continue;
                this.setVersion(string2);
            }
        }
        return true;
    }

    public boolean doesDomainMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = string.equalsIgnoreCase(".local");
        int n = string.indexOf(46);
        if (n == 0) {
            n = string.indexOf(46, 1);
        }
        if (!(bl || n != -1 && n != string.length() - 1)) {
            return false;
        }
        int n2 = string2.indexOf(46);
        if (n2 == -1 && bl) {
            return true;
        }
        int n3 = string.length();
        int n4 = string2.length() - n3;
        if (n4 == 0) {
            return string2.equalsIgnoreCase(string);
        }
        if (n4 > 0) {
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4);
            return string3.indexOf(46) == -1 && string4.equalsIgnoreCase(string);
        }
        if (n4 == -1) {
            return string.charAt(0) == '.' && string2.equalsIgnoreCase(string.substring(1));
        }
        return false;
    }

    public String printList() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.cookieValue);
        if (this.Comment != null) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Comment" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Comment);
        }
        if (this.CommentURL != null) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "CommentURL" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.CommentURL);
        }
        if (this.Discard) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Discard");
        }
        if (this.Domain != null) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Domain" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Domain);
        }
        if (this.Max_Age != -1L) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Max-Age" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Max_Age);
        }
        if (this.Path != null) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Path" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Path);
        }
        if (this.PortList != null) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Port" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.PortList);
        }
        if (this.Secure) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Secure");
        }
        if (this.Version != null) {
            stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Version" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Version);
        }
        return stringBuffer.toString();
    }

    private boolean checkCookieRules() {
        return true;
    }

    private boolean checkCookie2rules() {
        return false;
    }

    boolean isPortInPortList(int n) {
        String string = this.getPortList();
        if (string == null) {
            return false;
        }
        string = string.substring(1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, HTTPConstants.HEADER_TOKEN_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.valueOf(string2);
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getList(String string, int n, boolean bl) {
        StringBuffer stringBuffer;
        block15: {
            String string2;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getList secure : " + bl);
            }
            stringBuffer = new StringBuffer();
            if (this.getSecure() && !bl) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Stored cookie is secure cookie");
                }
                return null;
            }
            stringBuffer.append(this.cookieValue);
            String string3 = this.getPath();
            if (string3 != null) {
                stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "$Path" + HTTPConstants.ATTR_VALUE_SEPARATOR + string3);
            }
            if ((string2 = this.getDomain()) != null) {
                if (this.doesDomainMatch(string2, string)) {
                    stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "$Domain" + HTTPConstants.ATTR_VALUE_SEPARATOR + string2);
                    break block15;
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Host : " + string + " does not match domain in stored cookie : " + string2);
                    }
                    return null;
                }
            }
            if (this.cookie_name == HTTPConstants.HEADER_SET_COOKIE2) {
                boolean bl2;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Cookie is : " + HTTPConstants.HEADER_SET_COOKIE2 + " checking port information");
                }
                if (bl2 = this.isPortInPortList(n)) {
                    stringBuffer.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "$Port" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.getPortList());
                } else if (JavaUtils.hasValue(this.PortList)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "port : " + n + " is not in port list : " + this.PortList);
                    }
                    return null;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getList");
        }
        return stringBuffer.toString();
    }
}

