/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.soap;

import com.ibm.websphere.webservices.soap.IBMSOAPConnection;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;

public class SOAPConnectionImpl
extends IBMSOAPConnection {
    protected static Log log;
    boolean closed = false;
    public static boolean forceLegacyDispatch;
    private Class cache_JAXWSDispatchClass = null;
    private Method cache_callMethod = null;

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        return this.call(sOAPMessage, object, this.useMaelstromEngine(sOAPMessage));
    }

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object, boolean bl) throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        try {
            MessageContext messageContext;
            block8: {
                if (!bl) {
                    return this.callJAXWSDispatch(sOAPMessage, object);
                }
                Service service = new Service();
                messageContext = new MessageContext(service.getEngine());
                messageContext.setRequestMessage((Message)sOAPMessage);
                messageContext.setProperty("javax.xml.rpc.session.maintain", new Boolean(service.getMaintainSession()));
                messageContext.setProperty("SOAPConnection", new Boolean(true));
                URL uRL = new URL(object.toString());
                Connection connection = service.getConnection(uRL);
                messageContext.protectProperties();
                String[] stringArray = sOAPMessage.getMimeHeaders().getHeader("SOAPAction");
                if (stringArray != null && stringArray[0] != null) {
                    String string = stringArray[0];
                    messageContext.setUseSOAPAction(true);
                    messageContext.setSOAPActionURI(string);
                }
                try {
                    connection.invoke(messageContext);
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "145", this);
                    if (webServicesFault.isSOAPPartFault()) break block8;
                    throw webServicesFault;
                }
            }
            messageContext.resetProperties();
            return messageContext.getResponseMessage();
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "111", this);
            throw new SOAPException(malformedURLException);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.call", "114", this);
            throw new SOAPException(webServicesFault);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException(Messages.getMessage("connectionClosed00"));
        }
        this.closed = true;
    }

    public SOAPMessage get(Object object) throws SOAPException {
        SOAPMessage sOAPMessage = null;
        try {
            Object object2;
            Object object3;
            String[] stringArray;
            URL uRL = this.getEndpointAsURL(object);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRL.openStream();
            Map<String, List<String>> map = uRLConnection.getHeaderFields();
            MimeHeaders mimeHeaders = new MimeHeaders();
            if (map != null) {
                stringArray = map.entrySet().iterator();
                while (stringArray != null && stringArray.hasNext()) {
                    object3 = (Map.Entry)stringArray.next();
                    object2 = (String)object3.getKey();
                    if (object2 == null || ((String)object2).equals("")) continue;
                    List list = (List)object3.getValue();
                    Iterator iterator = list.iterator();
                    while (iterator != null && iterator.hasNext()) {
                        mimeHeaders.addHeader((String)object2, (String)iterator.next());
                    }
                }
            }
            Object object4 = object3 = (stringArray = mimeHeaders.getHeader("Content-Type")) != null ? stringArray[0] : null;
            if (object3 == null) {
                mimeHeaders.addHeader("Content-Type", SOAPConstants.SOAP11_CONSTANTS.getContentTypeValue());
            }
            object2 = MessageFactory.newInstance("Dynamic Protocol");
            sOAPMessage = ((MessageFactory)object2).createMessage(mimeHeaders, inputStream);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.get", "203", this);
            throw new SOAPException(malformedURLException);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.get", "203", this);
            throw new SOAPException(iOException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.soap.SOAPConnectionImpl.get", "332", this);
            throw new SOAPException(exception);
        }
        return sOAPMessage;
    }

    private boolean useMaelstromEngine(SOAPMessage sOAPMessage) {
        if (forceLegacyDispatch) {
            return true;
        }
        Class clazz = null;
        try {
            clazz = this.getJAXWSDispatchClass();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return clazz == null || !Utils._isSAAJ13Enabled();
    }

    private SOAPMessage callJAXWSDispatch(SOAPMessage sOAPMessage, Object object) throws SOAPException, MalformedURLException {
        SOAPMessage sOAPMessage2 = null;
        String string = this.getEndpointAsString(object);
        String string2 = this.getSOAPProtocol(sOAPMessage);
        Object object2 = this.getJAXWSDispatchInstance();
        Method method = this.getJAXWSDispatchCallMethod();
        try {
            sOAPMessage2 = (SOAPMessage)method.invoke(object2, sOAPMessage, string, string2);
        }
        catch (Exception exception) {
            if (exception instanceof SOAPException) {
                throw (SOAPException)exception;
            }
            throw new SOAPException(exception);
        }
        return sOAPMessage2;
    }

    private URL getEndpointAsURL(Object object) throws MalformedURLException {
        URL uRL = null;
        uRL = object instanceof URL ? (URL)object : (object instanceof String ? new URL((String)object) : new URL(object.toString()));
        return uRL;
    }

    private String getEndpointAsString(Object object) throws MalformedURLException {
        return this.getEndpointAsURL(object).toString();
    }

    private String getSOAPProtocol(SOAPMessage sOAPMessage) {
        String[] stringArray;
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        String[] stringArray2 = stringArray = mimeHeaders == null ? null : mimeHeaders.getHeader("Content-Type");
        if (stringArray == null || stringArray.length == 0) {
            return "SOAP 1.1 Protocol";
        }
        String string = stringArray[0];
        if (string.contains("application/soap+xml")) {
            return "SOAP 1.2 Protocol";
        }
        if (string.contains("text/xml")) {
            return "SOAP 1.1 Protocol";
        }
        return "SOAP 1.1 Protocol";
    }

    private Class getJAXWSDispatchClass() throws SOAPException {
        if (this.cache_JAXWSDispatchClass != null) {
            return this.cache_JAXWSDispatchClass;
        }
        try {
            this.cache_JAXWSDispatchClass = ClassUtils.forName("com.ibm.ws.webservices.engine.xmlsoap.saaj13only.SOAPConnectionJAXWS");
        }
        catch (Exception exception) {
            throw new SOAPException(exception);
        }
        return this.cache_JAXWSDispatchClass;
    }

    private Method getJAXWSDispatchCallMethod() throws SOAPException {
        if (this.cache_callMethod != null) {
            return this.cache_callMethod;
        }
        try {
            Class clazz = this.getJAXWSDispatchClass();
            this.cache_callMethod = clazz.getDeclaredMethod("call", SOAPMessage.class, String.class, String.class);
        }
        catch (Exception exception) {
            throw new SOAPException(exception);
        }
        return this.cache_callMethod;
    }

    private Object getJAXWSDispatchInstance() throws SOAPException {
        Class clazz = this.getJAXWSDispatchClass();
        Object var2_2 = null;
        try {
            var2_2 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new SOAPException(exception);
        }
        return var2_2;
    }

    static {
        block3: {
            log = LogFactory.getLog(SOAPConnectionImpl.class.getName());
            forceLegacyDispatch = false;
            String string = "com.ibm.ws.webservices.forceLegacyDispatchFromSOAPConnection";
            try {
                forceLegacyDispatch = MCUtils.isPropertyEnabled(string);
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg(string, forceLegacyDispatch));
                }
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception occurred obtaining and evaluating system property {" + string + "}", exception);
            }
        }
    }
}

