/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.soap;

import com.ibm.websphere.webservices.soap.IBMMessageFactory;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageFactoryImpl
extends IBMMessageFactory {
    SOAPConstants soapConstants = null;

    public MessageFactoryImpl() throws SOAPException {
        this("SOAP 1.1 Protocol");
    }

    public MessageFactoryImpl(String string) throws SOAPException {
        this.soapConstants = Utils.getSOAPConstants(string);
    }

    public SOAPMessage createMessage() throws SOAPException {
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("createMessageWDyn00"));
        }
        SOAPFactory sOAPFactory = new SOAPFactory(this.soapConstants);
        SOAPEnvelope sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
        Message message = new Message((Object)sOAPEnvelope, this.soapConstants);
        message.setMessageType(MessageType.REQUEST);
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws IOException, SOAPException {
        Object object;
        SOAPConstants sOAPConstants = this.soapConstants;
        String string = null;
        String string2 = SOAPConstants.SOAP11_CONSTANTS.getContentTypeValue();
        String string3 = SOAPConstants.SOAP12_CONSTANTS.getContentTypeValue();
        if (mimeHeaders != null) {
            object = mimeHeaders.getHeader("Content-Type");
            String string4 = string = object != null ? object[0] : null;
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            if (string == null) {
                throw new IllegalArgumentException(Messages.getMessage("invalidContentType", string, string2, string3));
            }
            if (string.indexOf(string3) >= 0) {
                sOAPConstants = SOAPConstants.SOAP12_CONSTANTS;
            } else {
                if (string.indexOf(string2) < 0) throw new IllegalArgumentException(Messages.getMessage("invalidContentType", string, string2, string3));
                sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
            }
        } else if (string != null && string.toLowerCase().indexOf("multipart/related") < 0 && string.indexOf(sOAPConstants.getContentTypeValue()) < 0) {
            throw new IllegalArgumentException(Messages.getMessage("invalidContentType", string, "multipart/related", sOAPConstants.getContentTypeValue()));
        }
        object = new Message((Object)inputStream, mimeHeaders, sOAPConstants);
        ((Message)object).setMessageType(MessageType.REQUEST);
        return object;
    }
}

