/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SimpleType;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected BeanDesc beanDesc = null;
    private static boolean hasToPlainStringMethodCache = false;
    private static Method toPlainStringMethodCache = null;
    protected static Log log = LogFactory.getLog(SimpleSerializer.class.getName());

    public SimpleSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.init();
    }

    public SimpleSerializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this.xmlType = qName;
        this.javaType = clazz;
    }

    public SimpleSerializer(Class clazz, QName qName, BeanDesc beanDesc) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.beanDesc = beanDesc;
        this.init();
    }

    protected void init() {
        if (SimpleType.class.isAssignableFrom(this.javaType)) {
            if (this.beanDesc == null) {
                this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
            }
            this.propertyDescriptor = this.beanDesc != null ? this.beanDesc.getPropertyDescriptors() : BeanUtils.getPd(this.javaType, null);
        }
    }

    void setup(BeanDesc beanDesc, BeanPropertyDescriptor[] beanPropertyDescriptorArray) {
        this.beanDesc = beanDesc;
        this.propertyDescriptor = beanPropertyDescriptorArray;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        if (object != null && object.getClass() == Object.class) {
            throw new IOException(Messages.getMessage("cantSerialize02"));
        }
        if (object instanceof SimpleType) {
            attributes = this.getObjectAttributes(object, attributes, serializationContext);
        }
        String string = null;
        if (object != null) {
            string = this.getValueAsString(object, serializationContext);
        }
        serializationContext.getSerializationWriter().simpleElement(qName, attributes, string);
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        if (object instanceof Float || object instanceof Double) {
            double d = 0.0;
            d = object instanceof Float ? ((Float)object).doubleValue() : ((Double)object).doubleValue();
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
        } else {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                return bl ? "1" : "0";
            }
            if (object instanceof Character) {
                char c = ((Character)object).charValue();
                if (c == '\u0000') {
                    return "";
                }
                return object.toString();
            }
            if (object instanceof BigDecimal) {
                return this.getNonScientificValue((BigDecimal)object);
            }
        }
        return object.toString();
    }

    protected Attributes getObjectAttributes(Object object, Attributes attributes, SerializationContext serializationContext) {
        if (this.beanDesc == null || !this.beanDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            for (int i = 0; i < this.propertyDescriptor.length; ++i) {
                Object object2;
                FieldDesc fieldDesc;
                String string = this.propertyDescriptor[i].getName();
                if (string.equals("class") || (fieldDesc = this.beanDesc.getFieldByName(string)) == null || fieldDesc.isElement()) continue;
                QName qName = fieldDesc.getXmlName();
                if (qName == null) {
                    qName = QNameTable.createQName("", string);
                }
                if (!this.propertyDescriptor[i].isReadable() || this.propertyDescriptor[i].isIndexed() || (object2 = this.propertyDescriptor[i].get(object)) == null) continue;
                String string2 = this.getValueAsString(object2, serializationContext);
                String string3 = qName.getNamespaceURI();
                String string4 = qName.getLocalPart();
                attributesImpl.addAttribute(string3, string4, serializationContext.getSerializationWriter().qName2String(qName), "CDATA", string2);
            }
        }
        catch (Exception exception) {
            return attributesImpl;
        }
        return attributesImpl;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }

    private String getNonScientificValue(BigDecimal bigDecimal) {
        if (!hasToPlainStringMethodCache) {
            toPlainStringMethodCache = (Method)AccessController.doPrivileged(new getMethodPRIV(bigDecimal.getClass(), "toPlainString"));
            hasToPlainStringMethodCache = true;
        }
        if (toPlainStringMethodCache != null) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking toPlainString() method to convert BigDecimal to string.");
            }
            final BigDecimal bigDecimal2 = bigDecimal;
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return toPlainStringMethodCache.invoke((Object)bigDecimal2, null);
                    }
                    catch (Throwable throwable) {
                        if (log.isDebugEnabled()) {
                            log.debug("The following exception encountered when trying to invoke method [" + toPlainStringMethodCache.getName() + "] on class [" + bigDecimal2.getClass().getName() + "].");
                            log.debug(throwable.toString());
                        }
                        return null;
                    }
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoking toString() method to convert BigDecimal to string.");
        }
        return bigDecimal.toString();
    }

    private class getMethodPRIV
    implements PrivilegedAction {
        private Class clazz;
        private String methodName;

        getMethodPRIV(Class clazz, String string) {
            this.clazz = clazz;
            this.methodName = string;
        }

        public Object run() {
            try {
                return this.clazz.getMethod(this.methodName, null);
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug("The following exception encountered when trying to get method [" + this.methodName + "] from class [" + this.clazz.getName() + "].");
                    log.debug(throwable.toString());
                }
                return null;
            }
        }
    }
}

