/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public final class ListSerializer
extends SimpleSerializer {
    QName componentTypeQName = null;

    public ListSerializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public ListSerializer(Class clazz, QName qName, QName qName2, QName qName3) {
        super(clazz, qName);
        this.componentTypeQName = qName3;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.getSerializationWriter().simpleElement(qName, attributes, this.getValueAsString(object, serializationContext));
    }

    public String getValueAsString(Object object, SerializationContext serializationContext) {
        if (object.getClass().isArray()) {
            return this.getArrayValueAsString(object, serializationContext);
        }
        if (object instanceof Collection) {
            return this.getListValueAsString(object, serializationContext);
        }
        try {
            return serializationContext.getValueAsString(object, this.componentTypeQName).trim();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.encoding.ser.ListSerializer.getValueAsString", "133", this);
            return super.getValueAsString(object, serializationContext).trim();
        }
    }

    private String getArrayValueAsString(Object object, SerializationContext serializationContext) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < Array.getLength(object); ++i) {
            if (Array.get(object, i) == null) continue;
            stringBuffer.append(" " + this.getValueAsString(Array.get(object, i), serializationContext));
        }
        return stringBuffer.toString().trim();
    }

    private String getListValueAsString(Object object, SerializationContext serializationContext) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = (List)object;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) == null) continue;
            stringBuffer.append(" " + this.getValueAsString(list.get(i), serializationContext));
        }
        return stringBuffer.toString();
    }

    public String getBuildNumber() {
        return null;
    }
}

