/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import [Ljava.lang.Object;;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SOAPElementSerializerFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;

public class TypeMappingImpl
extends TypeMappingBase {
    protected static Log log = LogFactory.getLog(TypeMappingImpl.class.getName());
    private Hashtable qName2Pair = new Hashtable();
    private Hashtable class2Pair = new Hashtable();
    private Hashtable pair2SF = new Hashtable();
    private Hashtable pair2DF = new Hashtable();
    private ArrayList namespaces;
    private boolean autoRegisterSOAPElements = true;
    private boolean debug = false;
    private Pair cachePair = null;

    public TypeMappingImpl(TypeMappingBase typeMappingBase) {
        this.delegate = typeMappingBase;
        this.namespaces = new ArrayList();
        this.debug = log.isDebugEnabled() || this.debug;
    }

    void setDelegate(TypeMappingBase typeMappingBase) {
        this.delegate = typeMappingBase;
    }

    public TypeMappingBase getDelegate() {
        return this.delegate;
    }

    public String[] getSupportedEncodings() {
        String[] stringArray = new String[this.namespaces.size()];
        return this.namespaces.toArray(stringArray);
    }

    public void setSupportedEncodings(String[] stringArray) {
        this.namespaces.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.namespaces.contains(stringArray[i])) continue;
            this.namespaces.add(stringArray[i]);
        }
    }

    public boolean isRegistered(Class clazz, QName qName) {
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(clazz, qName);
        boolean bl = this.pair2SF.keySet().contains(pair);
        pair.inUse = false;
        if (bl) {
            return true;
        }
        if (this.delegate != null) {
            boolean bl2 = this.delegate.isRegistered(clazz, qName);
            return bl2;
        }
        return false;
    }

    public void register(Class clazz, QName qName, javax.xml.rpc.encoding.SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) throws JAXRPCException {
        if (serializerFactory == null && deserializerFactory == null) {
            throw new JAXRPCException(Messages.getMessage("badSerFac"));
        }
        this.internalRegister(clazz, qName, serializerFactory, deserializerFactory);
    }

    protected synchronized void internalRegister(Class clazz, QName qName, javax.xml.rpc.encoding.SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) throws JAXRPCException {
        if (this.debug) {
            log.debug("name: " + this.getClass().toString());
            log.debug("internalRegister(" + (clazz != null ? clazz.toString() : "<null>") + ", " + (qName != null ? qName.toString() : "<null>") + ", " + (serializerFactory != null ? serializerFactory.toString() : "<null>") + ", " + (deserializerFactory != null ? deserializerFactory.toString() : "<null>") + ")");
            if (!this.isRegistered(clazz, qName)) {
                if (serializerFactory != null) {
                    try {
                        log.debug(serializerFactory.getSerializerAs("").getClass().toString());
                    }
                    catch (Exception exception) {
                        log.error("Cannot obtain a Serializer. Exception details: " + exception);
                    }
                }
                if (deserializerFactory != null) {
                    try {
                        log.debug(deserializerFactory.getDeserializerAs("").getClass().toString());
                    }
                    catch (Exception exception) {
                        log.error("Cannot obtain a Deserializer. Exception details: " + exception);
                    }
                }
            }
        }
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(clazz, qName);
        if (deserializerFactory != null || this.qName2Pair.get(qName) == null) {
            this.qName2Pair.put(qName, pair);
        }
        this.class2Pair.put(clazz.getName(), pair);
        if (serializerFactory != null) {
            this.pair2SF.put(pair, serializerFactory);
        }
        if (deserializerFactory != null) {
            this.pair2DF.put(pair, deserializerFactory);
        }
    }

    public javax.xml.rpc.encoding.SerializerFactory getSerializer(Class object, QName qName) throws JAXRPCException {
        javax.xml.rpc.encoding.SerializerFactory serializerFactory = null;
        if (this.debug) {
            log.debug("getSerializer(" + object + "," + qName + ")");
        }
        if (object == null) {
            if (this.debug) {
                log.debug("getSerializer javaType is null");
            }
            return null;
        }
        if (qName == null && (qName = this.getTypeQName((Class)object)) == null) {
            if (this.debug) {
                log.debug("getSerializer xmlType is null");
            }
            return null;
        }
        Object object2 = this.getPair((Class)object, qName);
        serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
        ((Pair)object2).inUse = false;
        if (this.autoRegisterSOAPElements && serializerFactory == null && SOAPElement.class.isAssignableFrom((Class<?>)object)) {
            serializerFactory = BaseSerializerFactory.createFactory(SOAPElementSerializerFactory.class, (Class)object, qName);
            object2 = BaseDeserializerFactory.createFactory(SOAPElementDeserializerFactory.class, (Class)object, qName);
            if (!(this instanceof DefaultTypeMappingImpl)) {
                this.internalRegister((Class)object, qName, serializerFactory, (DeserializerFactory)object2);
            }
            if (this.debug) {
                log.debug("getSerializer sf [" + serializerFactory + "]");
            }
            return serializerFactory;
        }
        if (serializerFactory == null && Collection.class.isAssignableFrom((Class<?>)object)) {
            object2 = this.getPair(Object;.class, qName);
            serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
            ((Pair)object2).inUse = false;
        }
        if (serializerFactory == null && (object2 = this.getClassForQName(qName)) != null && object2 != object && ((Class)object2).isAssignableFrom((Class<?>)object)) {
            QName qName2 = null;
            if (((Class)object).isArray() || Collection.class.isAssignableFrom((Class<?>)object)) {
                qName2 = qName;
                object = object2;
            } else {
                qName2 = this.getTypeQName((Class)object);
            }
            if (qName2 != null && !qName2.getLocalPart().startsWith(">")) {
                Pair pair = this.getPair((Class)object, qName2);
                serializerFactory = (SerializerFactory)this.pair2SF.get(pair);
                pair.inUse = false;
            }
        }
        if (serializerFactory == null && this.delegate != null) {
            serializerFactory = (SerializerFactory)this.delegate.getSerializer((Class)object, qName);
        }
        if (serializerFactory == null && qName.equals(Constants.SOAP_ARRAY) && (object2 = (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY)) != null) {
            serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
        }
        if (serializerFactory == null && !((Class)object).isArray() && (object2 = (Pair)this.class2Pair.get(((Class)object).getName())) != null && ((Pair)object2).xmlType.equals(qName)) {
            serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
        }
        if (serializerFactory == null && ((Class)object).isArray() && (object2 = (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY)) != null) {
            serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
        }
        if (this.debug) {
            log.debug("getSerializer sf [" + serializerFactory + "]");
        }
        return serializerFactory;
    }

    public QName getXMLType(Class object, QName qName) throws JAXRPCException {
        javax.xml.rpc.encoding.SerializerFactory serializerFactory = null;
        QName qName2 = null;
        if (qName == null && (qName = this.getTypeQNameRecursive((Class)object)) == null) {
            return qName2;
        }
        Object object2 = this.getPair((Class)object, qName);
        serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
        qName2 = ((Pair)object2).xmlType;
        ((Pair)object2).inUse = false;
        if (serializerFactory == null && (object2 = this.getClassForQName(qName)) != null && ((Class)object2).isAssignableFrom((Class<?>)object)) {
            QName qName3 = null;
            if (((Class)object).isArray() || Collection.class.isAssignableFrom((Class<?>)object)) {
                qName3 = qName;
                object = object2;
            } else {
                qName3 = this.getTypeQName((Class)object);
            }
            if (qName3 != null && !qName3.getLocalPart().startsWith(">")) {
                Pair pair = this.getPair((Class)object, qName3);
                serializerFactory = (SerializerFactory)this.pair2SF.get(pair);
                qName2 = pair.xmlType;
                pair.inUse = false;
            }
        }
        if (serializerFactory == null && this.delegate != null) {
            return this.delegate.getXMLType((Class)object, qName);
        }
        if (serializerFactory == null && !((Class)object).isArray() && (object2 = (Pair)this.class2Pair.get(((Class)object).getName())) != null) {
            serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
            qName2 = ((Pair)object2).xmlType;
        }
        if (serializerFactory == null && ((Class)object).isArray() && (object2 = (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY)) != null) {
            serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(object2);
            qName2 = ((Pair)object2).xmlType;
        }
        return qName2;
    }

    public DeserializerFactory getDeserializer(Class clazz, QName qName) throws JAXRPCException {
        DeserializerFactory deserializerFactory = null;
        if (this.debug) {
            log.debug("getDeserializer(" + clazz + "," + qName);
        }
        if (qName == null) {
            if (this.debug) {
                log.debug("  can't continue");
            }
            return null;
        }
        if (clazz == null) {
            clazz = this.getClassForQName(qName);
            if (this.debug) {
                log.debug("  No javaType swizzle: new javaType=" + clazz);
            }
            if (this.autoRegisterSOAPElements && clazz == null) {
                Class clazz2 = clazz = SOAPElement.class;
                if (this.debug) {
                    log.debug("  Default to SOAPElement javaType=" + clazz);
                }
            }
        }
        if (clazz == null) {
            if (this.debug) {
                log.debug("  no java type, bail out");
            }
            return null;
        }
        Object object = this.getPair(clazz, qName);
        deserializerFactory = (DeserializerFactory)this.pair2DF.get(object);
        if (this.debug) {
            log.debug("  First attempt: df=" + deserializerFactory);
        }
        ((Pair)object).inUse = false;
        if (deserializerFactory == null && this.autoRegisterSOAPElements && SOAPElement.class.isAssignableFrom(clazz)) {
            object = BaseSerializerFactory.createFactory(SOAPElementSerializerFactory.class, clazz, qName);
            deserializerFactory = BaseDeserializerFactory.createFactory(SOAPElementDeserializerFactory.class, clazz, qName);
            if (!(this instanceof DefaultTypeMappingImpl)) {
                this.internalRegister(clazz, qName, (javax.xml.rpc.encoding.SerializerFactory)object, deserializerFactory);
            }
            if (this.debug) {
                log.debug("  Use autoregistered SOAPElement: df=" + deserializerFactory);
            }
            return deserializerFactory;
        }
        if (deserializerFactory == null && Collection.class.isAssignableFrom(clazz)) {
            object = this.getPair(Object;.class, qName);
            deserializerFactory = (DeserializerFactory)this.pair2DF.get(object);
            ((Pair)object).inUse = false;
            if (this.debug) {
                log.debug("  Try Collection swizzle: df=" + deserializerFactory);
            }
        }
        if (deserializerFactory == null && qName.equals(Constants.SOAP_ARRAY) && (object = (Pair)this.qName2Pair.get(qName)) != null) {
            deserializerFactory = (DeserializerFactory)this.pair2DF.get(object);
            if (this.debug) {
                log.debug("  Try SOAP_ARRAY swizzle: df=" + deserializerFactory);
            }
        }
        if (deserializerFactory == null && clazz == Object.class) {
            object = (Pair)this.qName2Pair.get(qName);
            if (object != null) {
                deserializerFactory = (DeserializerFactory)this.pair2DF.get(object);
            }
            if (this.debug) {
                log.debug("  Try Object swizzle: df=" + deserializerFactory);
            }
        }
        if (deserializerFactory == null && this.delegate != null) {
            if (this.debug) {
                log.debug("  Try Delegation Start");
            }
            deserializerFactory = this.delegate.getDeserializer(clazz, qName);
            if (this.debug) {
                log.debug("  Try Delegation End: df=" + deserializerFactory);
            }
        }
        if (deserializerFactory == null && this.autoRegisterSOAPElements && clazz == Object.class) {
            object = null;
            deserializerFactory = BaseDeserializerFactory.createFactory(SOAPElementDeserializerFactory.class, SOAPElement.class, qName);
            if (!(this instanceof DefaultTypeMappingImpl)) {
                this.internalRegister(clazz, qName, (javax.xml.rpc.encoding.SerializerFactory)object, deserializerFactory);
            }
            if (this.debug) {
                log.debug("  Try Object->SOAPElement swizzle: df=" + deserializerFactory);
            }
        }
        return deserializerFactory;
    }

    public void removeSerializer(Class clazz, QName qName) throws JAXRPCException {
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(clazz, qName);
        this.pair2SF.remove(pair);
        pair.inUse = false;
    }

    public void removeDeserializer(Class clazz, QName qName) throws JAXRPCException {
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = this.getPair(clazz, qName);
        this.pair2DF.remove(pair);
        pair.inUse = false;
    }

    public QName getTypeQNameRecursive(Class clazz) {
        QName qName = null;
        while (clazz != null) {
            qName = this.getTypeQName(clazz);
            if (qName != null) {
                return qName;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray != null) {
                for (int i = 0; i < classArray.length; ++i) {
                    Class<?> clazz2 = classArray[i];
                    qName = this.getTypeQName(clazz2);
                    if (qName == null) continue;
                    return qName;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public QName getTypeQName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        QName qName = null;
        Pair pair = (Pair)this.class2Pair.get(clazz.getName());
        if (pair == null && this.delegate != null) {
            qName = this.delegate.getTypeQName(clazz);
        } else if (pair != null) {
            qName = pair.xmlType;
        }
        if (qName == null && (clazz.isArray() || clazz == List.class || List.class.isAssignableFrom(clazz))) {
            qName = Constants.SOAP_ARRAY;
        }
        return qName;
    }

    public QName getRegisteredQName(String string) {
        if (string == null) {
            return null;
        }
        Pair pair = (Pair)this.class2Pair.get(string);
        QName qName = null;
        if (pair == null && this.delegate != null) {
            qName = this.delegate.getRegisteredQName(string);
        } else if (pair != null) {
            qName = pair.xmlType;
        }
        return qName;
    }

    public Class getClassForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        Class clazz = null;
        Pair pair = (Pair)this.qName2Pair.get(qName);
        if (pair == null && this.delegate != null) {
            clazz = this.delegate.getClassForQName(qName);
        } else if (pair != null) {
            clazz = pair.javaType;
        }
        return clazz;
    }

    public javax.xml.rpc.encoding.SerializerFactory getSerializer(Class clazz) throws JAXRPCException {
        return this.getSerializer(clazz, null);
    }

    public DeserializerFactory getDeserializer(QName qName) throws JAXRPCException {
        return this.getDeserializer(null, qName);
    }

    private synchronized Pair getPair(Class clazz, QName qName) {
        if (this.cachePair == null || this.cachePair.inUse) {
            this.cachePair = new Pair(clazz, qName);
        } else {
            this.cachePair.inUse = true;
            this.cachePair.javaType = clazz;
            this.cachePair.xmlType = qName;
        }
        return this.cachePair;
    }

    private class Pair {
        public Class javaType;
        public QName xmlType;
        public boolean inUse;

        public Pair(Class clazz, QName qName) {
            this.javaType = clazz;
            this.xmlType = qName;
            this.inUse = true;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            Pair pair = (Pair)object;
            if (pair.xmlType == this.xmlType && pair.javaType == this.javaType) {
                return true;
            }
            return pair.xmlType.equals(this.xmlType) && pair.javaType.equals(this.javaType);
        }

        public int hashCode() {
            int n = 0;
            if (this.javaType != null) {
                n ^= this.javaType.hashCode();
            }
            if (this.xmlType != null) {
                n ^= this.xmlType.hashCode();
            }
            return n;
        }
    }
}

