/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public class ManagedMemoryDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ManagedMemoryDataSource.class.getName());
    protected String contentType = "application/octet-stream";
    InputStream ss = null;
    protected File diskCacheFile = null;
    protected WeakHashMap readers = new WeakHashMap();
    protected boolean deleted = false;
    public static final int READ_CHUNK_SZ = 32768;
    protected boolean debugEnabled = false;
    protected static int maxCached = 32768;
    protected LinkedList memorybuflist = new LinkedList();
    protected byte[] currentMemoryBuf = null;
    protected int currentMemoryBufSz = 0;
    protected int totalsz = 0;
    protected BufferedOutputStream cachediskstream = null;
    protected boolean closed = false;
    private IOException propagateIOException;
    protected static Log is_log;

    protected ManagedMemoryDataSource() {
    }

    public ManagedMemoryDataSource(InputStream inputStream, String string) throws IOException {
        this(inputStream, maxCached, string, true);
    }

    public ManagedMemoryDataSource(InputStream inputStream, int n, String string, boolean bl) throws IOException {
        this.ss = inputStream;
        maxCached = n;
        if (null != string && string.length() != 0) {
            this.contentType = string;
        }
        if (maxCached < -1) {
            throw new IllegalArgumentException(Messages.getMessage("badMaxCached", "" + maxCached));
        }
        if (log.isDebugEnabled()) {
            this.debugEnabled = true;
        }
        if (bl) {
            byte[] byArray = new byte[32768];
            int n2 = 0;
            do {
                if ((n2 = inputStream.read(byArray)) <= 0) continue;
                this.write(byArray, n2);
            } while (n2 > -1);
            this.close();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public synchronized InputStream getInputStream() throws IOException {
        return new Instream();
    }

    public String getName() {
        String string = null;
        try {
            this.flushToDisk();
            if (this.diskCacheFile != null) {
                string = this.diskCacheFile.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.getName", "232", this);
            this.diskCacheFile = null;
        }
        return string;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    protected void write(byte[] byArray) throws IOException {
        this.write(byArray, byArray.length);
    }

    protected synchronized void write(byte[] byArray, int n) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        int n2 = n;
        int n3 = 0;
        if (null != this.memorybuflist && this.totalsz + n2 > maxCached && null == this.cachediskstream) {
            this.flushToDisk();
        }
        if (this.memorybuflist != null) {
            do {
                if (null == this.currentMemoryBuf) {
                    this.currentMemoryBuf = new byte[32768];
                    this.currentMemoryBufSz = 0;
                    this.memorybuflist.add(this.currentMemoryBuf);
                }
                int n4 = Math.min(n2 - n3, this.currentMemoryBuf.length - this.currentMemoryBufSz);
                System.arraycopy(byArray, n3, this.currentMemoryBuf, this.currentMemoryBufSz, n4);
                this.currentMemoryBufSz += n4;
                if ((n3 += n4) >= n2) continue;
                this.currentMemoryBuf = new byte[32768];
                this.currentMemoryBufSz = 0;
                this.memorybuflist.add(this.currentMemoryBuf);
            } while (n3 < n2);
        }
        if (null != this.cachediskstream) {
            this.cachediskstream.write(byArray, 0, n);
        }
        this.totalsz += n2;
    }

    protected synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (null != this.cachediskstream) {
                this.cachediskstream.close();
                this.cachediskstream = null;
            }
            if (null != this.memorybuflist) {
                if (this.currentMemoryBufSz > 0) {
                    byte[] byArray = new byte[this.currentMemoryBufSz];
                    System.arraycopy(this.currentMemoryBuf, 0, byArray, 0, this.currentMemoryBufSz);
                    this.memorybuflist.set(this.memorybuflist.size() - 1, byArray);
                }
                this.currentMemoryBuf = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (null != this.cachediskstream) {
            this.cachediskstream.close();
            this.cachediskstream = null;
        }
    }

    protected void flushToDisk() throws IOException, FileNotFoundException {
        this.propagateIOException = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ManagedMemoryDataSource.this.privilegedFlushToDisk();
                return null;
            }
        });
        if (this.propagateIOException != null) {
            throw this.propagateIOException;
        }
    }

    private Boolean privilegedDeleteCacheFile() {
        boolean bl = false;
        try {
            bl = this.diskCacheFile.delete();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.privilegedDeleteCacheFile", "447", this);
            this.diskCacheFile.deleteOnExit();
        }
        return new Boolean(bl);
    }

    private void privilegedFlushToDisk() {
        try {
            LinkedList linkedList = this.memorybuflist;
            this.memorybuflist = null;
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("maxCached", "" + maxCached, "" + this.totalsz));
            }
            if (linkedList != null && null == this.cachediskstream) {
                try {
                    File file;
                    MessageContext messageContext = MessageContext.getCurrentThreadsContext();
                    String string = messageContext == null ? null : messageContext.getStrProp(MessageContext.ATTACHMENTS_DIR);
                    File file2 = file = string == null ? null : new File(string);
                    if (file != null && !file.exists()) {
                        file.mkdir();
                    }
                    this.diskCacheFile = File.createTempFile("WebServices", "webservices", file);
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("diskCache", this.diskCacheFile.getAbsolutePath()));
                    }
                    this.cachediskstream = new BufferedOutputStream(new FileOutputStream(this.diskCacheFile));
                    int n = linkedList.size();
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        byte[] byArray = (byte[])iterator.next();
                        int n2 = n-- == 0 ? this.currentMemoryBufSz : byArray.length;
                        this.cachediskstream.write(byArray, 0, n2);
                        if (!this.closed) continue;
                        this.cachediskstream.close();
                        this.cachediskstream = null;
                    }
                    this.memorybuflist = null;
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.flushToDisk", "459", this);
                    this.diskCacheFile = null;
                    this.cachediskstream = null;
                    maxCached = Integer.MAX_VALUE;
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.privilegedFlushToDisk", "512", this);
            this.propagateIOException = iOException;
        }
    }

    public synchronized boolean delete() {
        boolean bl = false;
        this.deleted = true;
        this.memorybuflist = null;
        if (this.diskCacheFile != null) {
            if (this.cachediskstream != null) {
                try {
                    this.cachediskstream.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.delete", "488", this);
                }
                this.cachediskstream = null;
            }
            Object object = this.readers.keySet().iterator();
            while (object.hasNext()) {
                Instream instream = (Instream)object.next();
                if (null == instream) continue;
                try {
                    instream.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.delete", "502", this);
                }
            }
            this.readers.clear();
            object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ManagedMemoryDataSource.this.privilegedDeleteCacheFile();
                }
            });
            bl = (Boolean)object;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            FileInputStream fileInputStream = new FileInputStream(string);
            ManagedMemoryDataSource managedMemoryDataSource = new ManagedMemoryDataSource(fileInputStream, 0x100000, "foo/data", true);
            DataHandler dataHandler = new DataHandler(managedMemoryDataSource);
            InputStream inputStream = dataHandler.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[512];
            int n = 0;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                fileOutputStream.write(byArray, 0, n);
            } while (n > -1);
            fileOutputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.main", "957");
            log.error(Messages.getMessage("exception00"), exception);
        }
    }

    static {
        String string = System.getProperty("com.ibm.websphere.webservices.attachements.maxMemCacheSize");
        if (string != null) {
            maxCached = Integer.parseInt(string) * 1024;
        }
        is_log = LogFactory.getLog(Instream.class.getName());
    }

    private class Instream
    extends InputStream {
        protected int bread = 0;
        FileInputStream fin = null;
        int currentIndex = 0;
        byte[] currentBuf = null;
        int currentBufPos = 0;
        boolean readClosed = false;
        private byte[] buffer = null;
        private IOException propagateReadException = null;

        protected Instream() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            ManagedMemoryDataSource.this.readers.put(this, null);
        }

        public int available() throws IOException {
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            int n = ManagedMemoryDataSource.this.totalsz - this.bread;
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("available() = " + n + ".");
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                byte[] byArray = new byte[1];
                int n = this.read(byArray, 0, 1);
                if (n == -1) {
                    return -1;
                }
                return byArray[0] == -1 ? 255 : byArray[0];
            }
        }

        public boolean markSupported() {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("markSupported() = false.");
            }
            return false;
        }

        public void mark(int n) {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("mark()");
            }
        }

        public void reset() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("reset()");
            }
            throw new IOException(Messages.getMessage("noResetMark"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("skip(" + l + ").");
            }
            if (ManagedMemoryDataSource.this.deleted) {
                throw new IOException(Messages.getMessage("resourceDeleted"));
            }
            if (this.readClosed) {
                throw new IOException(Messages.getMessage("streamClosed"));
            }
            if (l < 1L) {
                return 0L;
            }
            ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
            synchronized (managedMemoryDataSource) {
                l = Math.min(l, (long)(ManagedMemoryDataSource.this.totalsz - this.bread));
                if (l == 0L) {
                    return 0L;
                }
                LinkedList linkedList = ManagedMemoryDataSource.this.memorybuflist;
                int n = 0;
                if (linkedList != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])linkedList.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        long l2 = Math.min((long)(this.currentBuf.length - this.currentBufPos), l - (long)n);
                        n = (int)((long)n + l2);
                        this.currentBufPos = (int)((long)this.currentBufPos + l2);
                        if ((long)n >= l) continue;
                        this.currentBuf = (byte[])linkedList.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while ((long)n < l);
                }
                if (null != this.fin) {
                    this.fin.skip(l);
                }
                this.bread = (int)((long)this.bread + l);
            }
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("skipped " + l + ".");
            }
            return l;
        }

        public int read(byte[] byArray, final int n, final int n2) throws IOException {
            this.propagateReadException = null;
            this.buffer = byArray;
            Integer n3 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Instream.this.privilegedRead(n, n2);
                }
            });
            if (this.propagateReadException != null) {
                throw this.propagateReadException;
            }
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer privilegedRead(int n, int n2) {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug(this.hashCode() + " read(" + n + ", " + n2 + ")");
            }
            try {
                if (ManagedMemoryDataSource.this.deleted) {
                    throw new IOException(Messages.getMessage("resourceDeleted"));
                }
                if (this.readClosed) {
                    throw new IOException(Messages.getMessage("streamClosed"));
                }
                if (this.buffer == null) {
                    throw new InternalException(Messages.getMessage("nullInput"));
                }
                if (n < 0) {
                    throw new IndexOutOfBoundsException(Messages.getMessage("negOffset", "" + n));
                }
                if (n2 < 0) {
                    throw new IndexOutOfBoundsException(Messages.getMessage("length", "" + n2));
                }
                if (n2 + n > this.buffer.length) {
                    throw new IndexOutOfBoundsException(Messages.getMessage("writeBeyond"));
                }
                if (n2 == 0) {
                    return new Integer(0);
                }
                int n3 = 0;
                ManagedMemoryDataSource managedMemoryDataSource = ManagedMemoryDataSource.this;
                synchronized (managedMemoryDataSource) {
                    if (this.bread == ManagedMemoryDataSource.this.totalsz) {
                        return new Integer(-1);
                    }
                    LinkedList linkedList = ManagedMemoryDataSource.this.memorybuflist;
                    n2 = Math.min(n2, ManagedMemoryDataSource.this.totalsz - this.bread);
                    if (ManagedMemoryDataSource.this.debugEnabled) {
                        is_log.debug("len = " + n2);
                    }
                    if (linkedList != null) {
                        if (null == this.currentBuf) {
                            this.currentBuf = (byte[])linkedList.get(this.currentIndex);
                            this.currentBufPos = 0;
                        }
                        do {
                            int n4 = Math.min(this.currentBuf.length - this.currentBufPos, n2 - n3);
                            System.arraycopy(this.currentBuf, this.currentBufPos, this.buffer, n + n3, n4);
                            this.currentBufPos += n4;
                            if ((n3 += n4) >= n2) continue;
                            this.currentBuf = (byte[])linkedList.get(++this.currentIndex);
                            this.currentBufPos = 0;
                        } while (n3 < n2);
                    }
                    if (n3 == 0 && null != ManagedMemoryDataSource.this.diskCacheFile) {
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            is_log.debug(Messages.getMessage("reading", "" + n2));
                        }
                        if (null == this.fin) {
                            if (ManagedMemoryDataSource.this.debugEnabled) {
                                is_log.debug(Messages.getMessage("openBread", ManagedMemoryDataSource.this.diskCacheFile.getCanonicalPath()));
                            }
                            if (ManagedMemoryDataSource.this.debugEnabled) {
                                is_log.debug(Messages.getMessage("openBread", "" + this.bread));
                            }
                            this.fin = new FileInputStream(ManagedMemoryDataSource.this.diskCacheFile);
                            if (this.bread > 0) {
                                this.fin.skip(this.bread);
                            }
                        }
                        if (ManagedMemoryDataSource.this.cachediskstream != null) {
                            if (ManagedMemoryDataSource.this.debugEnabled) {
                                is_log.debug(Messages.getMessage("flushing"));
                            }
                            ManagedMemoryDataSource.this.cachediskstream.flush();
                        }
                        if (ManagedMemoryDataSource.this.debugEnabled) {
                            is_log.debug(Messages.getMessage("flushing"));
                            is_log.debug("len=" + n2);
                            is_log.debug("off=" + n);
                            is_log.debug("b.length=" + this.buffer.length);
                        }
                        n3 = this.fin.read(this.buffer, n, n2);
                    }
                    if (n3 > 0) {
                        this.bread += n3;
                    }
                }
                if (ManagedMemoryDataSource.this.debugEnabled) {
                    is_log.debug(this.hashCode() + Messages.getMessage("read", "" + n3));
                }
                return new Integer(n3);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.attachments.ManagedMemoryDataSource.privilegedRead", "958", this);
                this.propagateReadException = iOException;
                return null;
            }
        }

        public synchronized void close() throws IOException {
            if (ManagedMemoryDataSource.this.debugEnabled) {
                is_log.debug("close()");
            }
            if (!this.readClosed) {
                ManagedMemoryDataSource.this.readers.remove(this);
                this.readClosed = true;
                if (this.fin != null) {
                    this.fin.close();
                }
                this.fin = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

