/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.webservices.WSConstants;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.WebServicesSystemService;
import com.ibm.ws.webservices.component.WSServerImpl;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ServerModuleMetaData;
import com.ibm.ws.webservices.metadata.ServerPortMetaData;
import com.ibm.ws.webservices.metadata.SysServerModuleMetaData;
import com.ibm.ws.webservices.sysengine.SystemEngineRouter;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.xml.wassysapp.systemApp;
import com.ibm.ws.webservices.xml.wassysapp.systemAppPort;
import com.ibm.ws.webservices.xml.wassysapp.systemApps;
import com.ibm.ws.webservices.xml.wassysapp.systemAppsFactory;
import com.ibm.ws.wsaddressing.urimap.PortURIManager;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRendererFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

public class WSSysServerImpl
extends ComponentImpl
implements WebServicesSystemService {
    private static final TraceComponent _tc;
    private static WSSysServerImpl singleton;
    private boolean loadedConfig = false;
    private SoapContainerService soapContainerService = null;

    public static WSSysServerImpl getWSSysServerImpl() {
        return singleton;
    }

    public EngineConfiguration getClientEngineConfig() {
        return null;
    }

    public ClientEntityMetaData getClientEntityMetaData() {
        return null;
    }

    public WebServicesPerf getPMIServicesModule() {
        return null;
    }

    public EngineConfiguration getServerEngineConfig() {
        EngineConfiguration engineConfiguration = null;
        SysServerModuleMetaData sysServerModuleMetaData = this.getServerModuleMetaData();
        if (sysServerModuleMetaData == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.ws.webservices.component.WSSysServerImpl.getServerEngineConfig(): ServerModuleMetaData is null");
            }
        } else {
            engineConfiguration = sysServerModuleMetaData.getConfiguration();
        }
        return engineConfiguration;
    }

    public boolean isClientWebServiceEnabled() {
        return false;
    }

    public boolean isRoleApplicableToService(int n) {
        return true;
    }

    public boolean isServerWebServiceEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        try {
            if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Disabling component in DMGR process.");
                }
                throw new ComponentDisabledException();
            }
            this.addService(WebServicesSystemService.class, this);
            WebServicesServiceHome.setWebServicesSystemService(this);
            singleton = this;
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialize");
            }
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "start");
        }
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    public void loadConfiguration() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.loadedConfig) {
            return;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadConfiguration");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "CCL is currently: " + Thread.currentThread().getContextClassLoader());
        }
        this.getSOAPContainerService();
        String string = "META-INF/was-sysapp.xml";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry != null && (object4 = iExtensionRegistry.getExtensionPoint((String)(object3 = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".sysapp"))) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing extension point " + (String)object3);
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            IExtension[] iExtensionArray = object4.getExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing extension " + iExtensionArray[i].getUniqueIdentifier());
                }
                if ((object2 = Platform.getBundle((String)iExtensionArray[i].getNamespace())) == null || hashSet.contains(object = object2.getSymbolicName())) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing bundle " + (String)object);
                }
                hashSet.add(object);
                arrayList.add(object2);
            }
        }
        object3 = CommonarchiveFactoryImpl.getActiveFactory();
        EMF2SAXRendererFactory.INSTANCE.setValidating(false);
        object4 = this.getInstallRootDir();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            ArchiveOptions archiveOptions;
            Bundle bundle = (Bundle)arrayList.get(i);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing bundle '" + bundle.getSymbolicName() + "', location '" + bundle.getLocation() + "'.");
            }
            object2 = bundle.getResource(string);
            if (object2 == null) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found sysapp config file: " + ((URL)object2).toString() + " within bundle '" + bundle.getSymbolicName() + "'.");
            }
            bl = true;
            object = WSSysServerImpl.loadSysAppConfigXML((URL)object2);
            String string2 = this.getJarName((String)object4, bundle.getLocation());
            LoadStrategy loadStrategy = null;
            Archive archive = null;
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to crack open jar: " + string2);
                }
                archiveOptions = new ArchiveOptions();
                archiveOptions.setIsReadOnly(true);
                archiveOptions.setUseJavaReflection(false);
                archiveOptions.setDiscriminateNestedArchives(false);
                archive = object3.openArchive(archiveOptions, string2);
                loadStrategy = archive.getLoadStrategy();
            }
            catch (Exception exception) {
                Tr.error(_tc, "internal.error", exception);
            }
            if (loadStrategy == null) {
                Tr.error(_tc, "internal.error", "Can't create LoadStrategy for " + string2);
                continue;
            }
            archiveOptions = WSServerImpl.loadWebServicesXML(loadStrategy, "META-INF/webservices.xml");
            if (archiveOptions == null) {
                Tr.error(_tc, "internal.error", "loadConfiguration: SysApp doesn't contain file META-INF/webservices.xml");
                continue;
            }
            WSBinding wSBinding = WSServerImpl.loadWebServicesBindingXML(loadStrategy, "META-INF/ibm-webservices-bnd.xmi");
            String string3 = bundle.getSymbolicName();
            ArrayList arrayList2 = null;
            try {
                arrayList2 = WSSysServerImpl.createSysAppServerMetaDatas(string3, (systemApps)object, (WebServices)archiveOptions, wSBinding, loadStrategy, string2, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.component.WSSysServerImpl.loadConfiguration", "433", this);
                Tr.error(_tc, "internal.error", classNotFoundException);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.component.WSSysServerImpl.loadConfiguration", "441", this);
                Tr.error(_tc, "internal.error", iOException);
            }
            if (arrayList2 != null && !arrayList2.isEmpty()) {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    SysServerModuleMetaData sysServerModuleMetaData = (SysServerModuleMetaData)iterator.next();
                    this.getSOAPContainerService().cacheMetaData(sysServerModuleMetaData.getModuleName(), sysServerModuleMetaData);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Caching SMMD object:  key=" + sysServerModuleMetaData.getModuleName() + ", value=" + sysServerModuleMetaData.toString());
                }
            } else {
                Tr.error(_tc, "internal.error", "loadConfiguration: no ServerModuleMetaData objects returned!");
            }
            archive.close();
            loadStrategy = null;
        }
        if (bl) {
            this.getSOAPContainerService().registerRouter(new SystemEngineRouter());
        }
        this.loadedConfig = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadConfiguration");
        }
    }

    private String getInstallRootDir() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInstallRootDir");
        }
        String string = null;
        try {
            VariableMap variableMap = (VariableMap)WsServiceRegistry.getService(this, VariableMap.class);
            string = variableMap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = System.getProperty("was.install.root");
        }
        if (_tc.isEntryEnabled()) {
            Tr.debug(_tc, "Returning WAS install root directory: " + string);
            Tr.exit(_tc, "getInstallRootDir");
        }
        return string;
    }

    private String getJarName(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJarName", "installRoot=" + string + ", bundleLocation=" + string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(File.separator);
        int n = string2.indexOf(64);
        if (n >= 0) {
            String string3 = string2.substring(n + 1);
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(string2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getJarName", "jarName = '" + stringBuffer.toString() + "'.");
        }
        return stringBuffer.toString();
    }

    public SoapContainerService getSOAPContainerService() {
        if (this.soapContainerService == null) {
            this.soapContainerService = (SoapContainerService)this.getService(SoapContainerService.class);
            if (this.soapContainerService == null) {
                Tr.error(_tc, "internal.error", "com.ibm.ws.webservices.component.WSSysServerImpl.getSOAPContainerService: Could not get service for SoapContainerService.class");
            }
        }
        return this.soapContainerService;
    }

    static systemApps loadSysAppConfigXML(URL uRL) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to load sysapp config xml file: " + uRL.toString());
        }
        InputStream inputStream = null;
        systemApps systemApps2 = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.webservices.component.WSSysServerImpl.loadSysAppConfigXML", "426");
            Tr.error(_tc, "internal.error", iOException);
        }
        if (inputStream != null) {
            systemAppsFactory systemAppsFactory2 = new systemAppsFactory();
            systemAppsFactory2.setPackageName("com.ibm.ws.webservices.xml.wassysapp");
            systemApps2 = (systemApps)systemAppsFactory2.loadDocument("systemApps", new InputSource(inputStream));
        }
        return systemApps2;
    }

    static ArrayList createSysAppServerMetaDatas(String string, systemApps systemApps2, WebServices webServices, WSBinding wSBinding, LoadStrategy loadStrategy, String string2, ClassLoader classLoader) throws ClassNotFoundException, IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSysAppServerMetaData");
        }
        ArrayList<ServerModuleMetaData> arrayList = new ArrayList<ServerModuleMetaData>();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Inside createSysAppServerMetaData, CCL = " + Thread.currentThread().getContextClassLoader());
        }
        String string3 = string;
        int n = webServices.getWebServiceDescriptions().size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            ServerModuleMetaData serverModuleMetaData = null;
            String string4 = null;
            WebServiceDescription webServiceDescription = (WebServiceDescription)webServices.getWebServiceDescriptions().get(i);
            MappingMetaData mappingMetaData = WSServerImpl.loadJavaWsdlMappingXML(loadStrategy, webServiceDescription.getJaxrpcMappingFile());
            if (mappingMetaData == null) {
                objectArray = new Object[]{webServiceDescription.getJaxrpcMappingFile(), webServiceDescription.getWebServiceDescriptionName(), "WEB-INF/webservices.xml", string2, string3};
                Tr.error(_tc, "mappingFile.not.found", objectArray);
                continue;
            }
            objectArray = webServiceDescription.getWsdlFile();
            WSDescBinding wSDescBinding = WSServerImpl.findWsDescBinding("META-INF/ibm-webservices-bnd.xmi", wSBinding, webServiceDescription);
            int n2 = webServiceDescription.getPortComponents().size();
            for (int j = 0; j < n2; ++j) {
                PortComponent portComponent = (PortComponent)webServiceDescription.getPortComponents().get(j);
                String string5 = portComponent.getPortComponentName();
                String string6 = portComponent.getServiceImplBean().getEServletLink().getServletLink();
                systemApp systemApp2 = WSSysServerImpl.findSysappForServlet(string6, systemApps2);
                if (systemApp2 == null) {
                    Tr.warning(_tc, "warning.servlet.link.not.found", (Object)new Object[]{string6, string5});
                    continue;
                }
                systemAppPort systemAppPort2 = WSSysServerImpl.findSysappPort(string6, systemApps2);
                if (systemAppPort2 == null) {
                    Tr.warning(_tc, "warning.servlet.link.not.found", (Object)new Object[]{string6, string5});
                    continue;
                }
                if (serverModuleMetaData == null) {
                    string4 = systemApp2.getSystemAppName();
                    serverModuleMetaData = new SysServerModuleMetaData(string3, string4);
                    arrayList.add(serverModuleMetaData);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Created SysServerModuleMetaData: appName=" + string3 + ", moduleName=" + string4);
                    }
                }
                String string7 = systemAppPort2.getServletClass();
                ServerPortMetaData serverPortMetaData = serverModuleMetaData.getPort(string5, true);
                serverPortMetaData.setServletName(systemAppPort2.getServletName());
                String string8 = systemAppPort2.getUrlPattern();
                if (string8 != null) {
                    serverPortMetaData.setURLPattern(string8, false);
                } else {
                    serverPortMetaData.setURLPattern("/services/" + string5, true);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "System Application:  App(" + string3 + ")" + " Mod(" + string4 + ")" + " Service(" + string5 + ")" + " ServiceName(" + serverPortMetaData.getWsddPort().getName() + ")");
                }
                String string9 = WSServerImpl.buildWSDLPath(string2, (String)objectArray);
                WSServerImpl.setupWsddPort(serverPortMetaData.getWsddPort(), wSDescBinding, classLoader, string7, portComponent, WSServerImpl.createWSDDGen(mappingMetaData, string9, loadStrategy.getContainer().getInputStream((String)objectArray)));
                serverPortMetaData.getWsddPort().setDispatcherQName(WSConstants.QNAME_JAVARPC_DISPATCHER);
                JavaBeanDispatcher.setClassName(serverPortMetaData.getWsddPort(), string7);
                List list = WSServerImpl.getAllowedMethods(classLoader, portComponent.getServiceEndpointInterface());
                serverPortMetaData.getWsddPort().setAllowedMethods(list);
                serverPortMetaData.getWsddPort().validateDescriptors();
                if (_tc.isDebugEnabled()) {
                    serverPortMetaData.getWsddPort().dump();
                }
                PortURIManager.addSysAppPortMappings(string4, webServiceDescription.getWebServiceDescriptionName(), serverPortMetaData.getWsddPort().getQName(), serverPortMetaData.getURLPattern());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSysAppServerMetaData");
        }
        return arrayList;
    }

    private static systemAppPort findSysappPort(String string, systemApps systemApps2) {
        for (int i = 0; i < systemApps2.getsystemAppCount(); ++i) {
            systemApp systemApp2 = systemApps2.getSystemApp(i);
            for (int j = 0; j < systemApp2.getsystemAppPortCount(); ++j) {
                String string2 = systemApp2.getSystemAppPort(j).getServletName();
                if (string2 == null || !string2.equals(string)) continue;
                return systemApp2.getSystemAppPort(j);
            }
        }
        return null;
    }

    private static systemApp findSysappForServlet(String string, systemApps systemApps2) {
        for (int i = 0; i < systemApps2.getsystemAppCount(); ++i) {
            systemApp systemApp2 = systemApps2.getSystemApp(i);
            for (int j = 0; j < systemApp2.getsystemAppPortCount(); ++j) {
                String string2 = systemApp2.getSystemAppPort(j).getServletName();
                if (string2 == null || !string2.equals(string)) continue;
                return systemApp2;
            }
        }
        return null;
    }

    private SysServerModuleMetaData getServerModuleMetaData() {
        return (SysServerModuleMetaData)this.getSOAPContainerService().getMetaData();
    }

    static {
        WSModels.init();
        _tc = Tr.register(WSSysServerImpl.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
        singleton = null;
    }
}

