/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import [Ljava.security.cert.X509Certificate;;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.ssl.TrustManagerExtendedInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class WSX509TrustManager
implements X509TrustManager {
    private TrustManager[] tm = null;
    private KeyStore ts = null;
    private String tsPw = null;
    private String tsFile = null;
    private String tsPass = null;
    private Map extendedInfo = null;
    private String peerHost = null;
    private SSLConfig config = null;
    private ArrayList signersAdded = new ArrayList();
    private ArrayList messagesPrinted = new ArrayList();
    private Class trustEvaluatorClass = null;
    private Object trustedIDEvaluatorObject = null;
    private Method mutualAuthCBINDCheckMethod = null;
    boolean isDoubleByteSystem = false;
    boolean skipDefaultTMIfCustomTMDefined = false;
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    private static final TraceComponent tc = Tr.register(WSX509TrustManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final TimerAlarm timer = new TimerAlarm();
    private static final String TRUST_EVALUATOR_CLASS_NAME = "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl";

    public WSX509TrustManager(TrustManager[] trustManagerArray, Map map, SSLConfig sSLConfig, KeyStore keyStore, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSX509TrustManager", new Object[]{map, string});
        }
        this.tm = trustManagerArray;
        this.ts = keyStore;
        this.tsFile = string;
        this.tsPass = string2;
        this.config = sSLConfig;
        this.extendedInfo = map;
        String string3 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.skipDefaultTrustManagerWhenCustomDefined");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            this.skipDefaultTMIfCustomTMDefined = true;
        }
        if (this.extendedInfo != null) {
            this.peerHost = (String)this.extendedInfo.get("com.ibm.ssl.remoteHost");
            for (int i = 0; i < trustManagerArray.length; ++i) {
                if (trustManagerArray[i] == null || !(trustManagerArray[i] instanceof TrustManagerExtendedInfo)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding extended info to TrustManager " + trustManagerArray[i].getClass().getName());
                }
                ((TrustManagerExtendedInfo)((Object)trustManagerArray[i])).setExtendedInfo(this.extendedInfo);
                ((TrustManagerExtendedInfo)((Object)trustManagerArray[i])).setSSLConfig(sSLConfig);
            }
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            try {
                this.trustEvaluatorClass = Class.forName(TRUST_EVALUATOR_CLASS_NAME);
                this.trustedIDEvaluatorObject = this.trustEvaluatorClass.newInstance();
                this.mutualAuthCBINDCheckMethod = this.trustEvaluatorClass.getMethod("mutualAuthCBINDCheck", X509Certificate;.class);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No class, object, or method found for CBIND check", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.WSX509TrustManager.WSX509TrustManager", "120", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSX509TrustManager");
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClientTrusted");
        }
        if (tc.isDebugEnabled()) {
            for (n = 0; n < x509CertificateArray.length; ++n) {
                Tr.debug(tc, "chain[" + n + "]: " + x509CertificateArray[n].getSubjectDN());
            }
        }
        if (this.isCertificateAuthenticationDisabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate authentication is temporarily disabled due to configuration change.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkClientTrusted");
            }
            return;
        }
        for (n = 0; n < this.tm.length; ++n) {
            if (this.tm[n] == null || !(this.tm[n] instanceof X509TrustManager)) continue;
            if (this.skipDefaultTMIfCustomTMDefined && n == 0 && this.tm.length > 1) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping default trust manager name: " + this.tm[n].getClass().getName());
                continue;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Delegating to X509TrustManager: " + this.tm[n].getClass().getName());
                }
                ((X509TrustManager)this.tm[n]).checkClientTrusted(x509CertificateArray, string);
                continue;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Certificate Exception occurred: " + exception.getMessage());
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "167", this);
                this.printClientHandshakeError(this.config, this.extendedInfo, this.tsFile, exception, x509CertificateArray, string);
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                throw new CertificateException(exception.getMessage());
            }
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            try {
                if (this.mutualAuthCBINDCheckMethod != null && !((Boolean)this.mutualAuthCBINDCheckMethod.invoke(this.trustedIDEvaluatorObject, new Object[]{x509CertificateArray})).booleanValue()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkClientTrusted");
                    }
                    throw new CertificateException("CBIND check failed.");
                }
            }
            catch (Exception exception) {
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkClientTrusted");
                }
                throw new CertificateException("CBIND check failed.", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClientTrusted");
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkServerTrusted");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target host: " + this.peerHost);
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                Tr.debug(tc, "Certificate information:");
                Tr.debug(tc, "  Subject DN: " + x509CertificateArray[i].getSubjectDN());
                Tr.debug(tc, "  Issuer DN: " + x509CertificateArray[i].getIssuerDN());
                Tr.debug(tc, "  Serial number: " + x509CertificateArray[i].getSerialNumber());
                Tr.debug(tc, "");
            }
        }
        if (this.isCertificateAuthenticationDisabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate authentication is temporarily disabled due to configuration change.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkServerTrusted");
            }
            return;
        }
        CertificateException certificateException = null;
        for (int i = 0; i < this.tm.length; ++i) {
            if (this.tm[i] == null || !(this.tm[i] instanceof X509TrustManager)) continue;
            if (this.skipDefaultTMIfCustomTMDefined && i == 0 && this.tm.length > 1) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping default trust manager name: " + this.tm[i].getClass().getName());
                continue;
            }
            boolean bl = false;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Delegating to X509TrustManager: " + this.tm[i].getClass().getName());
                }
                ((X509TrustManager)this.tm[i]).checkServerTrusted(x509CertificateArray, string);
                continue;
            }
            catch (CertificateException certificateException2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Certificate Exception occurred: " + certificateException2.getMessage());
                }
                certificateException = certificateException2;
                boolean bl2 = this.checkIfExpiredBeforeOrAfter(x509CertificateArray);
                if (!bl2) {
                    throw certificateException2;
                }
                boolean bl3 = false;
                boolean bl4 = false;
                String string2 = this.getProperty("com.ibm.ssl.trustStoreReadOnly", this.config, SSLConfigManager.getInstance().isServerProcess());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "readOnlyValue is " + string2);
                }
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    bl4 = true;
                }
                boolean bl5 = ThreadManager.getInstance().getAutoAcceptBootstrapSigner();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server is NOT trusted by X509TrustManager, auto accept mode? " + bl5);
                }
                ThreadManager.getInstance().setAutoAcceptBootstrapSigner(false);
                boolean bl6 = ThreadManager.getInstance().getAutoAcceptBootstrapSignerWithoutStorage();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server is NOT trusted by X509TrustManager, auto accept w/o storage mode? " + bl6);
                }
                ThreadManager.getInstance().setAutoAcceptBootstrapSignerWithoutStorage(false);
                String string3 = this.getProperty("com.ibm.ssl.enableSignerExchangePrompt", this.config, SSLConfigManager.getInstance().isServerProcess());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server is NOT trusted by X509TrustManager, prompt for signer exchange? " + string3);
                }
                if (!bl6 && (bl5 || string3 != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes")))) {
                    String string4 = "Cannot determine SHA digest.";
                    String string5 = "Cannot determine MD5 digest.";
                    try {
                        string4 = KeyStoreManager.getInstance().generateDigest("SHA-1", x509CertificateArray[x509CertificateArray.length - 1]);
                        string5 = KeyStoreManager.getInstance().generateDigest("MD5", x509CertificateArray[x509CertificateArray.length - 1]);
                        if (string4 != null) {
                            bl3 = this.signersAdded.contains(string4);
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No class found for generateDigest.", new Object[]{noClassDefFoundError});
                        }
                        FFDCFilter.processException((Throwable)noClassDefFoundError, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "310", this);
                    }
                    if (!bl3 && !SSLConfigManager.getInstance().isServerProcess()) {
                        if (!bl5) {
                            System.out.println("");
                            System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0100I", "*** SSL SIGNER EXCHANGE PROMPT ***"));
                            System.out.println(TraceNLSHelper.getInstance().getFormattedMessage("ssl.trustmanager.signer.prompt.CWPKI0101I", new Object[]{this.peerHost, this.tsFile}, "SSL signer from target host " + this.peerHost + " is not found in trust store " + this.tsFile + ".\n\nHere's the signer information (verify the digest value matches what is displayed at the server):"));
                            System.out.println("");
                            for (int j = 0; j < x509CertificateArray.length; ++j) {
                                System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0102I", "  Subject DN:    ") + x509CertificateArray[j].getSubjectDN());
                                System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0103I", "  Issuer DN:     ") + x509CertificateArray[j].getIssuerDN());
                                System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0104I", "  Serial number: ") + x509CertificateArray[j].getSerialNumber());
                                System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0109I", "  Expires: ") + x509CertificateArray[j].getNotAfter());
                                System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0105I", "  SHA-1 digest:  ") + string4);
                                System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0106I", "  MD5 digest:    ") + string5);
                                System.out.println("");
                            }
                        }
                        try {
                            String string6 = null;
                            String string7 = null;
                            if (!bl5) {
                                System.out.print(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0107I", "Add signer to the trust store now? (y/n) "));
                                System.out.flush();
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                                string6 = bufferedReader.readLine();
                                if (string6 != null) {
                                    string6 = string6.trim().toLowerCase();
                                }
                                if ((string7 = TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.answer.yes", "y")) != null) {
                                    if ((string7 = string7.trim().toLowerCase()).length() == 0) {
                                        string7 = "y";
                                    }
                                } else {
                                    string7 = "y";
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Translated yes string is: " + string7);
                                }
                            }
                            if (!bl4 && (bl5 || string6 != null && (string6.startsWith("y") || string6.startsWith(string7)))) {
                                for (int j = 0; j < x509CertificateArray.length; ++j) {
                                    Object object;
                                    String string8;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding cert " + x509CertificateArray[j].getSubjectDN().getName() + " to TrustStore " + this.tsFile + ".");
                                    }
                                    if (!this.ts.containsAlias(string8 = x509CertificateArray[j].getSubjectDN().getName())) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding alias \"" + string8 + "\" to truststore \"" + this.tsFile + "\".");
                                        }
                                        this.ts.setCertificateEntry(string8, x509CertificateArray[j]);
                                        if (bl5) {
                                            object = this.getProperty("com.ibm.ssl.trustStoreName", this.config, SSLConfigManager.getInstance().isServerProcess());
                                            this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{string8, object, string4}, "CWPKI0308I: Adding signer alias \"" + string8 + "\" to local keystore \"" + (String)object + "\" with the following SHA digest: " + string4);
                                        }
                                    } else {
                                        int n = 1;
                                        String string9 = null;
                                        while (this.ts.containsAlias(string9 = string8 + "_" + n++)) {
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding alias \"" + string9 + "\" to truststore \"" + this.tsFile + "\".");
                                        }
                                        this.ts.setCertificateEntry(string9, x509CertificateArray[j]);
                                        if (bl5) {
                                            String string10 = this.getProperty("com.ibm.ssl.trustStoreName", this.config, SSLConfigManager.getInstance().isServerProcess());
                                            this.issueMessage("ssl.signer.add.to.local.truststore.CWPKI0308I", new Object[]{string9, string10, string4}, "CWPKI0308I: Adding signer alias \"" + string9 + "\" to local keystore \"" + string10 + "\" with the following SHA digest: " + string4);
                                        }
                                    }
                                    object = KeyStoreManager.getInstance().getOutputStream(this.tsFile);
                                    this.ts.store((OutputStream)object, this.tsPass.toCharArray());
                                    if (string4 != null) {
                                        this.signersAdded.add(string4);
                                    }
                                    bl3 = true;
                                    ((OutputStream)object).close();
                                    if (bl5) continue;
                                    System.out.println(TraceNLSHelper.getInstance().getString("ssl.trustmanager.signer.prompt.CWPKI0108I", "A retry of the request may need to occur."));
                                }
                            } else {
                                if (bl4 && string6 != null && (string6.startsWith("y") || string6.startsWith(string7))) {
                                    ThreadManager.getInstance().setAutoAcceptBootstrapSignerWithoutStorage(true);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Accepting signer for read-only keystore per prompt response.");
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "checkServerTrusted");
                                    }
                                    return;
                                }
                                if (string6 != null) {
                                    this.printClientHandshakeError(this.config, this.extendedInfo, this.tsFile, certificateException2, x509CertificateArray, string);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Received the following exception added signer to TrustStore.", new Object[]{exception});
                            }
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.WSX509TrustManager.checkServerTrusted", "425", this);
                        }
                    }
                } else if (ThreadManager.getInstance().getSetSignerOnThread()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting signer chain on the thread from the WSX509TrustManager.");
                    }
                    ThreadManager.getInstance().setSignerChain(x509CertificateArray);
                } else {
                    if (bl6) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Accepting signer but not storing into trust store.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkServerTrusted");
                        }
                        return;
                    }
                    this.printClientHandshakeError(this.config, this.extendedInfo, this.tsFile, certificateException2, x509CertificateArray, string);
                }
                if (bl3) continue;
                throw certificateException;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server is trusted by all X509TrustManagers.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkServerTrusted");
        }
    }

    private boolean checkIfExpiredBeforeOrAfter(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray != null && x509CertificateArray[0] != null) {
            long l = System.currentTimeMillis();
            long l2 = x509CertificateArray[0].getNotBefore().getTime();
            long l3 = x509CertificateArray[0].getNotAfter().getTime();
            if (l2 > l) {
                Tr.error(tc, "ssl.certificate.before.date.invalid.CWPKI0311E", new Object[]{x509CertificateArray[0].getSubjectDN(), new Date(l2)});
                return false;
            }
            if (l3 < l) {
                Tr.error(tc, "ssl.certificate.end.date.invalid.CWPKI0312E", new Object[]{x509CertificateArray[0].getSubjectDN(), new Date(l3)});
                return false;
            }
            return true;
        }
        return false;
    }

    private void printClientHandshakeError(SSLConfig sSLConfig, Map map, String string, Exception exception, X509Certificate[] x509CertificateArray, String string2) {
        String string3;
        String string4 = exception.getMessage();
        String string5 = "unknown";
        if (x509CertificateArray[0] != null) {
            string5 = ((Object)x509CertificateArray[0].getSubjectDN()).toString();
        }
        String string6 = this.getProperty("com.ibm.ssl.alias", sSLConfig, SSLConfigManager.getInstance().isServerProcess());
        String string7 = this.getProperty("com.ibm.ssl.configURLLoadedFrom", sSLConfig, SSLConfigManager.getInstance().isServerProcess());
        String string8 = "unknown";
        String string9 = "0";
        if (map != null) {
            string8 = (String)map.get("com.ibm.ssl.remoteHost");
            string9 = (String)map.get("com.ibm.ssl.remotePort");
        }
        String string10 = string8 + ":" + string9;
        String string11 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.client.handshake.error.CWPKI0022E", new Object[]{string5, string10, string, string6, string7, string4}, "CWPKI0022E: SSL handshake failure occurred.  A signer with SubjectDN " + string5 + " was sent from target host/port " + string10 + ".  The signer may need to be added to local trust store " + string + " located in SSL configuration alias " + string6 + " loaded from configURL " + string7 + ".  The extended error message from the SSL handshake is: " + string4);
        if (!this.messagesPrinted.contains(string11)) {
            Tr.error(tc, "ssl.client.handshake.error.CWPKI0022E", new Object[]{string5, string10, string, string6, string7, string4});
            System.out.println("");
            System.out.println(string11);
            System.out.println("");
            if (this.messagesPrinted.size() > 20) {
                this.messagesPrinted.clear();
            }
            this.messagesPrinted.add(string11);
        }
        if (!SSLConfigManager.getInstance().isServerProcess() && !this.messagesPrinted.contains(string3 = TraceNLSHelper.getInstance().getString("ssl.handshake.failure.info.CWPKI0040I", "CWPKI0040I: An SSL handshake failure occurred from a client.  The server's SSL signer needs to be added to the client trust store.  A retrieveSigners utility is provided for this function.  Check with your administrator to have this utility run to setup the secure enviroment before running the client.   Additional, the com.ibm.ssl.enableSignerExchangePrompt can be enabled in ssl.client.props for DefaultSSLSettings in order to allow acceptance of the signer during the connection attempt."))) {
            System.out.println("");
            System.out.println(string3);
            System.out.println("");
            if (this.messagesPrinted.size() > 20) {
                this.messagesPrinted.clear();
            }
            this.messagesPrinted.add(string3);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAcceptedIssuers");
        }
        X509Certificate[] x509CertificateArray = null;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (int i = 0; i < this.tm.length; ++i) {
            if (!(this.tm[i] instanceof X509TrustManager)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Delegating to X509TrustManager: " + this.tm[i].getClass().getName());
            }
            if ((x509CertificateArray = ((X509TrustManager)this.tm[i]).getAcceptedIssuers()) == null) continue;
            for (int j = 0; j < x509CertificateArray.length; ++j) {
                if (arrayList.contains(x509CertificateArray[j])) continue;
                arrayList.add(x509CertificateArray[j]);
            }
        }
        if (arrayList.size() > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAcceptedIssuers");
            }
            return arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        return null;
    }

    protected void issueMessage(String string, Object[] objectArray, String string2) {
        String string3 = TraceNLSHelper.getInstance().getFormattedMessage(string, objectArray, string2);
        this.printMessage(string3);
    }

    protected void printMessage(String string) {
        int n = 79;
        if (this.isDoubleByteSystem(string)) {
            n /= 2;
        }
        this.printMessage(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.isDoubleByteSystem = (double)byArray.length > (double)string.length() + (double)string.length() * 0.1;
        return this.isDoubleByteSystem;
    }

    private void printMessage(String string, int n, boolean bl) {
        int n2 = n;
        if (bl) {
            System.out.print(INDENT);
            n2 -= INDENT.length();
        }
        if (string.length() <= n2) {
            System.out.println(string);
        } else {
            int n3 = string.lastIndexOf(32, n2);
            if (n3 == -1 && (n3 = string.indexOf(32)) == -1) {
                System.out.println(string);
                return;
            }
            this.printMessage(string.substring(0, n3), n, false);
            this.printMessage(string.substring(n3 + 1), n, true);
        }
    }

    private String getProperty(String string, Properties properties, boolean bl) {
        String string2 = null;
        if (properties != null) {
            if (!bl && (string2 = System.getProperty(string)) == null) {
                string2 = SSLConfigManager.getInstance().getGlobalProperty(string);
            }
            if (string2 == null) {
                string2 = properties.getProperty(string);
            }
        } else {
            string2 = System.getProperty(string);
            if (string2 == null) {
                string2 = SSLConfigManager.getInstance().getGlobalProperty(string);
            }
        }
        return string2;
    }

    private boolean isCertificateAuthenticationDisabled() {
        return timer.isCertificateAuthenticationDisabled();
    }

    protected static void temporarilyDisableCertificateAuthentication(Long l) {
        timer.temporarilyDisableCertificateAuthentication(l);
    }

    static class TimerAlarm
    implements AlarmListener {
        private boolean certificateAuthenticationEnabled = true;

        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm", object);
            }
            this.certificateAuthenticationEnabled = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "alarm");
            }
        }

        protected void temporarilyDisableCertificateAuthentication(Long l) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "temporarilyDisableCertificateAuthentication");
            }
            this.certificateAuthenticationEnabled = false;
            AlarmManager.createDeferrable(l, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "temporarilyDisableCertificateAuthentication");
            }
        }

        protected boolean isCertificateAuthenticationDisabled() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isCertificateAuthenticationDisabled");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCertificateAuthenticationDisabled -> " + !this.certificateAuthenticationEnabled);
            }
            return !this.certificateAuthenticationEnabled;
        }
    }
}

