/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Date;

public class CertificateManager {
    private static final TraceComponent tc = Tr.register(CertificateManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static CertificateManager thisClass = null;

    private CertificateManager() {
    }

    public static CertificateManager getInstance() {
        if (thisClass == null) {
            thisClass = new CertificateManager();
        }
        return thisClass;
    }

    public Certificate selfSignedCertificateCreate(CertReqInfo certReqInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfSignedCertificateCreate", new Object[]{certReqInfo});
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        KeyStoreInfo keyStoreInfo = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        string2 = certReqInfo.getSubjectDN();
        string = certReqInfo.getLabel();
        n = certReqInfo.getSize();
        n2 = certReqInfo.getValidDays();
        keyStoreInfo = certReqInfo.getKsInfo();
        string3 = keyStoreInfo.getLocation();
        string4 = keyStoreInfo.getType();
        string5 = keyStoreInfo.getProvider();
        string6 = keyStoreInfo.getPassword();
        Boolean bl = keyStoreInfo.getStashFile();
        PkSsCertificate pkSsCertificate = null;
        Certificate certificate = null;
        KeyStore keyStore = null;
        try {
            Method method;
            Class<?> clazz;
            Date date = new Date();
            date.setTime(date.getTime() - 86400000L);
            pkSsCertificate = !JSSEProviderFactory.isFipsEnabled() ? PkSsCertFactory.newSsCert((int)n, (String)string2, (int)n2, (Date)date, (boolean)true, (boolean)true, (String)"IBMJCE") : PkSsCertFactory.newSsCert((int)n, (String)string2, (int)n2, (Date)date, (boolean)true, (boolean)true, (String)"IBMJCEFIPS");
            try {
                Tr.audit(tc, "Self Signed Certificate: notBefore time: " + pkSsCertificate.getCertificate().getNotBefore().toString() + " notAfter time: " + pkSsCertificate.getCertificate().getNotAfter().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            keyStore = KeyStore.getInstance(string4, string5);
            File file = new File(string3);
            if (!file.exists()) {
                keyStore.load(null, string6.toCharArray());
            } else if (string4 != null && (string4.equals("CMSKS") || string4.equals("IBMi5OSKeyStore"))) {
                clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                method = clazz.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
                keyStore = (KeyStore)method.invoke(clazz.newInstance(), file, string3, string6, string4, string5, bl.toString());
            } else {
                inputStream = KeyStoreManager.getInstance().getInputStream(string3, true);
                keyStore.load(inputStream, string6.toCharArray());
            }
            pkSsCertificate.setToKeyStore(string, string6, keyStore);
            certificate = keyStore.getCertificate(string);
            if (string4 != null && (string4.equals("CMSKS") || string4.equals("IBMi5OSKeyStore"))) {
                clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                method = clazz.getMethod("storeCMSKeyStore", KeyStore.class, String.class, String.class, String.class, String.class);
                method.invoke(clazz.newInstance(), keyStore, string3, string6, string4, bl.toString());
            } else {
                fileOutputStream = new FileOutputStream(string3);
                keyStore.store(fileOutputStream, string6.toCharArray());
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error creating keystore or certificate.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.self.signed.create.error.CWPKI0032E", new Object[]{exception.getMessage()});
            String string7 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.self.signed.create.error.CWPKI0032E", new Object[]{exception.getMessage()}, "Error creating a self-signed certificate.  The exception is " + exception.getMessage());
            throw new SSLException(string7, exception);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfSignedCertificateCreate");
        }
        return certificate;
    }

    public KeyPair generateKeyPair(CertReqInfo certReqInfo) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeyPair", new Object[]{certReqInfo});
        }
        String string = certReqInfo.getSubjectDN();
        String string2 = certReqInfo.getLabel();
        int n = certReqInfo.getSize();
        int n2 = certReqInfo.getValidDays();
        PkSsCertificate pkSsCertificate = null;
        Certificate[] certificateArray = null;
        PrivateKey privateKey = null;
        try {
            Date date = new Date();
            date.setTime(date.getTime() - 86400000L);
            pkSsCertificate = !JSSEProviderFactory.isFipsEnabled() ? PkSsCertFactory.newSsCert((int)n, (String)string, (int)n2, (Date)date, (boolean)true, (boolean)true, (String)"IBMJCE") : PkSsCertFactory.newSsCert((int)n, (String)string, (int)n2, (Date)date, (boolean)true, (boolean)true, (String)"IBMJCEFIPS");
            if (pkSsCertificate != null) {
                certificateArray = new Certificate[]{pkSsCertificate.getCertificate()};
                privateKey = pkSsCertificate.getKey();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateKeyPair");
                }
                return new KeyPair(certificateArray, (Key)privateKey);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateKeyPair");
            }
            throw new KeyException("Error generating key pair.");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error creating keystore or certificate.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.self.signed.create.error.CWPKI0032E", new Object[]{exception.getMessage()});
            String string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.self.signed.create.error.CWPKI0032E", new Object[]{exception.getMessage()}, "Error creating a self-signed certificate.  The exception is " + exception.getMessage());
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(string3, exception);
        }
    }

    public boolean isKeyCertJarAvailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyCertJarAvailable");
        }
        boolean bl = true;
        String string = "com.ibm.security.certclient.util.PkSsCertFactory";
        try {
            Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "isKeyCertJarAvailable", "Unable to load class \"" + string + "\".");
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyCertJarAvailable", bl);
        }
        return bl;
    }
}

