/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class SSLHandshakeIOCallback
implements TCPReadCompletedCallback,
TCPWriteCompletedCallback {
    protected static final TraceComponent tc = Tr.register(SSLHandshakeIOCallback.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private SSLConnectionLink connLink;
    private WsByteBuffer netBuffer;
    private WsByteBuffer decryptedNetBuffer;
    private WsByteBuffer appBuffer;
    private WsByteBuffer encryptedAppBuffer;
    private ProtoSSLEngineResult result;
    private SSLHandshakeCompletedCallback callback;

    public SSLHandshakeIOCallback(SSLConnectionLink sSLConnectionLink, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4, ProtoSSLEngineResult protoSSLEngineResult, SSLHandshakeCompletedCallback sSLHandshakeCompletedCallback) {
        this.connLink = sSLConnectionLink;
        this.netBuffer = wsByteBuffer;
        this.decryptedNetBuffer = wsByteBuffer2;
        this.appBuffer = wsByteBuffer3;
        this.encryptedAppBuffer = wsByteBuffer4;
        this.result = protoSSLEngineResult;
        this.callback = sSLHandshakeCompletedCallback;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete(read)");
        }
        try {
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.appBuffer, this.encryptedAppBuffer, this.result, this.callback, true);
        }
        catch (IOException iOException) {
            this.error(virtualConnection, tCPReadRequestContext, iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete(read)");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Error occured during a read, exception:" + iOException);
        }
        this.callback.error(iOException);
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete(write)");
        }
        this.encryptedAppBuffer.clear();
        try {
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.appBuffer, this.encryptedAppBuffer, this.result, this.callback, true);
        }
        catch (IOException iOException) {
            this.error(virtualConnection, tCPWriteRequestContext, iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete(write)");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Error occured during a write, exception:" + iOException);
        }
        this.callback.error(iOException);
    }
}

