/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.SASPropFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropFilePasswordEncoder {
    public static void main(String[] stringArray) {
        Object object;
        String string;
        Object object2;
        boolean bl;
        Object object3;
        File file;
        if (stringArray.length != 2 && stringArray.length != 3 || stringArray[0] == null || stringArray[1] == null || stringArray.length == 3 && (stringArray[2] == null || stringArray[2].compareToIgnoreCase("-Backup") != 0 && stringArray[2].compareToIgnoreCase("-noBackup") != 0)) {
            System.out.println("USAGE:  java PropFilePasswordEncoder file_name password_properties_list [-Backup/-noBackup]");
            System.out.println("        java PropFilePasswordEncoder file_name -SAS [-Backup/-noBackup]");
            System.exit(1);
        }
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        if (string2.length() == 0 || string3.length() == 0) {
            System.out.println("USAGE:  java PropFilePasswordEncoder file_name password_properties_list [-Backup/-noBackup]");
            System.out.println("        java PropFilePasswordEncoder file_name -SAS [-Backup/-noBackup]");
            System.exit(1);
        }
        if (!(file = new File(string2)).isAbsolute()) {
            file = new File(file.getAbsolutePath());
        }
        if (!file.exists()) {
            System.out.println("ERROR:  invalid target file == " + file.toString());
            System.exit(1);
        }
        Properties properties = null;
        ArrayList<String> arrayList = null;
        FileInputStream fileInputStream = null;
        boolean bl2 = false;
        if (string3.equalsIgnoreCase("-SAS")) {
            properties = new Properties();
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "108");
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2) {
                        FFDCFilter.processException(iOException2, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "117");
                    }
                }
                System.out.println("ERROR:  cannot load properties from target file == " + file.toString());
                System.exit(1);
            }
            try {
                bl2 = SASPropFile.encodePropPasswords(properties);
            }
            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
                FFDCFilter.processException((Throwable)((Object)invalidPasswordEncodingException), "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "133");
                System.out.println("ERROR:  invalid password encoding exception");
                System.exit(1);
            }
        } else {
            if (string3 == null || string3.length() == 0) {
                System.out.println("ERROR:  password properties list is null or empty");
                System.exit(1);
            }
            InputStreamReader inputStreamReader = null;
            object3 = null;
            arrayList = new ArrayList<String>();
            try {
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader(fileInputStream);
                object3 = new BufferedReader(inputStreamReader);
                String string4 = ((BufferedReader)object3).readLine();
                while (string4 != null) {
                    arrayList.add(string4);
                    string4 = ((BufferedReader)object3).readLine();
                }
                ((BufferedReader)object3).close();
                object3 = null;
                inputStreamReader.close();
                inputStreamReader = null;
                fileInputStream.close();
                fileInputStream = null;
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "170");
                try {
                    if (object3 != null) {
                        ((BufferedReader)object3).close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException3) {
                    FFDCFilter.processException(iOException3, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "182");
                }
                System.out.println("ERROR:  cannot load properties from target file == " + file.toString());
                System.exit(1);
            }
            bl = false;
            object2 = new StringTokenizer(string3, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string = ((StringTokenizer)object2).nextToken();
                if (string == null) continue;
                object = string.trim();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string5;
                    int n;
                    String string6 = ((String)arrayList.get(i)).trim();
                    if (string6.startsWith("#") && string6.length() == 0 || (n = string6.indexOf(61)) == -1 || !(string5 = string6.substring(0, n).trim()).equals(string)) continue;
                    String string7 = string6.substring(n + 1).trim();
                    bl = true;
                    if (string7.length() <= 0) continue;
                    String string8 = PasswordUtil.passwordEncode(string7);
                    if (string8 == null) {
                        System.out.println("ERROR:  invalid password encoding exception");
                        System.exit(1);
                    }
                    if (string8.equals(string7)) continue;
                    bl2 = true;
                    arrayList.set(i, string5 + "=" + string8);
                }
            }
            if (!bl) {
                System.out.println("ERROR:  no password properties in specified list were found in target file");
                System.exit(1);
            }
        }
        if (!bl2) {
            System.out.println("NOTE:  all specified passwords already encoded in target file == " + file.toString());
            System.exit(0);
        }
        boolean bl3 = false;
        if (stringArray.length == 3 && stringArray[2].compareToIgnoreCase("-Backup") == 0) {
            bl3 = true;
        } else if (stringArray.length == 3 && stringArray[2].compareToIgnoreCase("-noBackup") == 0) {
            bl3 = false;
        } else {
            object3 = System.getProperty("com.ibm.websphere.security.util.createBackup");
            if (object3 != null && ((String)object3).equalsIgnoreCase("false")) {
                bl3 = false;
            } else if (object3 != null && ((String)object3).equalsIgnoreCase("true")) {
                bl3 = true;
            } else {
                bl = true;
                while (bl) {
                    System.out.println("Create a backup file of the original properties file which contains unencoded passwords? (y/n)");
                    System.out.flush();
                    object2 = new BufferedReader(new InputStreamReader(System.in));
                    string = null;
                    try {
                        string = ((BufferedReader)object2).readLine();
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR:  cannot read input from console" + exception);
                        System.exit(1);
                    }
                    if (string != null) {
                        if ((string = string.trim()).equalsIgnoreCase("n")) {
                            bl3 = false;
                            bl = false;
                            continue;
                        }
                        if (!string.equalsIgnoreCase("y")) continue;
                        bl3 = true;
                        bl = false;
                        continue;
                    }
                    System.out.println("ERROR: interrupted");
                    System.exit(1);
                }
            }
        }
        if (bl3) {
            object3 = new File(file.toString() + ".bak");
            try {
                FileInputStream fileInputStream2 = new FileInputStream(file);
                object2 = new FileOutputStream((File)object3);
                int n = fileInputStream2.available();
                object = new byte[n];
                fileInputStream2.read((byte[])object, 0, n);
                ((FileOutputStream)object2).write((byte[])object, 0, ((Object)object).length);
                fileInputStream2.close();
                ((FileOutputStream)object2).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("ERROR:  File not found");
                fileNotFoundException.printStackTrace();
                System.exit(1);
            }
            catch (IOException iOException) {
                System.out.println("File i/o error");
                iOException.printStackTrace();
                System.exit(1);
            }
            if (!((File)object3).exists()) {
                System.out.println("ERROR:  cannot create backup file == " + ((File)object3).toString());
                System.exit(1);
            } else {
                System.out.println("NOTE:  Backup file " + ((File)object3).toString() + " contains unencoded passwords");
            }
        }
        object3 = null;
        OutputStreamWriter outputStreamWriter = null;
        object2 = null;
        try {
            object3 = new FileOutputStream(file);
            if (string3.equalsIgnoreCase("-SAS")) {
                SASPropFile.saveConfig(properties, (FileOutputStream)object3);
            } else {
                outputStreamWriter = new OutputStreamWriter((OutputStream)object3);
                object2 = new BufferedWriter(outputStreamWriter);
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ((Writer)object2).write((String)arrayList.get(i) + "\n");
                    }
                }
                ((BufferedWriter)object2).close();
                object2 = null;
                outputStreamWriter.close();
                outputStreamWriter = null;
            }
            ((FileOutputStream)object3).close();
            object3 = null;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "386");
            try {
                if (object2 != null) {
                    ((BufferedWriter)object2).close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (object3 != null) {
                    ((FileOutputStream)object3).close();
                }
            }
            catch (IOException iOException4) {
                FFDCFilter.processException(iOException4, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "398");
            }
            System.out.println("ERROR:  cannot save properties to target file == " + file.toString());
            System.exit(1);
        }
        System.exit(0);
    }
}

