/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.models.base.resources.ConnectionPool;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.models.config.properties.impl.PropertyImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.ResourceBinderImpl;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.jca.AuthenticationMechanism;
import org.eclipse.jst.j2ee.jca.ConnectionDefinition;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.License;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;
import org.eclipse.jst.j2ee.jca.ResourceAdapter;

public abstract class J2CBinder
extends ResourceBinderImpl {
    private static final TraceComponent tc = Tr.register(J2CBinder.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");
    protected static final String RAR_PROPERTIES = "RAR.PROPS";

    protected void addConnectorProperties(Properties properties, J2CResourceAdapter j2CResourceAdapter) {
        Connector connector = j2CResourceAdapter.getDeploymentDescriptor();
        Properties properties2 = new Properties();
        this.addConnectorProperties(properties2, connector);
        this.addPaths(properties2, j2CResourceAdapter.getArchivePath(), j2CResourceAdapter.getClasspath(), j2CResourceAdapter.getNativepath());
        properties.putAll((Map<?, ?>)properties2);
    }

    protected void addConnectorProperties(Properties properties, Connector connector) {
        if (connector == null) {
            return;
        }
        boolean bl = this.checkJCA15(connector.getSpecVersion());
        ResourceAdapter resourceAdapter = connector.getResourceAdapter();
        OutboundResourceAdapter outboundResourceAdapter = resourceAdapter.getOutboundResourceAdapter();
        EList eList = null;
        eList = !bl ? resourceAdapter.getAuthenticationMechanisms() : outboundResourceAdapter.getAuthenticationMechanisms();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            AuthenticationMechanism authenticationMechanism = (AuthenticationMechanism)eList.get(i);
            String string = authenticationMechanism.getCredentialInterface();
            int n2 = authenticationMechanism.getAuthenticationMechanismType().getValue();
            if (n2 == 0) {
                this.setProperty(properties, ConnectionFactoryRefBuilder.SECURITY_BasicPassword, string);
                continue;
            }
            this.setProperty(properties, ConnectionFactoryRefBuilder.SECURITY_Kerbv5, string);
        }
        if (!bl) {
            this.setProperty(properties, "connectionFactoryImplClass", resourceAdapter.getConnectionFactoryImplClass());
            this.setProperty(properties, "connectionFactoryInterface", resourceAdapter.getConnectionFactoryInterface());
            this.setProperty(properties, "connectionImplClass", resourceAdapter.getConnectionImplClass());
            this.setProperty(properties, "connectionInterface", resourceAdapter.getConnectionInterface());
            this.setProperty(properties, "managedConnectionFactoryClass", resourceAdapter.getManagedConnectionFactoryClass());
            this.setProperty(properties, "reauthenticationSupport", new Boolean(resourceAdapter.isReauthenticationSupport()).toString());
            this.setProperty(properties, "transactionSupport", resourceAdapter.getTransactionSupport());
        } else {
            this.setProperty(properties, "reauthenticationSupport", new Boolean(outboundResourceAdapter.isReauthenticationSupport()).toString());
            this.setProperty(properties, "transactionSupport", outboundResourceAdapter.getTransactionSupport());
        }
        this.checkSetFirstItem(properties, "displayName", connector.getDisplayNames());
        this.setProperty(properties, "eisType", connector.getEisType());
        this.setProperty(properties, "specVersion", connector.getSpecVersion());
        this.setProperty(properties, "vendorName", connector.getVendorName());
        this.setProperty(properties, "version", connector.getVersion());
        this.checkSetFirstItem(properties, "j2c.adapter.largeIcon", connector.getIcons());
        this.checkSetFirstItem(properties, "j2c.adapter.smallIcon", connector.getIcons());
        License license = connector.getLicense();
        if (license != null) {
            this.checkSetFirstItem(properties, "j2c.adapter.licenseDescription", license.getDescriptions());
            this.setProperty(properties, "j2c.adapter.licenseRequired", new Boolean(license.isRequired()));
        }
    }

    protected void addConnectionPoolProperties(Properties properties, ConnectionPool connectionPool) {
        if (connectionPool != null) {
            this.setProperty(properties, "maxConnections", new Integer(connectionPool.getMaxConnections()));
            this.setProperty(properties, "minConnections", new Integer(connectionPool.getMinConnections()));
            this.setProperty(properties, "connectionTimeout", new Long(connectionPool.getConnectionTimeout()));
            this.setProperty(properties, "reapTime", new Long(connectionPool.getReapTime()));
            this.setProperty(properties, "unusedTimeout", new Long(connectionPool.getUnusedTimeout()));
            this.setProperty(properties, "purgePolicy", connectionPool.getPurgePolicy());
            this.setProperty(properties, "agedTimeout", new Long(connectionPool.getAgedTimeout()));
            this.setProperty(properties, "numberOfSharedPoolPartitions", new Integer(connectionPool.getNumberOfSharedPoolPartitions()));
            this.setProperty(properties, "numberOfFreePoolPartitions", new Integer(connectionPool.getNumberOfFreePoolPartitions()));
            this.setProperty(properties, "freePoolDistributionTableSize", new Integer(connectionPool.getFreePoolDistributionTableSize()));
            this.setProperty(properties, "surgeThreshold", new Integer(connectionPool.getSurgeThreshold()));
            this.setProperty(properties, "surgeCreationInterval", new Integer(connectionPool.getSurgeCreationInterval()));
            this.setProperty(properties, "stuckTime", new Integer(connectionPool.getStuckTime()));
            this.setProperty(properties, "stuckTimerTime", new Integer(connectionPool.getStuckTimerTime()));
            this.setProperty(properties, "stuckThreshold", new Integer(connectionPool.getStuckThreshold()));
            this.setProperty(properties, "testConnection", new Boolean(connectionPool.isTestConnection()));
            this.setProperty(properties, "testConnectionInterval", new Integer(connectionPool.getTestConnectionInterval()));
            EList eList = connectionPool.getProperties();
            int n = eList.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Gettng connection pool custom properties");
                Tr.debug(tc, "custom property list size " + n);
            }
            for (int i = 0; i < n; ++i) {
                PropertyImpl propertyImpl = (PropertyImpl)eList.get(i);
                String string = propertyImpl.getName();
                String string2 = propertyImpl.getValue();
                if (string.equals("globalConnectionTypeOverride")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting Connection Pool Custom Property: globalConnectionTypeOverride ");
                        Tr.debug(tc, "All connections for this pool will be  " + string2);
                    }
                    this.setProperty(properties, string, new String(string2));
                }
                if (!string.equals("defaultConnectionTypeOverride")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting Connection Pool Custom Property: defaultConnectionTypeOverride ");
                    Tr.debug(tc, "The default connection type for this pool will be: " + string2);
                }
                this.setProperty(properties, string, new String(string2));
            }
        }
    }

    protected void addConnectorPropertySet(ConnectorProperties connectorProperties, J2EEResourcePropertySet j2EEResourcePropertySet) {
        if (j2EEResourcePropertySet == null) {
            return;
        }
        if (connectorProperties == null) {
            return;
        }
        if (j2EEResourcePropertySet != null) {
            EList eList = j2EEResourcePropertySet.getResourceProperties();
            for (int i = 0; i < eList.size(); ++i) {
                J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)eList.get(i);
                if (j2EEResourceProperty == null) continue;
                String string = j2EEResourceProperty.getName();
                String string2 = j2EEResourceProperty.getValue();
                try {
                    string2 = this.expandVariable(string2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.binder.J2CBinder.addConnectorPropertySet", "154", this);
                    Tr.service(tc, "Exception attempting to expand string: " + string2, exception);
                }
                String string3 = j2EEResourceProperty.getType();
                if (string == null || string2 == null || string3 == null) continue;
                ConnectorProperty connectorProperty = new ConnectorProperty(string, string3, string2);
                connectorProperties.add((Object)connectorProperty);
            }
        }
    }

    protected void addJ2EEHrefProperties(Properties properties, J2EEResourceFactory j2EEResourceFactory) {
        MBeanFactory mBeanFactory = null;
        try {
            mBeanFactory = AdminServiceFactory.getAdminService().getMBeanFactory();
            if (mBeanFactory != null) {
                this.setProperty(properties, "j2ee.resource.factory.href", mBeanFactory.getConfigId(j2EEResourceFactory));
                this.setProperty(properties, "j2ee.resource.provider.href", mBeanFactory.getConfigId(j2EEResourceFactory.getProvider()));
                this.setProperty(properties, "providerName", j2EEResourceFactory.getProvider().getName());
                this.setProperty(properties, "description", j2EEResourceFactory.getDescription());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.binder.J2CBinder.addJ2EEHrefPropeties", "276", this);
        }
        this.setProperty(properties, "FactoryJndiName", j2EEResourceFactory.getJndiName());
    }

    public void activateProviderMBean(J2EEResourceProvider j2EEResourceProvider, String string) {
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        return null;
    }

    public String getNamePrefix() {
        return null;
    }

    public boolean isUsedFor(J2EEResourceFactory j2EEResourceFactory) {
        return false;
    }

    private void addPaths(Properties properties, String string, List list, List list2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.expandVariable(string);
        stringBuffer.append(string2);
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                string2 = (String)list.get(n);
                try {
                    string2 = this.expandVariable(string2);
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != File.pathSeparatorChar) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(string2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.runtime.component.binder.J2CBinder.addPaths", "388", this);
                    Tr.warning(tc, "ILLEGAL_ARGUMENT_EXCEPTION_J2CA0080", (Object)new Object[]{"addPaths", illegalArgumentException});
                }
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                string2 = (String)list2.get(n);
                try {
                    string2 = this.expandVariable(string2);
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != File.pathSeparatorChar) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(string2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.runtime.component.binder.J2CBinder.addPaths", "406", this);
                    Tr.warning(tc, "ILLEGAL_ARGUMENT_EXCEPTION_J2CA0080", (Object)new Object[]{"addPaths", illegalArgumentException});
                }
            }
        }
        this.setProperty(properties, "classpath", stringBuffer.toString());
    }

    protected void checkSetProperty(Properties properties, String string, Object object) {
        if (object != null) {
            this.setProperty(properties, string, object);
        }
    }

    protected void addConnectionDefinitionProperties(Properties properties, ConnectionDefinition connectionDefinition) {
        if (connectionDefinition == null) {
            return;
        }
        this.setProperty(properties, "connectionFactoryImplClass", connectionDefinition.getConnectionFactoryImplClass());
        this.setProperty(properties, "connectionFactoryInterface", connectionDefinition.getConnectionFactoryInterface());
        this.setProperty(properties, "connectionImplClass", connectionDefinition.getConnectionImplClass());
        this.setProperty(properties, "connectionInterface", connectionDefinition.getConnectionInterface());
        this.setProperty(properties, "managedConnectionFactoryClass", connectionDefinition.getManagedConnectionFactoryClass());
    }

    protected void checkSetFirstItem(Properties properties, String string, List list) {
        if (list.size() > 0) {
            this.setProperty(properties, string, list.get(0));
        }
    }

    protected boolean checkJCA15(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checkJCA15 version: " + string);
        }
        if (string != null) {
            return string.trim().equals("1.5");
        }
        return false;
    }
}

