/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.pmi.PmiBean;
import com.ibm.websphere.pmi.PmiBeanFactory;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import java.util.HashMap;

public class BeanModule
extends PmiAbstractModule
implements PmiBean {
    private static final long serialVersionUID = -4551321068413271323L;
    private static final TraceComponent tc = Tr.register(BeanModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "beanModule";
    public static final String beanWccmType = "beanModule#";
    public static final String beanMethodWccmType = "beanModule#beanModule.methods";
    private static final int defaultLevel = 0;
    private PmiBeanFactory myfactory = null;
    private static final int TYPE_STATELESS = 1;
    private static final int TYPE_STATEFUL = 2;
    private static final int TYPE_ENTITY = 3;
    private static final int TYPE_MDB = 4;
    private int iType = -1;
    private CountStatisticImpl instantiates = null;
    private CountStatisticImpl destroys = null;
    private CountStatisticImpl loads = null;
    private CountStatisticImpl stores = null;
    private CountStatisticImpl creates = null;
    private CountStatisticImpl removes = null;
    private CountStatisticImpl passivations = null;
    private RangeStatisticImpl passivatedSFSB = null;
    private CountStatisticImpl activations = null;
    private CountStatisticImpl methodCalls = null;
    private TimeStatisticImpl methodRt = null;
    private RangeStatisticImpl methodLoad = null;
    private TimeStatisticImpl createRt = null;
    private TimeStatisticImpl removeRt = null;
    private TimeStatisticImpl loadRt = null;
    private TimeStatisticImpl storeRt = null;
    private TimeStatisticImpl activationRt = null;
    private TimeStatisticImpl passivationRt = null;
    private RangeStatisticImpl actives = null;
    private RangeStatisticImpl lives = null;
    private CountStatisticImpl getsFromPool = null;
    private CountStatisticImpl getsFound = null;
    private CountStatisticImpl returnsToPool = null;
    private CountStatisticImpl returnsDiscarded = null;
    private CountStatisticImpl drainsFromPool = null;
    private AverageStatisticImpl avgDrainSize = null;
    private RangeStatisticImpl poolSize = null;
    private BeanMethodsModule methodsSubmodule = null;
    private String ejbjarName;
    private String beanName;
    protected boolean methodDataEnabled = false;
    private CountStatisticImpl messageCount = null;
    private CountStatisticImpl messageBackoutCount = null;
    private TimeStatisticImpl averageServerSessionWaitTime = null;
    private RangeStatisticImpl serverSessionUsage = null;
    public static final int CREATES = 1;
    public static final int REMOVES = 2;
    public static final int ACTIVATIONS = 3;
    public static final int PASSIVATIONS = 4;
    public static final int INSTANTIATES = 5;
    public static final int DESTROYS = 6;
    public static final int LOADS = 7;
    public static final int STORES = 8;
    public static final int ACTIVES = 9;
    public static final int LIVES = 10;
    public static final int METHOD_CALLS = 11;
    public static final int METHOD_RT = 12;
    public static final int CREATE_RT = 14;
    public static final int REMOVE_RT = 15;
    public static final int METHOD_LOAD = 18;
    public static final int GETS_FROM_POOL = 19;
    public static final int GETS_FOUND = 20;
    public static final int RETURNS_TO_POOL = 21;
    public static final int RETURNS_DISCARDED = 22;
    public static final int DRAINS_FROM_POOL = 23;
    public static final int DRAIN_SIZE = 24;
    public static final int POOL_SIZE = 25;
    public static final int MESSAGE_DELIVERED = 26;
    public static final int MESSAGE_BACKOUT = 27;
    public static final int AVERAGE_SERVER_SESSION_WAIT_TIME = 28;
    public static final int SERVER_SESSION_USAGE = 29;
    public static final int ACTIVATION_TIME = 30;
    public static final int PASSIVATION_TIME = 31;
    public static final int LOAD_TIME = 32;
    public static final int STORE_TIME = 33;
    public static final int PASSIVATION_COUNT = 34;
    public static final int METHODREADY_COUNT = 35;
    public static final int METHODS = 50;
    public static final int CALLS_PER_METHOD = 51;
    public static final int RT_PER_METHOD = 52;
    public static final int LOAD_PER_METHOD = 53;

    public String getWCCMStatsType() {
        if (this.categoryName != null) {
            return beanWccmType + this.categoryName;
        }
        return beanWccmType;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.creates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 2: {
                this.removes = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 3: {
                this.activations = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 4: {
                this.passivations = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 5: {
                this.instantiates = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 6: {
                this.destroys = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 7: {
                this.loads = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 8: {
                this.stores = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 11: {
                this.methodCalls = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 19: {
                this.getsFromPool = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 20: {
                this.getsFound = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 21: {
                this.returnsToPool = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 22: {
                this.returnsDiscarded = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 23: {
                this.drainsFromPool = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 26: {
                this.messageCount = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
            case 27: {
                this.messageBackoutCount = (CountStatisticImpl)spdLong.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat spdStat) {
        switch (spdStat.getId()) {
            case 12: {
                this.methodRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 14: {
                this.createRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 15: {
                this.removeRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 32: {
                this.loadRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 33: {
                this.storeRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 30: {
                this.activationRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 31: {
                this.passivationRt = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 24: {
                this.avgDrainSize = (AverageStatisticImpl)spdStat.getStatistic();
                return true;
            }
            case 28: {
                this.averageServerSessionWaitTime = (TimeStatisticImpl)spdStat.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        switch (spdLoad.getId()) {
            case 9: {
                this.actives = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 10: {
                this.lives = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 18: {
                this.methodLoad = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 25: {
                this.poolSize = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 29: {
                this.serverSessionUsage = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 34: {
                this.passivatedSFSB = (RangeStatisticImpl)spdLoad.getStatistic();
                return true;
            }
            case 35: {
                if (this.iType == 1) {
                    this.poolSize = (RangeStatisticImpl)spdLoad.getStatistic();
                    return true;
                }
                if (this.iType == 2) {
                    this.actives = (RangeStatisticImpl)spdLoad.getStatistic();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public BeanModule(String string, String string2, String string3, EJBComponentMetaData eJBComponentMetaData) {
        super(moduleID, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BeanModule " + string2);
        }
        this.ejbjarName = string;
        this.beanName = string2;
        this.categoryName = string3;
        if (this.categoryName != null) {
            PmiRegistry.jmxMapper.setBeanMapping(string2, this.categoryName);
            this.iType = this.categoryName.equals("ejb.stateless") ? 1 : (this.categoryName.equals("ejb.stateful") ? 2 : (this.categoryName.equals("ejb.entity") ? 3 : (this.categoryName.equals("ejb.messageDriven") ? 4 : -1)));
        }
        this.registerModule((PmiModule)this);
        this.methodsSubmodule = new BeanMethodsModule(string2, this.categoryName);
    }

    public String[] getPath() {
        return new String[]{moduleID, this.ejbjarName, this.categoryName, this.beanName};
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public final void beanCreated() {
        if (this.actives != null) {
            this.actives.increment();
        }
        if (this.creates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanCreated");
            }
            this.creates.increment();
        }
    }

    public final void beanRemoved() {
        if (this.actives != null) {
            this.actives.decrement();
        }
        if (this.removes != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanRemoved");
            }
            this.removes.increment();
        }
    }

    public final void beanInstantiated() {
        if (this.lives != null) {
            this.lives.increment();
        }
        if (this.iType == 1 && this.creates != null) {
            this.creates.increment();
        }
        if (this.instantiates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanInstantiated");
            }
            this.instantiates.increment();
        }
    }

    public final void beanDestroyed() {
        if (this.lives != null) {
            this.lives.decrement();
        }
        if (this.iType == 1 && this.removes != null) {
            this.removes.increment();
        }
        if (this.destroys != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beanDestroyed");
            }
            this.destroys.increment();
        }
    }

    public final long activationTime() {
        if (this.activationRt == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activationTime");
        }
        return System.currentTimeMillis();
    }

    public final void activationTime(long l) {
        if (this.actives != null) {
            this.actives.increment();
        }
        if (this.activations != null) {
            this.activations.increment();
        }
        if (this.iType == 2 && this.passivatedSFSB != null) {
            this.passivatedSFSB.decrement();
        }
        if (this.activationRt != null && l > 0L) {
            long l2 = System.currentTimeMillis() - l;
            this.activationRt.add(l2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activationTime(long), time=" + l2);
            }
        }
    }

    public final long passivationTime() {
        if (this.passivationRt != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "passivationTime");
            }
            return System.currentTimeMillis();
        }
        return -1L;
    }

    public final void passivationTime(long l) {
        if (this.actives != null) {
            this.actives.decrement();
        }
        if (this.iType == 3) {
            if (this.passivations != null) {
                this.passivations.increment();
            }
        } else if (this.iType == 2 && this.passivatedSFSB != null) {
            this.passivatedSFSB.increment();
        }
        if (this.passivationRt != null && l > 0L) {
            long l2 = System.currentTimeMillis() - l;
            this.passivationRt.add(l2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "passivationTime(long), time=" + l2);
            }
        }
    }

    public final long loadTime() {
        if (this.loadRt == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadTime");
        }
        return System.currentTimeMillis();
    }

    public final void loadTime(long l) {
        if (this.loads != null) {
            this.loads.increment();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadTime(long)");
        }
        if (this.loadRt != null && l > 0L) {
            this.loadRt.add(System.currentTimeMillis() - l);
        }
    }

    public final long storeTime() {
        if (this.storeRt == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "storeTime");
        }
        return System.currentTimeMillis();
    }

    public final void storeTime(long l) {
        if (this.stores != null) {
            this.stores.increment();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "storeTime(long)");
        }
        if (this.storeRt != null && l > 0L) {
            this.storeRt.add(System.currentTimeMillis() - l);
        }
    }

    public final long methodPreInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo) {
        if (this.methodLoad != null) {
            this.methodLoad.increment();
        }
        if (this.methodCalls != null) {
            this.methodCalls.increment();
        }
        if (this.methodDataEnabled) {
            String string = null;
            if (eJBMethodInfo == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "methodPreInvoke - exception to get mothod name");
                }
                return -1L;
            }
            string = eJBMethodInfo.getMethodName();
            this.methodsSubmodule.preInvoke(string);
        }
        return System.currentTimeMillis();
    }

    public final void methodPostInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, long l) {
        if (eJBKey == null && eJBMethodInfo == null && l == 0L) {
            if (this.actives != null) {
                this.actives.decrement();
            }
            return;
        }
        if (l <= 0L) {
            return;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (this.methodRt != null) {
            this.methodRt.add(l2, l3);
        }
        if (this.methodLoad != null) {
            this.methodLoad.decrement(l2, 1L);
        }
        String string = eJBMethodInfo.getMethodName();
        if (this.methodDataEnabled) {
            this.methodsSubmodule.postInvoke(string, l);
        }
        if (string.equals("create")) {
            if (this.createRt != null) {
                this.createRt.add(l2, l3);
            }
        } else if (string.equals("remove") && this.removeRt != null) {
            this.removeRt.add(l2, l3);
        }
    }

    public final void objectRetrieve(int n, boolean bl) {
        if (this.getsFromPool != null) {
            this.getsFromPool.increment();
        }
        if (bl) {
            if (this.getsFound != null) {
                this.getsFound.increment();
            }
            if (this.poolSize != null) {
                this.poolSize.set((long)n);
            }
        }
    }

    public final void objectReturn(int n, boolean bl) {
        if (!bl) {
            if (this.poolSize != null) {
                this.poolSize.set((long)n);
            }
        } else if (this.returnsDiscarded != null) {
            this.returnsDiscarded.increment();
        }
        if (this.returnsToPool != null) {
            this.returnsToPool.increment();
        }
    }

    public void poolCreated(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "poolCreated");
        }
        if (this.poolSize != null) {
            this.poolSize.set((long)n);
        }
    }

    public final void poolDrained(int n, int n2) {
        if (this.poolSize != null && n2 > 0) {
            this.poolSize.set((long)n);
        }
        if (this.drainsFromPool != null) {
            this.drainsFromPool.increment();
        }
        if (this.avgDrainSize != null) {
            this.avgDrainSize.add((long)n2);
        }
    }

    public void setFactory(PmiBeanFactory pmiBeanFactory) {
        this.myfactory = pmiBeanFactory;
    }

    public void unregister() {
        super.unregister();
        this.methodsSubmodule.clear();
    }

    public void destroy() {
        if (this.myfactory != null) {
            this.myfactory.removePmiModule(this);
        } else {
            this.unregister();
        }
    }

    public void messageDelivered() {
        if (this.messageCount != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageDelivered");
            }
            this.messageCount.increment();
        }
    }

    public void messageBackedOut() {
        if (this.messageBackoutCount != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageBackedOut");
            }
            this.messageBackoutCount.increment();
        }
    }

    public long waitingForServerSession() {
        if (this.averageServerSessionWaitTime == null) {
            return -1L;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "waitingForServerSession");
        }
        return System.currentTimeMillis();
    }

    public void gotServerSession(long l) {
        if (this.averageServerSessionWaitTime == null || l <= 0L) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "gotServerSession");
        }
        long l2 = System.currentTimeMillis();
        this.averageServerSessionWaitTime.add(l2 - l);
    }

    public void serverSessionRetrieve(int n, int n2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverSessionRetrieve(" + n + "," + n2 + ")");
        }
        if (this.serverSessionUsage != null) {
            int n3 = n * 100 / n2;
            this.serverSessionUsage.set((long)n3);
        }
    }

    public void serverSessionReturn(int n, int n2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverSessionReturn(" + n + "," + n2 + ")");
        }
        if (this.serverSessionUsage != null) {
            int n3 = n * 100 / n2;
            this.serverSessionUsage.set((long)n3);
        }
    }

    protected void initializeMe(int n) {
        if (this.currentLevel >= 7 || n < 7) {
            return;
        }
        long l = 0L;
        if (this.actives != null) {
            l = this.actives.getCurrent();
        }
        if (l < 0L) {
            this.actives.setLastValue(0L);
        }
        l = 0L;
        if (this.lives != null) {
            l = this.lives.getCurrent();
        }
        if (l < 0L) {
            this.lives.setLastValue(0L);
        }
    }

    protected int[] filterMethodCounters(int[] nArray) {
        int n;
        int n2;
        int n3;
        if (nArray == null) {
            return new int[0];
        }
        int[] nArray2 = new int[]{-1, -1, -1};
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] == 51) {
                nArray2[0] = 51;
                continue;
            }
            if (nArray[n3] == 52) {
                nArray2[1] = 52;
                continue;
            }
            if (nArray[n3] != 53) continue;
            nArray2[2] = 53;
        }
        n3 = 0;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            if (nArray2[n2] == -1) continue;
            ++n3;
        }
        if (n3 == 0) {
            return new int[0];
        }
        n2 = 0;
        int[] nArray3 = new int[n3];
        for (n = 0; n < nArray2.length; ++n) {
            if (nArray2[n] == -1) continue;
            nArray3[n2++] = nArray2[n];
        }
        for (n = 0; n < nArray3.length; ++n) {
        }
        return nArray3;
    }

    class PerMethodModule
    extends PmiAbstractModule {
        private static final long serialVersionUID = 1130973806467009193L;
        CountStatisticImpl perMethodCalls;
        TimeStatisticImpl perMethodRt;
        RangeStatisticImpl perMethodLoad;
        int defaultLevel;

        public PerMethodModule(String string, String string2, String string3) {
            super(BeanModule.moduleID, string);
            this.perMethodCalls = null;
            this.perMethodRt = null;
            this.perMethodLoad = null;
            this.defaultLevel = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new PerMethodModule");
            }
            this.submoduleName = "beanModule.methods";
            this.subinstanceName = string3;
            this.categoryName = string2;
            this.type = 16;
            this.bStandaloneTree = true;
            this.registerModule((PmiModule)this);
        }

        protected boolean longCreated(SpdLong spdLong) {
            switch (spdLong.getId()) {
                case 51: {
                    this.perMethodCalls = (CountStatisticImpl)spdLong.getStatistic();
                    return true;
                }
            }
            return false;
        }

        protected boolean statCreated(SpdStat spdStat) {
            switch (spdStat.getId()) {
                case 52: {
                    this.perMethodRt = (TimeStatisticImpl)spdStat.getStatistic();
                    return true;
                }
            }
            return false;
        }

        protected boolean loadCreated(SpdLoad spdLoad) {
            switch (spdLoad.getId()) {
                case 53: {
                    this.perMethodLoad = (RangeStatisticImpl)spdLoad.getStatistic();
                    return true;
                }
            }
            return false;
        }

        public String[] getPath() {
            return new String[]{BeanModule.moduleID, BeanModule.this.ejbjarName, this.categoryName, BeanModule.this.beanName, this.submoduleName, this.subinstanceName};
        }

        public String getModuleID() {
            return BeanModule.moduleID;
        }

        public int getDefaultLevel() {
            return this.defaultLevel;
        }

        public String getWCCMStatsType() {
            return BeanModule.beanMethodWccmType;
        }

        public StatDescriptor getStatDescriptor() {
            String[] stringArray = new String[]{this.submoduleName, this.subinstanceName};
            return new StatDescriptor(stringArray);
        }

        public synchronized boolean setFineGrainedInstrumentation(int[] nArray, int[] nArray2) {
            return super.setFineGrainedInstrumentation(BeanModule.this.filterMethodCounters(nArray), BeanModule.this.filterMethodCounters(nArray2));
        }
    }

    class BeanMethodsModule
    extends ModuleAggregate {
        private static final long serialVersionUID = 5988712569185928707L;
        private HashMap methodSubinstances;
        public static final int enableLevel = 15;
        private int defaultLevel;

        public BeanMethodsModule(String string, String string2) {
            super(BeanModule.moduleID, false);
            this.methodSubinstances = new HashMap();
            this.defaultLevel = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BeanMethodsModule " + string + ", beanType=" + string2);
            }
            this.type = 15;
            this.instanceName = string;
            this.categoryName = string2;
            this.submoduleName = "beanModule.methods";
            super.registerModule((PmiModule)this);
        }

        public String[] getPath() {
            return new String[]{BeanModule.moduleID, BeanModule.this.ejbjarName, this.categoryName, BeanModule.this.beanName, this.submoduleName};
        }

        public String getModuleID() {
            return BeanModule.moduleID;
        }

        public int getDefaultLevel() {
            return this.defaultLevel;
        }

        public synchronized boolean setFineGrainedInstrumentation(int[] nArray, int[] nArray2) {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != 51 && nArray[n] != 52 && nArray[n] != 53) continue;
                BeanModule.this.methodDataEnabled = true;
                break;
            }
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] != 51 && nArray2[n] != 52 && nArray2[n] != 53) continue;
                BeanModule.this.methodDataEnabled = true;
                break;
            }
            return super.setFineGrainedInstrumentation(nArray, nArray2);
        }

        public synchronized void setInstrumentationLevel(int n) {
            super.setInstrumentationLevel(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setInstrumentationLevel");
            }
            if (this.moduleConfig == null) {
                Tr.warning(tc, "PMI0007W", BeanModule.moduleID);
                return;
            }
            if (n == -1) {
                return;
            }
            BeanModule.this.methodDataEnabled = n == 15;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preInvoke(String string) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BeanMethodsModule.preInvoke for method: " + string);
            }
            PerMethodModule perMethodModule = null;
            HashMap hashMap = this.methodSubinstances;
            synchronized (hashMap) {
                perMethodModule = (PerMethodModule)((Object)this.methodSubinstances.get(string));
                if (perMethodModule == null) {
                    perMethodModule = new PerMethodModule(this.instanceName, this.categoryName, string);
                    if (perMethodModule == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "BeanMethodsModule.preInvoke - error creating per method submodule");
                        }
                        return;
                    }
                    this.methodSubinstances.put(string, perMethodModule);
                }
            }
            if (perMethodModule.perMethodCalls != null) {
                perMethodModule.perMethodCalls.increment();
            }
            if (perMethodModule.perMethodLoad != null) {
                perMethodModule.perMethodLoad.increment();
            }
        }

        public void postInvoke(String string, long l) {
            PerMethodModule perMethodModule = (PerMethodModule)((Object)this.methodSubinstances.get(string));
            if (perMethodModule == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "BeanMethodsModule.postInvoke - no per method submodule found");
                }
                return;
            }
            if (perMethodModule.perMethodLoad != null) {
                perMethodModule.perMethodLoad.decrement();
            }
            if (perMethodModule.perMethodRt != null) {
                long l2 = System.currentTimeMillis();
                perMethodModule.perMethodRt.add(l2 - l);
            }
        }

        public void clear() {
            this.methodSubinstances.clear();
        }

        public void removeMethodInstance(String string) {
            this.methodSubinstances.remove(string);
        }

        public void destroy() {
        }

        public String getWCCMStatsType() {
            return BeanModule.beanMethodWccmType;
        }
    }
}

