/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orbimpl.transport.WSHTTPTransportConnection;
import com.ibm.ws.orbimpl.transport.content.IIOPContentHandlerFactory;
import com.ibm.ws.orbimpl.transport.protocol.HttpsURLStreamHandlerFactory;
import com.ibm.ws.orbimpl.transport.protocol.https.Handler;
import com.ibm.ws.orbimpl.transport.protocol.https.HttpsURLConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;

class HTTPOutputStream
extends OutputStream {
    WSHTTPTransportConnection transportConnection = null;
    private static boolean needFactories = true;
    private URL url = null;
    private Profile profile = null;
    private boolean isRunningInApplet;
    private ORB orb = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    public static final int TAG_FIREWALL_TRAVERSAL = 1229081859;
    private static boolean httpsProtocol = false;
    URLConnection urlc;
    private ByteArrayOutputStream buffer;
    private int bytesRemaining = -1;
    public static final int GIOP_MSG_HEADER_LENGTH = 12;

    public HTTPOutputStream(WSHTTPTransportConnection wSHTTPTransportConnection, Profile profile, ORB oRB) {
        this.transportConnection = wSHTTPTransportConnection;
        this.profile = profile;
        this.orb = oRB;
        this.isRunningInApplet = oRB.isRunningInApplet();
        this.buffer = new ByteArrayOutputStream();
    }

    public void close() throws IOException {
        if (this.outputStream == null) {
            throw new INTERNAL("HTTPOUTPUTSTREAM_NO_OUTPUTSTREAM", 1229066330, CompletionStatus.COMPLETED_MAYBE);
        }
        this.outputStream.close();
    }

    public void flush() throws IOException {
        if (this.outputStream == null) {
            throw new INTERNAL("HTTPOUTPUTSTREAM_NO_OUTPUTSTREAM", 1229066330, CompletionStatus.COMPLETED_MAYBE);
        }
        this.outputStream.flush();
    }

    private void setUpURL() throws IOException {
        if (this.url == null) {
            Object object;
            int n;
            String string = null;
            byte[] byArray = this.profile.getTaggedComponent(1229081859);
            string = byArray != null ? new String(byArray) : this.transportConnection.getTunnelAgentURLString();
            if (string == null || string.equals("")) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setUpURL", "tunnelAgentURLSring is null or empty, throwing COMM_FAILURE");
                }
                throw new COMM_FAILURE("WRITE_ERROR_SEND_1", 1229066320, CompletionStatus.COMPLETED_NO);
            }
            String string2 = null;
            string2 = string.indexOf("?") == -1 ? string + "?host=" + this.profile.getHost() + "&port=" + this.profile.getPort() : string + "&host=" + this.profile.getHost() + "&port=" + this.profile.getPort();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setUpURL", "ursStr=" + string2);
            }
            if (needFactories && !this.isRunningInApplet && (n = string2.indexOf(":")) != -1 && ((String)(object = string2.substring(0, n))).equalsIgnoreCase("https")) {
                URLConnection.setContentHandlerFactory(new IIOPContentHandlerFactory());
                httpsProtocol = true;
                needFactories = false;
            }
            if (httpsProtocol) {
                String string3 = System.getProperty("java.protocol.handler.pkgs");
                if (string3 == null | string3 == "") {
                    string3 = "com.ibm.ws.orbimpl.transport.protocol.https.Handler";
                } else if (!string3.equalsIgnoreCase("com.ibm.ws.orbimpl.transport.protocol.https.Handler")) {
                    string3 = "com.ibm.ws.orbimpl.transport.protocol.https.Handler | " + string3;
                }
                System.setProperty("java.protocol.handler.pkgs", string3);
                object = new HttpsURLStreamHandlerFactory();
                Handler handler2 = (Handler)((HttpsURLStreamHandlerFactory)object).createURLStreamHandler("https");
                this.url = new URL(null, string2, handler2);
            } else if (!httpsProtocol) {
                this.url = new URL(string2);
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "setUpURL", "url=" + this.url);
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "write( byte[] b, int off, int len)", "at the beginning of the method");
        }
        if (!this.buildMessage(byArray, n, n2)) {
            return;
        }
        this.setUpURL();
        this.urlc = this.url.openConnection();
        this.urlc.setDoOutput(true);
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            this.urlc.setUseCaches(false);
            if (!this.isRunningInApplet) {
                ((HttpsURLConnection)this.urlc).setOrb(this.orb);
                String string = this.url.getFile();
                String string2 = "POST " + string + " HTTP/1.1";
                this.outputStream = this.urlc.getOutputStream();
                PrintStream printStream = new PrintStream(this.outputStream);
                printStream.println(string2);
                printStream.println("host: " + this.profile.getHost());
                printStream.println("Content-Length: " + this.buffer.size());
                printStream.println("");
                printStream.flush();
                this.outputStream.write(this.buffer.toByteArray(), 0, this.buffer.size());
                this.resetBuffer();
                this.outputStream.flush();
                printStream.println("");
                printStream.flush();
                this.inputStream = (InputStream)this.urlc.getContent();
                this.transportConnection.setInputStream(this.inputStream);
                this.transportConnection.readAndProcessReply();
            } else {
                this.outputStream = this.urlc.getOutputStream();
                this.outputStream.write(this.buffer.toByteArray(), 0, this.buffer.size());
                this.resetBuffer();
                this.inputStream = this.urlc.getInputStream();
                this.transportConnection.setInputStream(this.inputStream);
                this.transportConnection.readAndProcessReply();
            }
        } else {
            this.outputStream = this.urlc.getOutputStream();
            this.outputStream.write(this.buffer.toByteArray(), 0, this.buffer.size());
            this.resetBuffer();
            this.inputStream = this.urlc.getInputStream();
            this.transportConnection.setInputStream(this.inputStream);
            this.transportConnection.readAndProcessReply();
        }
    }

    private boolean buildMessage(byte[] byArray, int n, int n2) {
        String string = "buildMessage";
        if (this.bytesRemaining == -1) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            byteBuffer.position(8);
            this.bytesRemaining = byteBuffer.getInt();
        }
        this.buffer.write(byArray, n, n2);
        this.bytesRemaining -= n2;
        return 0 == this.bytesRemaining + 12;
    }

    private void resetBuffer() {
        this.buffer.reset();
        this.bytesRemaining = -1;
    }

    public void disconnect() {
        try {
            this.inputStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.orbimpl.transport.HTTPOutputStream.disconnect", "365", this);
        }
        if (this.url.getProtocol().equalsIgnoreCase("https") && !this.isRunningInApplet) {
            try {
                ((HttpsURLConnection)this.urlc).disconnect();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.orbimpl.transport.HTTPOutputStream.disconnect", "374", this);
            }
        }
    }

    public void write(int n) throws IOException {
        throw new NO_IMPLEMENT("HTTPOUTPUTSTREAM_WRITE", 1229066320, CompletionStatus.COMPLETED_MAYBE);
    }
}

