/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericMessageImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.cookies.impl.CookieCacheData;
import com.ibm.ws.http.channel.cookies.impl.CookieHeaderByteParser;
import com.ibm.ws.http.channel.cookies.impl.CookieUtils;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.impl.HttpTrailersImpl;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.matcher.impl.ConnectionMatcher;
import com.ibm.ws.http.channel.matcher.impl.ContentEncodingMatcher;
import com.ibm.ws.http.channel.matcher.impl.ExpectMatcher;
import com.ibm.ws.http.channel.matcher.impl.HttpHeaderMatcher;
import com.ibm.ws.http.channel.matcher.impl.TransferEncodingMatcher;
import com.ibm.ws.http.channel.matcher.impl.VersionMatcher;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.ExpectValues;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;

public abstract class HttpBaseMessageImpl
extends GenericMessageImpl
implements HttpBaseMessage {
    private static final TraceComponent tc = Tr.register(HttpBaseMessageImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = -5538352173755638799L;
    private static final String HDR_LIST_SEPARATOR = ", ";
    private static final int GROWTH_SIZE = 2;
    private static final int DEFAULT_SIZE = 5;
    private static final byte QUOTE = 34;
    private static Charset DEF_CHARSET = null;
    private static final String DEFAULT_MIMETYPE = "text/html";
    private static final byte[] COOKIE_DELIMS = new byte[]{44, 59};
    private transient int myAge = -1;
    private transient int myContentLength = -1;
    private transient int myMaxForwards = -1;
    private transient ConnectionValues[] myConnectionVals = null;
    private transient int indexConnection = 0;
    private transient TransferEncodingValues[] myTransferVals = null;
    private transient int indexTransfer = 0;
    private transient ContentEncodingValues[] myContentEncodingVals = null;
    private transient int indexContentEncoding = 0;
    private transient boolean bIsIncoming = false;
    private transient boolean bIsKeepAliveSet = true;
    private transient boolean bIsCloseSet = false;
    private transient boolean bIsChunkedEncodingSet = false;
    private transient boolean bIs100Continue = false;
    private transient boolean bIsCommitted = false;
    private HttpTrailersImpl myTrailers = null;
    private VersionValues myVersion = HttpConstants.HTTP_VERSION_11;
    private transient HttpServiceContextImpl myHSC = null;
    private transient CookieCacheData cookieCache = null;
    private transient CookieCacheData cookie2Cache = null;
    private transient CookieCacheData setCookieCache = null;
    private transient CookieCacheData setCookie2Cache = null;
    private transient CookieHeaderByteParser cookieParser;

    protected HttpBaseMessageImpl() {
        super(HttpHeaderMatcher.getRef(), HttpConstants.NUM_HDRS);
        this.myConnectionVals = new ConnectionValues[5];
        this.myTransferVals = new TransferEncodingValues[5];
        this.myContentEncodingVals = new ContentEncodingValues[5];
        this.cookieParser = new CookieHeaderByteParser();
    }

    protected void init(HttpServiceContext httpServiceContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing message: " + this + " with " + httpServiceContext);
        }
        if (null == httpServiceContext) {
            return;
        }
        this.myHSC = (HttpServiceContextImpl)httpServiceContext;
        HttpChannelConfig httpChannelConfig = this.myHSC.getHttpConfig();
        super.init(httpChannelConfig.isDirectBufferType(), httpChannelConfig.getOutgoingHdrBufferSize(), httpChannelConfig.getIncomingHdrBufferSize(), httpChannelConfig.getByteCacheSize());
        this.setLimitOfTokenSize(httpChannelConfig.getLimitOfFieldSize());
        this.setLimitOnNumberOfHeaders(httpChannelConfig.getLimitOnNumberOfHeaders());
    }

    public void clear() {
        super.clear();
        this.myVersion = HttpConstants.HTTP_VERSION_11;
        this.cookieCache = null;
        this.cookie2Cache = null;
        this.setCookieCache = null;
        this.setCookie2Cache = null;
        this.bIsCommitted = false;
        this.bIsKeepAliveSet = true;
        this.bIsCloseSet = false;
        this.setBinaryParseState(14);
        if (null != this.myTrailers) {
            this.myTrailers.destroy();
            this.myTrailers = null;
        }
    }

    public void destroy() {
        super.destroy();
        HttpChannelConfig httpChannelConfig = this.myHSC.getHttpConfig();
        if (null != httpChannelConfig && httpChannelConfig.isServantRegion()) {
            this.myHSC.getVC().getStateMap().remove("SessionPersistence");
        }
        this.myHSC = null;
        this.bIsIncoming = false;
        if (null != this.myTrailers) {
            this.myTrailers.destroy();
            this.myTrailers = null;
        }
    }

    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Version: " + this.getVersion());
            Tr.debug(tc, "Age: " + this.getAge());
            Tr.debug(tc, "MaxForwards: " + this.getMaxForwards());
            Tr.debug(tc, "ContentLength: " + this.getContentLength());
            Tr.debug(tc, "CookieCache:  " + this.getCookieCache(HttpConstants.HDR_COOKIE));
            Tr.debug(tc, "Cookie2Cache:  " + this.getCookieCache(HttpConstants.HDR_COOKIE2));
            Tr.debug(tc, "SetCookieCache:  " + this.getCookieCache(HttpConstants.HDR_SET_COOKIE));
            Tr.debug(tc, "Set2CookieCache:  " + this.getCookieCache(HttpConstants.HDR_SET_COOKIE2));
            Tr.debug(tc, "isIncoming: " + this.isIncoming());
            Tr.debug(tc, "isKeepAliveSet: " + this.isKeepAliveSet());
            Tr.debug(tc, "isCloseSet: " + this.isCloseSet());
            Tr.debug(tc, "isConnectionSet: " + this.isConnectionSet());
            Tr.debug(tc, "isChunkedEncodingSet: " + this.isChunkedEncodingSet());
            Tr.debug(tc, "isExpect100: " + this.isExpect100Continue());
            Tr.debug(tc, "isBodyAllowed: " + this.isBodyAllowed());
            Tr.debug(tc, "isBodyExcepted: " + this.isBodyExpected());
            Tr.debug(tc, "isBodyEncoded: " + this.isBodyEncoded());
            Tr.debug(tc, "Trailers: " + this.getTrailersImpl());
            if (null != this.getTrailersImpl()) {
                this.getTrailersImpl().debug();
            }
            super.debug();
        }
    }

    private void duplicateCookieCaches(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (null != this.cookieCache) {
            httpBaseMessageImpl.cookieCache = this.cookieCache.duplicate();
        }
        if (null != this.cookie2Cache) {
            httpBaseMessageImpl.cookie2Cache = this.cookie2Cache.duplicate();
        }
        if (null != this.setCookieCache) {
            httpBaseMessageImpl.setCookieCache = this.setCookieCache.duplicate();
        }
        if (null != this.setCookie2Cache) {
            httpBaseMessageImpl.setCookie2Cache = this.setCookie2Cache.duplicate();
        }
    }

    public void removeAllHeaders() {
        this.cookieCache = null;
        this.cookie2Cache = null;
        this.setCookieCache = null;
        this.setCookie2Cache = null;
        super.removeAllHeaders();
    }

    protected void duplicate(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (null == httpBaseMessageImpl) {
            throw new NullPointerException("Null message");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the base message");
        }
        super.duplicate(httpBaseMessageImpl);
        httpBaseMessageImpl.setVersion(this.getVersionValue());
        if (null != this.getTrailersImpl()) {
            httpBaseMessageImpl.myTrailers = this.getTrailersImpl().duplicate();
        }
        this.duplicateCookieCaches(httpBaseMessageImpl);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl;
        super.setHeaderMatcher(HttpHeaderMatcher.getRef());
        super.readExternal(objectInput);
        try {
            if (-1091633150 == this.getDeserializationVersion()) {
                this.setVersion(this.readByteArray(objectInput));
            } else {
                this.setVersion((String)objectInput.readObject());
            }
        }
        catch (UnsupportedProtocolVersionException unsupportedProtocolVersionException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown HTTP version");
            }
            IOException iOException = new IOException("Failed deserialization of version");
            iOException.initCause(unsupportedProtocolVersionException);
            throw iOException;
        }
        boolean bl2 = -1091633150 == this.getDeserializationVersion() ? objectInput.readBoolean() : (bl = 1 == objectInput.readByte());
        if (bl) {
            this.myTrailers = (HttpTrailersImpl)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.marshallCookieCache(this.cookieCache);
        this.marshallCookieCache(this.cookie2Cache);
        this.marshallCookieCache(this.setCookieCache);
        this.marshallCookieCache(this.setCookie2Cache);
        ObjectOutputStream objectOutputStream = null;
        if (objectOutput instanceof ObjectOutputStream) {
            objectOutputStream = (ObjectOutputStream)objectOutput;
        }
        super.writeExternal(objectOutput);
        if (null != objectOutputStream) {
            objectOutputStream.writeUnshared(this.getVersion());
        } else {
            objectOutput.writeObject(this.getVersion());
        }
        if (null != this.myTrailers) {
            objectOutput.writeByte(1);
            if (null != objectOutputStream) {
                objectOutputStream.writeUnshared(this.myTrailers);
            } else {
                objectOutput.writeObject(this.myTrailers);
            }
        } else {
            objectOutput.writeByte(0);
        }
    }

    public final boolean isIncoming() {
        return this.bIsIncoming;
    }

    public final void setIncoming(boolean bl) {
        this.bIsIncoming = bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Incoming flag now " + bl + " on " + this);
        }
    }

    public final boolean isCommitted() {
        return this.bIsCommitted;
    }

    public final void setCommitted() {
        this.bIsCommitted = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Committed flag set on " + this);
        }
    }

    protected final void setCommitted(boolean bl) {
        this.bIsCommitted = bl;
    }

    public boolean isBodyExpected() {
        if (this.isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg says chunked encoding: " + this);
            }
            return true;
        }
        if (0 < this.getContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg says content-length: " + this.getContentLength() + " " + this);
            }
            return true;
        }
        if (this.isBodyEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg contains Content-Encoding header");
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "No body expected at base layer: " + this);
        }
        return false;
    }

    public boolean isBodyAllowed() {
        return 0 != this.getContentLength();
    }

    public boolean shouldUpdateBodyHeaders() {
        return true;
    }

    protected void setMyHSC(HttpServiceContextImpl httpServiceContextImpl) {
        this.myHSC = httpServiceContextImpl;
    }

    public final HttpServiceContextImpl getServiceContext() {
        return this.myHSC;
    }

    public HttpOutboundServiceContext getOutboundSC() {
        return (HttpOutboundServiceContext)((Object)this.myHSC);
    }

    public HttpInboundServiceContext getInboundSC() {
        return (HttpInboundServiceContext)((Object)this.myHSC);
    }

    public HttpOutboundServiceContextImpl getOutboundSCImpl() {
        return (HttpOutboundServiceContextImpl)this.myHSC;
    }

    public HttpInboundServiceContextImpl getInboundSCImpl() {
        return (HttpInboundServiceContextImpl)this.myHSC;
    }

    protected final HttpObjectFactory getObjectFactory() {
        if (null == this.getServiceContext()) {
            return null;
        }
        return this.getServiceContext().getObjectFactory();
    }

    public final HttpTrailersImpl getTrailersImpl() {
        return this.myTrailers;
    }

    public HttpTrailersImpl createTrailers() {
        if (null == this.myTrailers) {
            this.myTrailers = null == this.getObjectFactory() ? new HttpTrailersImpl() : this.getObjectFactory().getTrailers();
            this.myTrailers.init(this.shouldAllocateDirectBuffer(), this.getOutgoingBufferSize(), this.getIncomingBufferSize(), this.getByteCacheSize());
        }
        return this.myTrailers;
    }

    public HttpTrailers getTrailers() {
        if (null == this.getTrailersImpl() && this.containsHeader(HttpConstants.HDR_TRAILER)) {
            this.createTrailers();
        }
        return this.getTrailersImpl();
    }

    public final VersionValues getVersionValue() {
        return this.myVersion;
    }

    public final String getVersion() {
        return null != this.myVersion ? this.myVersion.getName() : null;
    }

    public void setVersion(VersionValues versionValues) {
        if (!versionValues.equals(this.myVersion)) {
            this.myVersion = versionValues;
            super.setFirstLineChanged();
            if (!this.isConnectionSet() && this.getVersionValue().equals(HttpConstants.HTTP_VERSION_10)) {
                this.bIsKeepAliveSet = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setVersion(v): set version to " + this.getVersion());
        }
    }

    public void setVersion(String string) throws UnsupportedProtocolVersionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called setVersion(S): " + string);
        }
        if (null == string) {
            throw new NullPointerException("Version");
        }
        VersionValues versionValues = VersionMatcher.getRef().matchVersion(string);
        if (null == versionValues) {
            try {
                versionValues = VersionValues.makeUndefinedValue(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedProtocolVersionException("Unsupported: " + string);
            }
        }
        this.setVersion(versionValues);
    }

    public void setVersion(byte[] byArray) throws UnsupportedProtocolVersionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called setVersion(b): " + HttpChannelUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            throw new NullPointerException("Version");
        }
        VersionValues versionValues = VersionMatcher.getRef().matchVersion(byArray);
        if (null == versionValues) {
            try {
                versionValues = VersionValues.makeUndefinedValue(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedProtocolVersionException("Unsupported: " + GenericUtils.getEnglishString(byArray));
            }
        }
        this.setVersion(versionValues);
    }

    public void setCurrentDate() {
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_DATE, HttpDateFormat.getRef().getRFC1123TimeAsBytes(this.getServiceContext().getHttpConfig().getDateHeaderRange()));
    }

    public final void setAge(int n) {
        if (0 > n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Age input [" + n + "]");
            }
            return;
        }
        this.myAge = n;
        if (-1 != n) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_AGE, GenericUtils.asByteArray(n));
        } else {
            this.removeSpecialHeader(HttpConstants.HDR_AGE);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setAge(i) set to " + n);
        }
    }

    public final boolean setAge(byte[] byArray, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setAge(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.myAge = -1;
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_AGE);
            }
            return true;
        }
        try {
            int n = GenericUtils.asIntValue(byArray);
            if (0 > n) {
                return false;
            }
            if (this.myAge == n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Age already " + n);
                }
                return true;
            }
            this.myAge = n;
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_AGE, byArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Format exception in value");
            }
            return false;
        }
        return true;
    }

    public final int getAge() {
        return this.myAge;
    }

    public final void setContentLength(int n) {
        if (0 > n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Content-Length input [" + n + "]");
            }
            return;
        }
        if (this.getContentLength() == n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ContentLength already set to " + n);
            }
            return;
        }
        this.myContentLength = n;
        if (-1 != n) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_LENGTH, GenericUtils.asByteArray(n));
        } else {
            this.removeSpecialHeader(HttpConstants.HDR_CONTENT_LENGTH);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ContentLength set to " + n);
        }
    }

    public final boolean setContentLength(byte[] byArray, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentLength(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.myContentLength = -1;
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_CONTENT_LENGTH);
            }
            return true;
        }
        try {
            int n = GenericUtils.asIntValue(byArray);
            if (0 > n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid Content-Length: " + n);
                }
                return false;
            }
            if (-1 != this.getContentLength()) {
                if (this.getContentLength() == n) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setContentLength(b,b) already: " + n);
                    }
                    return true;
                }
                if (null != this.myHSC && this.myHSC.getHttpConfig().isRequestSmugglingProtectionEnabled()) {
                    this.myHSC.setPersistent(false);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setContentLength(b,b) mismatch: " + this.getContentLength());
                }
                return false;
            }
            this.myContentLength = n;
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_LENGTH, byArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Format exception in value");
            }
            return false;
        }
        return true;
    }

    public final int getContentLength() {
        return this.myContentLength;
    }

    public final void setMaxForwards(int n) {
        if (0 > n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Max-Forwards input [" + n + "]");
            }
            return;
        }
        this.myMaxForwards = n;
        if (-1 != n) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_MAX_FORWARDS, GenericUtils.asByteArray(n));
        } else {
            this.removeSpecialHeader(HttpConstants.HDR_MAX_FORWARDS);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "MaxForwards set to " + n);
        }
    }

    public final boolean setMaxForwards(byte[] byArray, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxForwards(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.myMaxForwards = -1;
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_MAX_FORWARDS);
            }
            return true;
        }
        try {
            int n = GenericUtils.asIntValue(byArray);
            if (0 > n) {
                return false;
            }
            if (this.myMaxForwards == n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Max-Forwards already " + n);
                }
                return true;
            }
            this.myMaxForwards = n;
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_MAX_FORWARDS, byArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Format exception in value");
            }
            return false;
        }
        return true;
    }

    public final int getMaxForwards() {
        return this.myMaxForwards;
    }

    private void setupConnectionClose() {
        if (this.bIsKeepAliveSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing Keep-Alive with Close in msg");
            }
            this.replaceConnection(HttpConstants.CONN_KEEPALIVE, HttpConstants.CONN_CLOSE);
            this.bIsKeepAliveSet = false;
        } else if (!HttpConstants.HTTP_VERSION_10.equals(this.getVersionValue())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Close to non-persistent msg");
            }
            this.addConnection(HttpConstants.CONN_CLOSE);
            this.commitConnection();
        }
        this.removeSpecialHeader(HttpConstants.HDR_KEEP_ALIVE);
        this.bIsCloseSet = true;
    }

    private void replaceConnection(ConnectionValues connectionValues, ConnectionValues connectionValues2) {
        for (int i = 0; i < this.indexConnection; ++i) {
            if (this.myConnectionVals[i].equals(connectionValues)) {
                this.myConnectionVals[i] = connectionValues2;
                this.commitConnection();
                return;
            }
            if (!this.myConnectionVals[i].equals(connectionValues2)) continue;
            return;
        }
        this.addConnection(connectionValues2);
        this.commitConnection();
    }

    private void addConnection(ConnectionValues connectionValues) {
        if (null == connectionValues || HttpConstants.CONN_NOTSET.equals(connectionValues)) {
            return;
        }
        if (this.indexConnection == this.myConnectionVals.length) {
            ConnectionValues[] connectionValuesArray = this.myConnectionVals;
            this.myConnectionVals = new ConnectionValues[connectionValuesArray.length + 2];
            System.arraycopy(connectionValuesArray, 0, this.myConnectionVals, 0, connectionValuesArray.length);
        }
        if (connectionValues.equals(HttpConstants.CONN_KEEPALIVE)) {
            this.bIsKeepAliveSet = true;
            this.bIsCloseSet = false;
        } else if (connectionValues.equals(HttpConstants.CONN_CLOSE)) {
            this.bIsKeepAliveSet = false;
            this.bIsCloseSet = true;
        }
        this.myConnectionVals[this.indexConnection] = connectionValues;
        ++this.indexConnection;
    }

    public final void setConnection(ConnectionValues connectionValues) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnection(v): " + connectionValues);
        }
        this.removeLocalConnection();
        this.addConnection(connectionValues);
        this.commitConnection();
    }

    public final void setConnection(ConnectionValues[] connectionValuesArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnection(v[]): " + connectionValuesArray);
        }
        this.removeLocalConnection();
        if (null != connectionValuesArray) {
            for (int i = 0; i < connectionValuesArray.length; ++i) {
                this.addConnection(connectionValuesArray[i]);
            }
        }
        this.commitConnection();
    }

    void removeConnection(ConnectionValues connectionValues) {
        for (int i = 0; i < this.indexConnection; ++i) {
            if (!connectionValues.equals(this.myConnectionVals[i])) continue;
            int n = i + 1;
            while (n < this.indexConnection) {
                this.myConnectionVals[i] = this.myConnectionVals[n];
                ++n;
                ++i;
            }
            this.myConnectionVals[i] = null;
            --this.indexConnection;
            if (HttpConstants.CONN_CLOSE.equals(connectionValues)) {
                this.bIsCloseSet = false;
            } else if (HttpConstants.CONN_KEEPALIVE.equals(connectionValues)) {
                this.bIsKeepAliveSet = HttpConstants.HTTP_VERSION_11.equals(this.myVersion);
            }
            return;
        }
    }

    private void removeLocalConnection() {
        this.bIsKeepAliveSet = HttpConstants.HTTP_VERSION_11.equals(this.myVersion);
        this.bIsCloseSet = false;
        for (int i = 0; i < this.indexConnection; ++i) {
            this.myConnectionVals[i] = null;
        }
        this.indexConnection = 0;
    }

    private void commitConnection() {
        if (0 == this.indexConnection) {
            this.removeSpecialHeader(HttpConstants.HDR_CONNECTION);
        } else if (1 == this.indexConnection) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONNECTION, this.myConnectionVals[0].getName());
        } else {
            StringBuilder stringBuilder = new StringBuilder(this.myConnectionVals[0].getName());
            for (int i = 1; i < this.indexConnection; ++i) {
                stringBuilder.append(HDR_LIST_SEPARATOR);
                stringBuilder.append(this.myConnectionVals[i].getName());
            }
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONNECTION, stringBuilder.toString());
        }
    }

    public final boolean setConnection(byte[] byArray, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnection(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.removeLocalConnection();
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_CONNECTION);
            }
        } else {
            this.matchAndParseConnection(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONNECTION, byArray);
            }
        }
        return true;
    }

    public final void removeConnectionHeader(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing connection header: " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.removeLocalConnection();
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ConnectionValues connectionValues = (ConnectionValues)ConnectionMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == connectionValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                connectionValues = ConnectionValues.makeUndefinedValue(byArray2);
            }
            this.removeConnection(connectionValues);
        }
    }

    private boolean findToken(byte[] byArray, TokenDelimiter tokenDelimiter) {
        int n;
        int n2;
        int n3 = n2 = -1 == tokenDelimiter.next ? 0 : tokenDelimiter.next;
        if (n2 >= byArray.length) {
            return false;
        }
        while (32 == byArray[n2]) {
            if (++n2 >= byArray.length) {
                return false;
            }
            if (44 != byArray[n2] || ++n2 < byArray.length) continue;
            return false;
        }
        int n4 = n = n2 + 1;
        while (n < byArray.length && 44 != byArray[n]) {
            if (32 == byArray[n]) {
                n4 = GenericUtils.skipWhiteSpace(byArray, n);
                if (n4 >= byArray.length || 44 == byArray[n4]) break;
                n = n4;
            }
            ++n;
            ++n4;
        }
        tokenDelimiter.start = n2;
        tokenDelimiter.next = n4 + 1;
        tokenDelimiter.length = n - n2;
        return true;
    }

    private void matchAndParseConnection(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ConnectionValues connectionValues = (ConnectionValues)ConnectionMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == connectionValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                connectionValues = ConnectionValues.makeUndefinedValue(byArray2);
            }
            this.addConnection(connectionValues);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsed out " + this.indexConnection + " Connection header values");
        }
    }

    public final ConnectionValues[] getConnection() {
        if (0 == this.indexConnection) {
            return new ConnectionValues[]{HttpConstants.CONN_NOTSET};
        }
        ConnectionValues[] connectionValuesArray = new ConnectionValues[this.indexConnection];
        System.arraycopy(this.myConnectionVals, 0, connectionValuesArray, 0, connectionValuesArray.length);
        return connectionValuesArray;
    }

    public final boolean isKeepAliveSet() {
        return this.bIsKeepAliveSet;
    }

    public final boolean isCloseSet() {
        return this.bIsCloseSet;
    }

    public final boolean isConnectionSet() {
        return 0 < this.indexConnection;
    }

    public final ContentEncodingValues getOutermostEncoding() {
        if (0 == this.indexContentEncoding) {
            return null;
        }
        return this.myContentEncodingVals[this.indexContentEncoding - 1];
    }

    public final void removeOutermostEncoding() {
        if (0 == this.indexContentEncoding) {
            return;
        }
        --this.indexContentEncoding;
        ContentEncodingValues contentEncodingValues = this.myContentEncodingVals[this.indexContentEncoding];
        this.myContentEncodingVals[this.indexContentEncoding] = null;
        this.commitContentEncoding();
        if (HttpConstants.CONTENT_ENCODING_GZIP.equals(contentEncodingValues)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_$WSZIP, contentEncodingValues.getName());
        } else if (HttpConstants.CONTENT_ENCODING_XGZIP.equals(contentEncodingValues)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_$WSZIP, contentEncodingValues.getName());
        } else if (HttpConstants.CONTENT_ENCODING_DEFLATE.equals(contentEncodingValues)) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_$WSZIP, contentEncodingValues.getName());
        }
    }

    public final boolean isBodyEncoded() {
        return 0 < this.indexContentEncoding;
    }

    public final boolean isDeflateOutermostEncoding() {
        return HttpConstants.CONTENT_ENCODING_DEFLATE.equals(this.getOutermostEncoding());
    }

    public final boolean isGZipOutermostEncoding() {
        return HttpConstants.CONTENT_ENCODING_GZIP.equals(this.getOutermostEncoding());
    }

    public final boolean isXGZipOutermostEncoding() {
        return HttpConstants.CONTENT_ENCODING_XGZIP.equals(this.getOutermostEncoding());
    }

    private void addContentEncoding(ContentEncodingValues contentEncodingValues) {
        if (null == contentEncodingValues || HttpConstants.CONTENT_ENCODING_NOTSET.equals(contentEncodingValues)) {
            return;
        }
        if (this.indexContentEncoding == this.myContentEncodingVals.length) {
            ContentEncodingValues[] contentEncodingValuesArray = this.myContentEncodingVals;
            this.myContentEncodingVals = new ContentEncodingValues[contentEncodingValuesArray.length + 2];
            System.arraycopy(contentEncodingValuesArray, 0, this.myContentEncodingVals, 0, contentEncodingValuesArray.length);
        }
        this.myContentEncodingVals[this.indexContentEncoding] = contentEncodingValues;
        ++this.indexContentEncoding;
    }

    private void removeContentEncoding(ContentEncodingValues contentEncodingValues) {
        for (int i = 0; i < this.indexContentEncoding; ++i) {
            if (!contentEncodingValues.equals(this.myContentEncodingVals[i])) continue;
            int n = i + 1;
            while (n < this.indexContentEncoding) {
                this.myContentEncodingVals[i] = this.myContentEncodingVals[n];
                ++n;
                ++i;
            }
            this.myContentEncodingVals[i] = null;
            --this.indexContentEncoding;
            return;
        }
    }

    protected final void appendContentEncoding(ContentEncodingValues contentEncodingValues) {
        this.addContentEncoding(contentEncodingValues);
        this.commitContentEncoding();
    }

    public final void setContentEncoding(ContentEncodingValues contentEncodingValues) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentEncoding(v): " + contentEncodingValues);
        }
        this.removeLocalContentEncoding();
        this.addContentEncoding(contentEncodingValues);
        this.commitContentEncoding();
    }

    public final void setContentEncoding(ContentEncodingValues[] contentEncodingValuesArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentEncoding(v[]): " + contentEncodingValuesArray);
        }
        this.removeLocalContentEncoding();
        if (null != contentEncodingValuesArray) {
            for (int i = 0; i < contentEncodingValuesArray.length; ++i) {
                this.addContentEncoding(contentEncodingValuesArray[i]);
            }
        }
        this.commitContentEncoding();
    }

    public final boolean setContentEncoding(byte[] byArray, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentEncoding(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.removeLocalContentEncoding();
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_CONTENT_ENCODING);
            }
        } else {
            this.matchAndParseContent(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, byArray);
            }
        }
        return true;
    }

    private void commitContentEncoding() {
        if (0 == this.indexContentEncoding) {
            this.removeSpecialHeader(HttpConstants.HDR_CONTENT_ENCODING);
        } else if (1 == this.indexContentEncoding) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, this.myContentEncodingVals[0].getName());
        } else {
            StringBuilder stringBuilder = new StringBuilder(this.myContentEncodingVals[0].getName());
            for (int i = 1; i < this.indexContentEncoding; ++i) {
                stringBuilder.append(HDR_LIST_SEPARATOR);
                stringBuilder.append(this.myContentEncodingVals[i].getName());
            }
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_ENCODING, stringBuilder.toString());
        }
    }

    public final void removeContentEncodingHeader(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing content-encoding header: " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.removeLocalContentEncoding();
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ContentEncodingValues contentEncodingValues = (ContentEncodingValues)ContentEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == contentEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                contentEncodingValues = ContentEncodingValues.makeUndefinedValue(byArray2);
            }
            this.removeContentEncoding(contentEncodingValues);
        }
    }

    private void removeLocalContentEncoding() {
        for (int i = 0; i < this.indexContentEncoding; ++i) {
            this.myContentEncodingVals[i] = null;
        }
        this.indexContentEncoding = 0;
    }

    private void matchAndParseContent(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ContentEncodingValues contentEncodingValues = (ContentEncodingValues)ContentEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == contentEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                contentEncodingValues = ContentEncodingValues.makeUndefinedValue(byArray2);
            }
            this.addContentEncoding(contentEncodingValues);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsed out " + this.indexContentEncoding + " Content-Encoding header values");
        }
    }

    public final ContentEncodingValues[] getContentEncoding() {
        if (0 == this.indexContentEncoding) {
            return new ContentEncodingValues[]{HttpConstants.CONTENT_ENCODING_NOTSET};
        }
        ContentEncodingValues[] contentEncodingValuesArray = new ContentEncodingValues[this.indexContentEncoding];
        System.arraycopy(this.myContentEncodingVals, 0, contentEncodingValuesArray, 0, contentEncodingValuesArray.length);
        return contentEncodingValuesArray;
    }

    private void addTransferEncoding(TransferEncodingValues transferEncodingValues) {
        if (null == transferEncodingValues || HttpConstants.TRANSFER_ENCODING_NOTSET.equals(transferEncodingValues)) {
            return;
        }
        if (this.indexTransfer == this.myTransferVals.length) {
            TransferEncodingValues[] transferEncodingValuesArray = this.myTransferVals;
            this.myTransferVals = new TransferEncodingValues[transferEncodingValuesArray.length + 2];
            System.arraycopy(transferEncodingValuesArray, 0, this.myTransferVals, 0, transferEncodingValuesArray.length);
        }
        if (!this.isChunkedEncodingSet()) {
            this.bIsChunkedEncodingSet = transferEncodingValues.equals(HttpConstants.TRANSFER_ENCODING_CHUNKED);
        }
        this.myTransferVals[this.indexTransfer] = transferEncodingValues;
        ++this.indexTransfer;
    }

    protected void appendTransferEncoding(TransferEncodingValues transferEncodingValues) {
        this.addTransferEncoding(transferEncodingValues);
        this.commitTransferEncoding();
    }

    public final void setTransferEncoding(TransferEncodingValues transferEncodingValues) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferEncoding(v): " + transferEncodingValues);
        }
        this.removeLocalTransferEncoding();
        this.addTransferEncoding(transferEncodingValues);
        this.commitTransferEncoding();
    }

    public final void setTransferEncoding(TransferEncodingValues[] transferEncodingValuesArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferEncoding(v[]): " + transferEncodingValuesArray);
        }
        this.removeLocalTransferEncoding();
        if (null != transferEncodingValuesArray) {
            for (int i = 0; i < transferEncodingValuesArray.length; ++i) {
                this.addTransferEncoding(transferEncodingValuesArray[i]);
            }
        }
        this.commitTransferEncoding();
    }

    protected void commitTransferEncoding() {
        if (0 == this.indexTransfer) {
            this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
        } else if (1 == this.indexTransfer) {
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_TRANSFER_ENCODING, this.myTransferVals[0].getName());
        } else {
            StringBuilder stringBuilder = new StringBuilder(this.myTransferVals[0].getName());
            for (int i = 1; i < this.indexTransfer; ++i) {
                stringBuilder.append(HDR_LIST_SEPARATOR);
                stringBuilder.append(this.myTransferVals[i].getName());
            }
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_TRANSFER_ENCODING, stringBuilder.toString());
        }
    }

    protected final void removeTransferEncoding(TransferEncodingValues transferEncodingValues) {
        for (int i = 0; i < this.indexTransfer; ++i) {
            if (!transferEncodingValues.equals(this.myTransferVals[i])) continue;
            int n = i + 1;
            while (n < this.indexTransfer) {
                this.myTransferVals[i] = this.myTransferVals[n];
                ++n;
                ++i;
            }
            this.myTransferVals[i] = null;
            --this.indexTransfer;
            if (HttpConstants.TRANSFER_ENCODING_CHUNKED.equals(transferEncodingValues)) {
                this.bIsChunkedEncodingSet = false;
            }
            return;
        }
    }

    private void removeLocalTransferEncoding() {
        this.bIsChunkedEncodingSet = false;
        for (int i = 0; i < this.indexTransfer; ++i) {
            this.myTransferVals[i] = null;
        }
        this.indexTransfer = 0;
    }

    public final boolean setTransferEncoding(byte[] byArray, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferEncoding(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.removeLocalTransferEncoding();
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
            }
        } else {
            this.matchAndParseTransfer(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_TRANSFER_ENCODING, byArray);
            }
        }
        return true;
    }

    public final void removeTransferEncodingHeader(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing transfer-encoding header: " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.removeLocalTransferEncoding();
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            TransferEncodingValues transferEncodingValues = (TransferEncodingValues)TransferEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == transferEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                transferEncodingValues = TransferEncodingValues.makeUndefinedValue(byArray2);
            }
            this.removeTransferEncoding(transferEncodingValues);
        }
    }

    private void matchAndParseTransfer(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            TransferEncodingValues transferEncodingValues = (TransferEncodingValues)TransferEncodingMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == transferEncodingValues) {
                byte[] byArray2 = new byte[tokenDelimiter.length];
                System.arraycopy(byArray, tokenDelimiter.start, byArray2, 0, tokenDelimiter.length);
                transferEncodingValues = TransferEncodingValues.makeUndefinedValue(byArray2);
            }
            this.addTransferEncoding(transferEncodingValues);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsed out " + this.indexTransfer + " Transfer-Encoding header values");
        }
    }

    public final TransferEncodingValues[] getTransferEncoding() {
        if (0 == this.indexTransfer) {
            return new TransferEncodingValues[]{HttpConstants.TRANSFER_ENCODING_NOTSET};
        }
        TransferEncodingValues[] transferEncodingValuesArray = new TransferEncodingValues[this.indexTransfer];
        System.arraycopy(this.myTransferVals, 0, transferEncodingValuesArray, 0, transferEncodingValuesArray.length);
        return transferEncodingValuesArray;
    }

    public final boolean isChunkedEncodingSet() {
        return this.bIsChunkedEncodingSet;
    }

    private void addExpect(ExpectValues expectValues) {
        if (HttpConstants.EXPECT_100CONTINUE.equals(expectValues)) {
            this.bIs100Continue = true;
        }
    }

    private void matchAndParseExpect(byte[] byArray) {
        if (null == byArray || 0 == byArray.length) {
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ExpectValues expectValues = (ExpectValues)ExpectMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == expectValues) continue;
            this.addExpect(expectValues);
        }
    }

    public final void setExpect(byte[] byArray) {
        this.bIs100Continue = false;
        if (null == byArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Expect(b) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
        } else {
            this.matchAndParseExpect(byArray);
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, byArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setExpect(b): 100-continue is " + this.isExpect100Continue());
            }
        }
    }

    public final void setExpect(String string) {
        this.bIs100Continue = false;
        if (null == string) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Expect(s) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
        } else {
            this.matchAndParseExpect(GenericUtils.getEnglishBytes(string));
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, string);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setExpect(s): 100-continue is " + this.isExpect100Continue());
            }
        }
    }

    public final void setExpect(ExpectValues expectValues) {
        this.bIs100Continue = false;
        if (null == expectValues) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Expect(v) header");
            }
            this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
        } else {
            this.addExpect(expectValues);
            this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, expectValues.getByteArray());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setExpect(v): 100-continue is " + this.isExpect100Continue());
            }
        }
    }

    public final boolean setExpect(byte[] byArray, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setExpect(b,b): " + bl + " " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.bIs100Continue = false;
            if (bl) {
                this.removeSpecialHeader(HttpConstants.HDR_EXPECT);
            }
        } else {
            this.matchAndParseExpect(byArray);
            if (bl) {
                this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_EXPECT, byArray);
            }
        }
        return true;
    }

    public final void removeExpectHeader(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing expect header: " + GenericUtils.getEnglishString(byArray));
        }
        if (null == byArray) {
            this.bIs100Continue = false;
            return;
        }
        TokenDelimiter tokenDelimiter = new TokenDelimiter();
        while (tokenDelimiter.next < byArray.length && this.findToken(byArray, tokenDelimiter)) {
            ExpectValues expectValues = (ExpectValues)ExpectMatcher.getRef().match(byArray, tokenDelimiter.start, tokenDelimiter.length);
            if (null == expectValues || !HttpConstants.EXPECT_100CONTINUE.equals(expectValues)) continue;
            this.bIs100Continue = false;
        }
    }

    public final byte[] getExpect() {
        int n = this.getNumberOfHeaderInstances(HttpConstants.HDR_EXPECT);
        if (0 == n) {
            return null;
        }
        if (1 == n) {
            return this.getHeaderAsByteArray(HttpConstants.HDR_EXPECT);
        }
        StringBuilder stringBuilder = new StringBuilder(this.getHeaderAsString(HttpConstants.HDR_EXPECT));
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(HDR_LIST_SEPARATOR);
            stringBuilder.append(this.getHeaderAsString(HttpConstants.HDR_EXPECT, i));
        }
        return GenericUtils.getBytes(stringBuilder);
    }

    public final boolean isExpect100Continue() {
        return this.bIs100Continue;
    }

    public final String getMIMEType() {
        return this.parseMIMEType();
    }

    private String parseMIMEType() {
        byte[] byArray = this.getHeaderAsByteArray(HttpConstants.HDR_CONTENT_TYPE);
        if (null == byArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "parseMIMEType: no Content-Type header present");
            }
            return null;
        }
        int n = byArray.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (59 != byArray[i]) continue;
            n2 = i;
            break;
        }
        if (-1 == n2) {
            n2 = n;
        }
        return HttpChannelUtils.getEnglishString(byArray, 0, n2);
    }

    public final void setMIMEType(String string) {
        int n = string.indexOf(";");
        if (-1 != n) {
            string = string.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(";charset=");
        stringBuilder.append(this.parseCharset());
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, stringBuilder.toString());
    }

    public final Charset getCharset() {
        return this.parseCharset();
    }

    private Charset parseCharset() {
        privCharsetLookup privCharsetLookup2;
        block4: {
            String string = this.parseCharacterEncoding(this.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE));
            if (null != string) {
                privCharsetLookup2 = new privCharsetLookup(string);
                try {
                    return (Charset)AccessController.doPrivileged(privCharsetLookup2);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Unknown charset name: " + string);
                }
            }
        }
        if (null == DEF_CHARSET) {
            privCharsetLookup2 = new privCharsetLookup("ISO-8859-1");
            DEF_CHARSET = (Charset)AccessController.doPrivileged(privCharsetLookup2);
        }
        return DEF_CHARSET;
    }

    private String parseCharacterEncoding(String string) {
        int n;
        boolean bl;
        if (null == string) {
            return null;
        }
        int n2 = string.indexOf("charset=");
        if (-1 == n2) {
            return null;
        }
        boolean bl2 = bl = '\"' == string.charAt(n2 += "charset=".length());
        if (bl) {
            ++n2;
        }
        if (-1 == (n = string.indexOf(59, n2))) {
            n = string.length();
        }
        if (bl && '\"' == string.charAt(n - 1)) {
            --n;
        }
        return string.substring(n2, n).trim();
    }

    public final void setCharset(Charset charset) {
        if (null == charset) {
            throw new NullPointerException("charset");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.parseMIMEType();
        if (null == string) {
            string = DEFAULT_MIMETYPE;
        }
        stringBuilder.append(string);
        stringBuilder.append(";charset=");
        stringBuilder.append(charset.toString());
        this.setSpecialHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void headerComplianceCheck() throws MessageSentException {
        HttpServiceContextImpl httpServiceContextImpl = this.getServiceContext();
        if (httpServiceContextImpl.headersSent()) {
            throw new MessageSentException("Headers already sent.");
        }
        try {
            if (this.getVersionValue().equals(HttpConstants.HTTP_VERSION_11)) {
                if (-1 == this.getContentLength() && !this.isChunkedEncodingSet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Partial bodied 1.1 output");
                    }
                    if (httpServiceContextImpl.isOutgoingBodyValid()) {
                        this.addTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
                        this.commitTransferEncoding();
                    }
                }
                if (!httpServiceContextImpl.isPersistent() && !this.isCloseSet()) {
                    this.setupConnectionClose();
                }
            } else if (this.getVersionValue().equals(HttpConstants.HTTP_VERSION_10)) {
                if (this.isChunkedEncodingSet()) {
                    this.removeSpecialHeader(HttpConstants.HDR_TRANSFER_ENCODING);
                    this.removeLocalTransferEncoding();
                    httpServiceContextImpl.setPersistent(false);
                }
                if (!httpServiceContextImpl.isPersistent() || -1 == this.getContentLength()) {
                    if (!this.isCloseSet()) {
                        this.setupConnectionClose();
                    }
                    httpServiceContextImpl.setPersistent(false);
                } else if (httpServiceContextImpl.isPersistent() && !this.isKeepAliveSet() && !this.isCloseSet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Keep-Alive to persistent 1.0 msg");
                    }
                    this.addConnection(HttpConstants.CONN_KEEPALIVE);
                    this.commitConnection();
                }
            }
            this.removeSpecialHeader(HttpConstants.HDR_$WSZIP);
            this.removeSpecialHeader(HttpConstants.HDR_$WSORIGCL);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FFDCFilter.processException((Throwable)illegalArgumentException, this.getClass().getName() + ".headerComplianceCheck", "1996", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Too many headers in message for compliance to finish");
                }
                if (!httpServiceContextImpl.getHttpConfig().isServantRegion()) return;
            }
            catch (Throwable throwable) {
                if (!httpServiceContextImpl.getHttpConfig().isServantRegion()) throw throwable;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Running on z/OS SR, persistence: " + httpServiceContextImpl.isPersistent());
                }
                httpServiceContextImpl.getVC().getStateMap().put("SessionPersistence", httpServiceContextImpl.isPersistent() ? "true" : "false");
                httpServiceContextImpl.setPersistent(false);
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Running on z/OS SR, persistence: " + httpServiceContextImpl.isPersistent());
            }
            httpServiceContextImpl.getVC().getStateMap().put("SessionPersistence", httpServiceContextImpl.isPersistent() ? "true" : "false");
            httpServiceContextImpl.setPersistent(false);
            return;
        }
        if (!httpServiceContextImpl.getHttpConfig().isServantRegion()) return;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Running on z/OS SR, persistence: " + httpServiceContextImpl.isPersistent());
        }
        httpServiceContextImpl.getVC().getStateMap().put("SessionPersistence", httpServiceContextImpl.isPersistent() ? "true" : "false");
        httpServiceContextImpl.setPersistent(false);
        return;
    }

    protected void parsingComplete() throws MalformedMessageException {
    }

    public abstract WsByteBuffer[] marshallBinaryFirstLine();

    public WsByteBuffer[] marshallBinaryMessage() throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallBinaryMessage");
        }
        this.preMarshallMessage();
        WsByteBuffer[] wsByteBufferArray = this.marshallBinaryFirstLine();
        this.headerComplianceCheck();
        wsByteBufferArray = this.marshallBinaryHeaders(wsByteBufferArray);
        this.postMarshallMessage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallBinaryMessage");
        }
        return wsByteBufferArray;
    }

    public boolean parseMessage(WsByteBuffer wsByteBuffer, boolean bl) throws Exception {
        int n;
        boolean bl2;
        this.myHSC.checkIncomingMessageLimit(wsByteBuffer.remaining());
        boolean bl3 = bl2 = this.myHSC.getHttpConfig().isBinaryTransportEnabled() ? this.parseBinaryMessage(wsByteBuffer) : super.parseMessage(wsByteBuffer, bl);
        if (bl2 && 0 < (n = wsByteBuffer.remaining())) {
            this.myHSC.addToIncomingMsgSize(-n);
        }
        return bl2;
    }

    public boolean parseLineDiscrim(WsByteBuffer wsByteBuffer) throws Exception {
        this.getServiceContext().checkIncomingMessageLimit(wsByteBuffer.remaining());
        if (this.getServiceContext().getHttpConfig().isBinaryTransportEnabled()) {
            return this.parseBinaryFirstLine(wsByteBuffer);
        }
        return this.parseLine(wsByteBuffer);
    }

    public abstract boolean parseBinaryFirstLine(WsByteBuffer var1) throws MalformedMessageException;

    public boolean parseBinaryMessage(WsByteBuffer wsByteBuffer) throws Exception {
        boolean bl = false;
        if (!this.isFirstLineComplete()) {
            bl = this.parseBinaryFirstLine(wsByteBuffer);
        }
        if (this.isFirstLineComplete()) {
            bl = this.parseBinaryHeaders(wsByteBuffer, HttpConstants.HDR_$WSAT);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseBinaryMessage returning " + bl);
        }
        return bl;
    }

    private void marshallCookieCache(CookieCacheData cookieCacheData) {
        if (null != cookieCacheData && cookieCacheData.isDirty()) {
            List list = this.getAllCookies(cookieCacheData.getHeaderType());
            this.removeSpecialHeader(cookieCacheData.getHeaderType());
            this.marshallCookies(list, cookieCacheData.getHeaderType());
            cookieCacheData.setIsDirty(false);
        }
    }

    protected boolean isCookieCacheDirty(HeaderKeys headerKeys) {
        if (HttpConstants.HDR_SET_COOKIE.equals(headerKeys)) {
            return null != this.setCookieCache ? this.setCookieCache.isDirty() : false;
        }
        if (HttpConstants.HDR_SET_COOKIE2.equals(headerKeys)) {
            return null != this.setCookie2Cache ? this.setCookie2Cache.isDirty() : false;
        }
        if (HttpConstants.HDR_COOKIE.equals(headerKeys)) {
            return null != this.cookieCache ? this.cookieCache.isDirty() : false;
        }
        if (HttpConstants.HDR_COOKIE2.equals(headerKeys)) {
            return null != this.cookie2Cache ? this.cookie2Cache.isDirty() : false;
        }
        return false;
    }

    protected void preMarshallMessage() throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "preMarshallMessage");
        }
        super.preMarshallMessage();
        this.marshallCookieCache(this.cookieCache);
        this.marshallCookieCache(this.cookie2Cache);
        this.marshallCookieCache(this.setCookieCache);
        this.marshallCookieCache(this.setCookie2Cache);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "preMarshallMessage");
        }
    }

    protected final byte[] getCookieValue(String string, HeaderKeys headerKeys) {
        int n = this.getNumberOfHeaderInstances(headerKeys);
        if (0 == n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header not present (" + headerKeys.getName() + ")");
            }
            return null;
        }
        if (null == string || 0 == string.length()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getCookieValue: invalid name [" + string + "]");
            }
            return null;
        }
        if ('\"' == string.charAt(0) && '\"' == string.charAt(string.length() - 1)) {
            string = string.substring(1, string.length() - 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCookieValue: [" + string + "] num: " + n);
        }
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = this.getHeaderAsByteArray(headerKeys, i);
            while (n2 < byArray.length) {
                int n3;
                if (32 == byArray[n2] && (n2 = GenericUtils.skipWhiteSpace(byArray, n2)) >= byArray.length) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Ran out of data");
                    continue;
                }
                boolean bl2 = bl = 34 == byArray[n2];
                if (bl) {
                    ++n2;
                }
                for (n3 = 0; n3 < string.length() && string.charAt(n3) == byArray[n2]; ++n3) {
                    if (++n2 < byArray.length) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Only the cookie name found");
                    }
                    return null;
                }
                if (n3 != string.length()) {
                    n2 = GenericUtils.skipToChars(byArray, n2, COOKIE_DELIMS) + 1;
                    continue;
                }
                if (bl) {
                    if (34 != byArray[n2]) {
                        n2 = GenericUtils.skipToChars(byArray, n2, COOKIE_DELIMS) + 1;
                        continue;
                    }
                    ++n2;
                }
                if (n2 < byArray.length && 32 == byArray[n2]) {
                    n2 = GenericUtils.skipWhiteSpace(byArray, n2);
                }
                if (n2 < byArray.length && 61 != byArray[n2]) {
                    n2 = GenericUtils.skipToChars(byArray, n2, COOKIE_DELIMS) + 1;
                    continue;
                }
                if (++n2 >= byArray.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cookie name found but no value after =");
                    }
                    return null;
                }
                if (32 == byArray[n2] && (n2 = GenericUtils.skipWhiteSpace(byArray, n2)) >= byArray.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cookie name with just whitespace val");
                    }
                    return null;
                }
                bl = 34 == byArray[n2];
                int n4 = n2++;
                if (bl) {
                    while (n2 < byArray.length && 34 != byArray[n2] && 44 != byArray[n2] && 59 != byArray[n2]) {
                        ++n2;
                    }
                    if (n2 < byArray.length && 34 == byArray[n2]) {
                        ++n2;
                    }
                } else {
                    while (n2 < byArray.length && 59 != byArray[n2] && 44 != byArray[n2]) {
                        if (32 == byArray[n2]) {
                            int n5 = GenericUtils.skipWhiteSpace(byArray, n2);
                            if (n5 >= byArray.length || 59 == byArray[n5] || 44 == byArray[n5]) break;
                            n2 = n5;
                        }
                        ++n2;
                    }
                }
                if (n4 >= n2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No actual value found");
                    }
                    return null;
                }
                byte[] byArray2 = new byte[n2 - n4];
                System.arraycopy(byArray, n4, byArray2, 0, byArray2.length);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCookieValue: returning [" + GenericUtils.getEnglishString(byArray2) + "]");
                }
                return byArray2;
            }
            n2 = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Cookie name not found");
        }
        return null;
    }

    protected final List getAllCookieValues(String string, HeaderKeys headerKeys, HeaderKeys headerKeys2) {
        Cookie cookie;
        Iterator iterator;
        LinkedList<String> linkedList = new LinkedList<String>();
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        this.parseAllCookies(cookieCacheData, headerKeys);
        if (null != cookieCacheData.getParsedList()) {
            iterator = cookieCacheData.getParsedList().iterator();
            while (iterator.hasNext()) {
                cookie = (Cookie)iterator.next();
                if (!string.equals(cookie.getName())) continue;
                linkedList.add(cookie.getValue());
            }
        }
        cookieCacheData = this.getCookieCache(headerKeys2);
        this.parseAllCookies(cookieCacheData, headerKeys2);
        if (null != cookieCacheData.getParsedList()) {
            iterator = cookieCacheData.getParsedList().iterator();
            while (iterator.hasNext()) {
                cookie = (Cookie)iterator.next();
                if (!string.equals(cookie.getName())) continue;
                linkedList.add(cookie.getValue());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookieValues: Found " + linkedList.size() + " instances of " + string);
        }
        return linkedList;
    }

    protected final Cookie getCookie(String string, HeaderKeys headerKeys) {
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        Cookie cookie = cookieCacheData.getCookie(string);
        if (null != cookie) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + string + " in cache");
            }
            return cookie;
        }
        int n = this.getNumberOfHeaderInstances(headerKeys);
        for (int i = cookieCacheData.getHeaderIndex(); i < n; ++i) {
            List list = this.getCookieParser().parse(this.getHeaderAsByteArray(headerKeys, i), headerKeys);
            cookieCacheData.addParsedCookies(list);
            cookieCacheData.incrementHeaderIndex();
            Iterator iterator = list.iterator();
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                cookie = (Cookie)iterator.next();
                if (!cookie.getName().equals(string)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found parsed Cookie-->" + string);
                }
                return cookie;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCookie --> " + string + " of type " + headerKeys.getName() + " not found");
        }
        return null;
    }

    private void parseAllCookies(CookieCacheData cookieCacheData, HeaderKeys headerKeys) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing all cookies for " + headerKeys.getName());
        }
        int n = this.getNumberOfHeaderInstances(headerKeys);
        for (int i = cookieCacheData.getHeaderIndex(); i < n; ++i) {
            List list = this.getCookieParser().parse(this.getHeaderAsByteArray(headerKeys, i), headerKeys);
            cookieCacheData.addParsedCookies(list);
            cookieCacheData.incrementHeaderIndex();
        }
    }

    protected final List getAllCookies(HeaderKeys headerKeys) {
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        this.parseAllCookies(cookieCacheData, headerKeys);
        if (null == cookieCacheData.getParsedList()) {
            return new LinkedList();
        }
        return new LinkedList(cookieCacheData.getParsedList());
    }

    protected final List getAllCookies(HeaderKeys headerKeys, HeaderKeys headerKeys2) {
        Iterator iterator;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        this.parseAllCookies(cookieCacheData, headerKeys);
        if (null != cookieCacheData.getParsedList()) {
            iterator = cookieCacheData.getParsedList().iterator();
            while (iterator.hasNext()) {
                linkedList.add(((Cookie)iterator.next()).clone());
            }
        }
        cookieCacheData = this.getCookieCache(headerKeys2);
        this.parseAllCookies(cookieCacheData, headerKeys2);
        if (null != cookieCacheData.getParsedList()) {
            iterator = cookieCacheData.getParsedList().iterator();
            while (iterator.hasNext()) {
                linkedList.add(((Cookie)iterator.next()).clone());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookies: Found " + linkedList.size() + " instances");
        }
        return linkedList;
    }

    protected final List getAllCookies(String string, HeaderKeys headerKeys, HeaderKeys headerKeys2) {
        Cookie cookie;
        Iterator iterator;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        CookieCacheData cookieCacheData = this.getCookieCache(headerKeys);
        this.parseAllCookies(cookieCacheData, headerKeys);
        if (null != cookieCacheData.getParsedList()) {
            iterator = cookieCacheData.getParsedList().iterator();
            while (iterator.hasNext()) {
                cookie = (Cookie)iterator.next();
                if (!string.equals(cookie.getName())) continue;
                linkedList.add(cookie.clone());
            }
        }
        cookieCacheData = this.getCookieCache(headerKeys2);
        this.parseAllCookies(cookieCacheData, headerKeys2);
        if (null != cookieCacheData.getParsedList()) {
            iterator = cookieCacheData.getParsedList().iterator();
            while (iterator.hasNext()) {
                cookie = (Cookie)iterator.next();
                if (!string.equals(cookie.getName())) continue;
                linkedList.add(cookie.clone());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookies: Found " + linkedList.size() + " instances of " + string);
        }
        return linkedList;
    }

    protected final boolean addCookie(Cookie cookie, HeaderKeys headerKeys) {
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not adding cookie to committed message: " + cookie.getName() + " " + headerKeys.getName());
            }
            return false;
        }
        this.getCookieCache(headerKeys).addNewCookie((Cookie)cookie.clone());
        return true;
    }

    private CookieHeaderByteParser getCookieParser() {
        if (null == this.cookieParser) {
            this.cookieParser = new CookieHeaderByteParser();
        }
        return this.cookieParser;
    }

    private CookieCacheData getCookieCache(HeaderKeys headerKeys) {
        if (headerKeys.equals(HttpConstants.HDR_COOKIE)) {
            if (null == this.cookieCache) {
                this.cookieCache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.cookieCache, headerKeys);
                }
            }
            return this.cookieCache;
        }
        if (headerKeys.equals(HttpConstants.HDR_COOKIE2)) {
            if (null == this.cookie2Cache) {
                this.cookie2Cache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.cookie2Cache, headerKeys);
                }
            }
            return this.cookie2Cache;
        }
        if (headerKeys.equals(HttpConstants.HDR_SET_COOKIE)) {
            if (null == this.setCookieCache) {
                this.setCookieCache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.setCookieCache, headerKeys);
                }
            }
            return this.setCookieCache;
        }
        if (headerKeys.equals(HttpConstants.HDR_SET_COOKIE2)) {
            if (null == this.setCookie2Cache) {
                this.setCookie2Cache = new CookieCacheData(headerKeys);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.setCookie2Cache, headerKeys);
                }
            }
            return this.setCookie2Cache;
        }
        throw new IllegalArgumentException(headerKeys.getName());
    }

    protected final boolean deleteCookie(String string, HeaderKeys headerKeys) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCookie: " + string);
        }
        boolean bl = false;
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not removing committed cookie: " + string);
            }
        } else {
            Cookie cookie = this.getCookie(string, headerKeys);
            if (null != cookie) {
                bl = this.getCookieCache(headerKeys).removeCookie(cookie);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCookie: " + bl);
        }
        return bl;
    }

    public final boolean containsCookie(String string, HeaderKeys headerKeys) {
        if (null == string) {
            throw new NullPointerException("Cookie name");
        }
        if (null == headerKeys) {
            throw new NullPointerException("Header");
        }
        return null != this.getCookie(string, headerKeys);
    }

    private void marshallCookies(List list, HeaderKeys headerKeys) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallCookies");
        }
        Iterator iterator = list.iterator();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.appendHeader(headerKeys, CookieUtils.toString((Cookie)iterator.next(), headerKeys));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallCookies");
        }
    }

    private class privCharsetLookup
    implements PrivilegedAction {
        private String encoding;

        public privCharsetLookup(String string) {
            this.encoding = string;
        }

        public Object run() {
            return Charset.forName(this.encoding);
        }
    }

    protected class TokenDelimiter {
        protected int start = -1;
        protected int length = -1;
        protected int next = -1;

        protected TokenDelimiter() {
        }
    }
}

