/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.cookies.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.ws.http.channel.matcher.impl.CookieDataMatcher;
import com.ibm.ws.http.channel.values.impl.CookieData;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;

public class CookieHeaderByteParser {
    private static final TraceComponent tc = Tr.register(CookieHeaderByteParser.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private int bytePosition = 0;
    private byte[] name;
    private byte[] value;

    private byte[] getValue() {
        return this.value;
    }

    private String getValueString() {
        return GenericUtils.getEnglishString(this.getValue());
    }

    private byte[] getName() {
        return this.name;
    }

    private String getNameString() {
        return GenericUtils.getEnglishString(this.getName());
    }

    private int getPosition() {
        return this.bytePosition;
    }

    private void setPosition(int n) {
        this.bytePosition = n;
    }

    private void setName(byte[] byArray) {
        this.name = byArray;
    }

    private void setValue(byte[] byArray) {
        this.value = byArray;
    }

    public List parse(byte[] byArray, HeaderKeys headerKeys) throws IllegalArgumentException {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input");
        }
        this.setName(null);
        this.setValue(null);
        this.setPosition(0);
        CookieData cookieData = null;
        Cookie cookie = null;
        LinkedList<Cookie> linkedList = new LinkedList<Cookie>();
        int n = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parse [" + GenericUtils.getEnglishString(byArray) + "] " + headerKeys);
        }
        while (this.getPosition() < byArray.length) {
            cookieData = this.matchAndParse(byArray, headerKeys);
            this.parseValue(byArray, cookieData);
            if (null == cookieData) {
                if (null != this.getName() && 0 != this.getName().length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating cookie, version " + n);
                    }
                    try {
                        cookie = new Cookie(this.getNameString(), this.getValueString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.setName(null);
                        this.setValue(null);
                        continue;
                    }
                    cookie.setVersion(n);
                    linkedList.add(cookie);
                }
            } else if (null != this.getValue()) {
                if (CookieDataMatcher.cookieVersion.equals(cookieData)) {
                    try {
                        n = GenericUtils.asIntValue(this.getValue());
                        if (null != cookie) {
                            cookie.setVersion(n);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException(numberFormatException, this.getClass().getName() + ".parse", "166");
                        n = 0;
                    }
                } else if (null != cookie) {
                    cookieData.set(cookie, this.getValue());
                }
            }
            cookieData = null;
            this.setName(null);
            this.setValue(null);
        }
        return linkedList;
    }

    private CookieData matchAndParse(byte[] byArray, HeaderKeys headerKeys) {
        boolean bl;
        int n;
        int n2 = -1;
        int n3 = -1;
        for (n = this.bytePosition; n < byArray.length && 61 != 0 != (bl = byArray[n]); ++n) {
            if (59 != 0 == bl || 44 != 0 == bl) {
                if (-1 == n2) continue;
                --n;
                break;
            }
            if (32 != 0 == bl || 9 != 0 == bl) continue;
            if (-1 == n2) {
                n2 = n;
            }
            n3 = n;
        }
        this.bytePosition = n + 1;
        if (-1 == n2) {
            return null;
        }
        if (-1 == n3) {
            n3 = n;
        } else if (byArray.length == n3) {
            --n3;
        }
        boolean bl2 = bl = 36 == byArray[n2];
        if (bl) {
            ++n2;
        } else if (34 == byArray[n2] && 34 == byArray[n3]) {
            ++n2;
            --n3;
        }
        int n4 = n3 - n2 + 1;
        if (0 >= n4) {
            return null;
        }
        CookieData cookieData = (CookieData)CookieDataMatcher.getRef().match(byArray, n2, n4);
        if (null != cookieData && null != headerKeys && !cookieData.validForHeader(headerKeys, bl)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Token not valid for header, " + headerKeys + " " + cookieData);
            }
            cookieData = null;
        }
        if (null == cookieData) {
            this.setName(new byte[n4]);
            System.arraycopy(byArray, n2, this.getName(), 0, n4);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + this.getNameString());
            }
        }
        return cookieData;
    }

    private void parseValue(byte[] byArray, CookieData cookieData) {
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        for (n2 = this.bytePosition; n2 < byArray.length && 59 != (n = byArray[n2]); ++n2) {
            if (34 == n) {
                ++n5;
            }
            if (44 == n && (!CookieDataMatcher.cookiePort.equals(cookieData) ? !CookieDataMatcher.cookieExpires.equals(cookieData) : 2 <= n5)) break;
            if (32 == n || 9 == n) continue;
            if (-1 == n3) {
                n3 = n2;
            }
            n4 = n2;
        }
        this.bytePosition = n2 + 1;
        if (-1 == n3) {
            this.setValue(new byte[0]);
            return;
        }
        if (-1 == n4) {
            this.setValue(new byte[0]);
            return;
        }
        if (34 == byArray[n3] && 34 == byArray[n4]) {
            ++n3;
            --n4;
        }
        if (0 <= (n = n4 - n3 + 1)) {
            this.setValue(new byte[n]);
            if (0 < n) {
                System.arraycopy(byArray, n3, this.getValue(), 0, n);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "value: " + this.getValueString());
                }
            }
        }
    }

    private void printCookie(Cookie cookie) {
        System.out.println();
        System.out.println(" Name: " + cookie.getName() + " Value: " + cookie.getValue());
        System.out.println(" Path: " + cookie.getPath());
        System.out.println(" Version: " + cookie.getVersion());
        System.out.println(" Domain: " + cookie.getDomain());
        System.out.println(" Secure: " + cookie.getSecure());
        System.out.println(" Max-Age: " + cookie.getMaxAge());
        System.out.println(" Comment: " + cookie.getComment());
        System.out.println();
    }

    public String getFFDCDumpData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Exception thrown while parsing the following name:value combination ");
        HTTPChannelDM.formatFFDCString(" name", this.getNameString(), stringBuffer);
        HTTPChannelDM.formatFFDCString(" value", this.getValueString(), stringBuffer);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        CookieHeaderByteParser cookieHeaderByteParser = new CookieHeaderByteParser();
        String string = "Version=1; Customer=\"WILE E COYOTE\"; Path=\"/acme\"; Part_Number=\"Rocket_Launcher_0001\"; Path=\"/acme\"; Name=Bob; expires=Wednesday, 29-AUG-05 18:00:40 GMT; path=\"/Rohit\"; secure ; Version =0; domain=ibm.com;Comment=\"Good Cookie\"";
        byte[] byArray = string.getBytes();
        List list = new LinkedList();
        int n = 0;
        int n2 = 100;
        long l = System.currentTimeMillis();
        for (n = 0; n < n2; ++n) {
            list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_SET_COOKIE);
        }
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Time taken for " + n + " computations: " + l2);
        System.out.println("Num Set-Cookies [should be 3] (h1) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = "Version =1;Name=Rohit; secure ; expires=Wednesday, 24-AUG-05 18:00:40 GMT;;;Family =Kelapure; secure;;";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_SET_COOKIE);
        System.out.println("Num Set-Cookies [should be 2] (h2) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = "$Version =1;Name=Rohit; secure ;;;Family =Kelapure; ;";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_COOKIE);
        System.out.println("Num Cookies [should be 2] (h3) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = " Name=Bob; expires=Wednesday, 24-AUG-05 18:00:40 GMT; path=\"/Rohit\"; secure; Version =1; domain=ibm.com";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_SET_COOKIE);
        System.out.println("Num Set-Cookies [should be 1] (h4) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = " Name=Bob; $path=\"/Rohit\"; $Version =1; $domain=ibm.com";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_SET_COOKIE);
        System.out.println("Num Set-Cookies [should be 1] (h5) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = "MyNullCookie;MyCookie2=Rohit; MyNullCookie3";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_SET_COOKIE);
        System.out.println("Num Set-Cookies [should be 3] (h6) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = "Version=\"1\";Name=Bob; path=\"/Rohit\"; Port=\"80,8000\"; CommentURL=testing; Discard;";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_SET_COOKIE2);
        System.out.println("Num Set-Cookie2s [should be 1] (h7) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = "$Version=\"1\";Name=Bob; $path=\"/Rohit\"; $Port=\"80,8000\"; CommentURL=testing; $domain=ibm.com";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_COOKIE2);
        System.out.println("Num Cookie2s [should be 2] (h8) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
        string = "prefix=http, server=LP02UT4, port=80, servletpath=_servlet-tests_hsreqw_HttpServletRequestWrapperGetRequestURLTest";
        byArray = string.getBytes();
        list = cookieHeaderByteParser.parse(byArray, HttpConstants.HDR_COOKIE);
        System.out.println("Num Cookies [should be 4] (h9) = " + list.size());
        System.out.println(string);
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            cookieHeaderByteParser.printCookie((Cookie)list.get(n));
        }
        System.out.println();
    }
}

