/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.Normalizer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.HeaderStorage;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HeaderHandler {
    private static final TraceComponent tc = Tr.register(HeaderHandler.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private char mySep = (char)44;
    private int num_items = 0;
    private Map values = new Hashtable(5);
    private List genericValues = new LinkedList();
    private String headerName = null;

    public HeaderHandler(HeaderStorage headerStorage, char c, String string) {
        this.headerName = string;
        this.mySep = c;
        int n = headerStorage.getNumberOfHeaderInstances(string);
        for (int i = 0; i < n; ++i) {
            this.parse(headerStorage.getHeaderAsString(string, i));
        }
    }

    public HeaderHandler(HeaderStorage headerStorage, char c, HeaderKeys headerKeys) {
        this.headerName = headerKeys.getName();
        this.mySep = c;
        int n = headerStorage.getNumberOfHeaderInstances(headerKeys);
        for (int i = 0; i < n; ++i) {
            this.parse(headerStorage.getHeaderAsString(headerKeys, i));
        }
    }

    private void addElement(String string) {
        if (null == string) {
            return;
        }
        ++this.num_items;
        this.genericValues.add(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addElement: " + string + " num: " + this.num_items);
        }
    }

    private void addElement(String string, String string2) {
        ++this.num_items;
        LinkedList<String> linkedList = (LinkedList<String>)this.values.get(string);
        if (null == linkedList) {
            linkedList = new LinkedList<String>();
        }
        if (null == string2) {
            linkedList.add("\"\"");
        } else {
            linkedList.add(string2);
        }
        this.values.put(string, linkedList);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "addElement: " + string + "=" + string2 + " num: " + this.num_items);
        }
    }

    private void parse(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length - 1;
        block0: while (n < cArray.length) {
            if (this.mySep == cArray[n]) {
                ++n;
                continue;
            }
            int n3 = n;
            String string2 = null;
            boolean bl = false;
            while (n3 < cArray.length) {
                boolean bl2 = false;
                if ('\"' == cArray[n3]) {
                    bl = !bl;
                } else if (this.mySep == cArray[n3]) {
                    bl2 = true;
                    --n3;
                } else if ('=' == cArray[n3]) {
                    string2 = this.extractString(cArray, n, n3 - 1);
                    n = ++n3;
                    continue;
                }
                if (n3 == n2) {
                    bl2 = true;
                }
                if (bl2) {
                    String string3 = this.extractString(cArray, n, n3);
                    if (null == string2) {
                        this.addElement(string3);
                    } else {
                        this.addElement(string2, string3);
                    }
                    n = n3 += 2;
                    if (bl) continue;
                    continue block0;
                }
                ++n3;
            }
        }
    }

    private String extractString(char[] cArray, int n, int n2) {
        while (n < n2 && (' ' == cArray[n] || '\t' == cArray[n] || '\"' == cArray[n])) {
            ++n;
        }
        while (n2 >= n && (' ' == cArray[n2] || '\t' == cArray[n2] || '\"' == cArray[n2])) {
            --n2;
        }
        if (n2 < n) {
            return null;
        }
        int n3 = n2 - n + 1;
        String string = Normalizer.normalize(new String(cArray, n, n3), 2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "extractString: [" + string + "]");
        }
        return string;
    }

    public boolean add(String string) {
        String string2 = Normalizer.normalize(string, 2);
        if (!this.contains(this.genericValues, string2)) {
            this.addElement(string2);
            return true;
        }
        return false;
    }

    public boolean add(String string, String string2) {
        String string3 = Normalizer.normalize(string, 2);
        String string4 = Normalizer.normalize(string2, 2);
        if (!this.contains((List)this.values.get(string3), string4)) {
            this.addElement(string3, string4);
            return true;
        }
        return false;
    }

    private boolean remove(List list, String string) {
        if (null != list && list.remove(string)) {
            --this.num_items;
            return true;
        }
        return false;
    }

    public boolean remove(String string, String string2) {
        String string3 = Normalizer.normalize(string, 2);
        String string4 = Normalizer.normalize(string2, 2);
        boolean bl = this.remove((List)this.values.get(string3), string4);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "remove: " + string3 + "=" + string4 + " rc=" + bl);
        }
        return bl;
    }

    public boolean remove(String string) {
        String string2 = Normalizer.normalize(string, 2);
        boolean bl = this.remove(this.genericValues, string2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "remove: " + string2 + " rc=" + bl);
        }
        return bl;
    }

    public int removeKey(String string) {
        String string2 = Normalizer.normalize(string, 2);
        int n = 0;
        List list = (List)this.values.remove(string2);
        if (null != list) {
            n = list.size();
        }
        this.num_items -= n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeKey: key=" + string2 + " " + n);
        }
        return n;
    }

    private boolean contains(List list, String string) {
        return null == list ? false : list.contains(string);
    }

    public boolean contains(String string) {
        String string2 = Normalizer.normalize(string, 2);
        boolean bl = this.contains(this.genericValues, string2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "contains: value [" + string + "] rc=" + bl);
        }
        return bl;
    }

    public boolean containsKey(String string) {
        boolean bl;
        String string2 = Normalizer.normalize(string, 2);
        List list = (List)this.values.get(string2);
        boolean bl2 = null == list ? false : (bl = !list.isEmpty());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "containsKey: key=" + string + " rc=" + bl);
        }
        return bl;
    }

    public boolean contains(String string, String string2) {
        String string3 = Normalizer.normalize(string, 2);
        String string4 = Normalizer.normalize(string2, 2);
        boolean bl = this.contains((List)this.values.get(string3), string4);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "contains: " + string + "=" + string2 + " rc=" + bl);
        }
        return bl;
    }

    public Iterator getValues() {
        return this.genericValues.iterator();
    }

    public Iterator getValues(String string) {
        String string2 = Normalizer.normalize(string, 2);
        List list = (List)this.values.get(string2);
        if (null != list) {
            return list.iterator();
        }
        return new LinkedList().iterator();
    }

    public String marshall() {
        if (0 == this.num_items) {
            return "";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(10 * this.num_items);
        Iterator<Object> iterator = this.genericValues.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuilder.append(this.mySep);
                stringBuilder.append(' ');
            }
            stringBuilder.append(iterator.next());
            bl = true;
        }
        iterator = this.values.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)this.values.get(string);
            int n = null == list ? 0 : list.size();
            if (0 == n) continue;
            if (bl) {
                stringBuilder.append(this.mySep);
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            stringBuilder.append('=');
            if (1 == n) {
                stringBuilder.append(list.get(0));
            } else {
                bl = false;
                stringBuilder.append('\"');
                for (int i = 0; i < n; ++i) {
                    if (bl) {
                        stringBuilder.append(this.mySep);
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(list.get(i));
                    bl = true;
                }
                stringBuilder.append('\"');
            }
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "marshalling [" + stringBuilder.toString() + "]");
        }
        return stringBuilder.toString();
    }

    public int numValues() {
        return this.num_items;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing this header handler: " + this);
        }
        this.num_items = 0;
        this.values.clear();
        this.genericValues.clear();
    }

    public String toString() {
        return super.toString() + "; num items=" + this.numValues();
    }
}

