/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class GenericUtils {
    private static final TraceComponent tc = Tr.register(GenericUtils.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final byte ZERO = 48;
    private static final byte DASH = 45;
    private static final byte[] ZERO_BYTEARRAY = new byte[]{48};
    private static final int SIZE_MAXINT = 10;
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final String PASSWORD_PATTERN = "password=";

    private GenericUtils() {
    }

    public static WsByteBuffer[] putByte(WsByteBuffer[] wsByteBufferArray, byte by, BNFHeadersImpl bNFHeadersImpl) {
        if (null == wsByteBufferArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Null buffers sent to putByte");
            }
            return null;
        }
        WsByteBuffer wsByteBuffer = wsByteBufferArray[wsByteBufferArray.length - 1];
        try {
            wsByteBuffer.put(by);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "putByte overflow: " + wsByteBuffer);
            }
            wsByteBuffer.flip();
            wsByteBuffer = bNFHeadersImpl.allocateBuffer(bNFHeadersImpl.getOutgoingBufferSize());
            wsByteBuffer.put(by);
            wsByteBufferArray = WsByteBufferUtils.expandBufferArray(wsByteBufferArray, wsByteBuffer);
        }
        return wsByteBufferArray;
    }

    public static WsByteBuffer[] putInt(WsByteBuffer[] wsByteBufferArray, int n, BNFHeadersImpl bNFHeadersImpl) {
        if (null == wsByteBufferArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Null buffers sent to putInt");
            }
            return null;
        }
        WsByteBuffer wsByteBuffer = wsByteBufferArray[wsByteBufferArray.length - 1];
        byte[] byArray = GenericUtils.asBytes(n);
        try {
            wsByteBuffer.put(byArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            wsByteBufferArray = GenericUtils.putByteArrayKnownOverflow(wsByteBufferArray, byArray, bNFHeadersImpl);
        }
        return wsByteBufferArray;
    }

    public static WsByteBuffer[] putByteArray(WsByteBuffer[] wsByteBufferArray, byte[] byArray, BNFHeadersImpl bNFHeadersImpl) {
        return GenericUtils.putByteArray(wsByteBufferArray, byArray, 0, byArray.length, bNFHeadersImpl);
    }

    public static WsByteBuffer[] putByteArray(WsByteBuffer[] wsByteBufferArray, byte[] byArray, int n, int n2, BNFHeadersImpl bNFHeadersImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (null == wsByteBufferArray) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null buffers sent to putByteArray");
                }
                return null;
            }
            if (null == byArray || 0 == byArray.length) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Empty value provided to putByteArray: " + byArray);
                }
                return wsByteBufferArray;
            }
        }
        WsByteBuffer wsByteBuffer = wsByteBufferArray[wsByteBufferArray.length - 1];
        try {
            wsByteBuffer.put(byArray, n, n2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "putByteArray overflow: " + wsByteBuffer);
            }
            int n3 = wsByteBuffer.capacity() - wsByteBuffer.position();
            wsByteBuffer.put(byArray, n, n3);
            wsByteBuffer.flip();
            int n4 = n2 - (n += n3);
            int n5 = n4 / bNFHeadersImpl.getOutgoingBufferSize();
            if (0 != n4 % bNFHeadersImpl.getOutgoingBufferSize()) {
                ++n5;
            }
            WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[n5];
            for (int i = 0; i < n5; ++i) {
                wsByteBufferArray2[i] = bNFHeadersImpl.allocateBuffer(bNFHeadersImpl.getOutgoingBufferSize());
                n3 = wsByteBufferArray2[i].capacity();
                if (n4 <= n3) {
                    wsByteBufferArray2[i].put(byArray, n, n4);
                    break;
                }
                wsByteBufferArray2[i].put(byArray, n, n3);
                wsByteBufferArray2[i].flip();
                n += n3;
                n4 -= n3;
            }
            wsByteBufferArray = WsByteBufferUtils.expandBufferArray(wsByteBufferArray, wsByteBufferArray2);
        }
        return wsByteBufferArray;
    }

    private static WsByteBuffer[] putByteArrayKnownOverflow(WsByteBuffer[] wsByteBufferArray, byte[] byArray, BNFHeadersImpl bNFHeadersImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Known buffer overflow in put.");
        }
        boolean bl = false;
        int n = byArray.length;
        int n2 = 0;
        WsByteBuffer wsByteBuffer = wsByteBufferArray[wsByteBufferArray.length - 1];
        int n3 = wsByteBuffer.capacity() - wsByteBuffer.position();
        while (!bl) {
            if (n <= n3) {
                wsByteBuffer.put(byArray, n2, n);
                bl = true;
                continue;
            }
            wsByteBuffer.put(byArray, n2, n3);
            wsByteBuffer.flip();
            n2 += n3;
            n -= n3;
            wsByteBuffer = bNFHeadersImpl.allocateBuffer(bNFHeadersImpl.getOutgoingBufferSize());
            wsByteBufferArray = WsByteBufferUtils.expandBufferArray(wsByteBufferArray, wsByteBuffer);
            n3 = wsByteBuffer.capacity();
        }
        return wsByteBufferArray;
    }

    public static int getBytes(WsByteBuffer wsByteBuffer, byte[] byArray, int n) {
        try {
            wsByteBuffer.get(byArray, n, byArray.length - n);
            return byArray.length;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            int n2 = wsByteBuffer.remaining();
            wsByteBuffer.get(byArray, n, n2);
            return n + n2;
        }
    }

    public static int asInt(byte[] byArray) {
        if (null == byArray || 4 != byArray.length) {
            throw new IllegalArgumentException("Length of the byte array should be 4");
        }
        return (byArray[0] << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
    }

    public static int asIntValue(byte[] byArray) {
        return GenericUtils.asIntValue(byArray, 0, byArray.length);
    }

    public static int asIntValue(byte[] byArray, int n, int n2) {
        char c;
        int n3;
        if (null == byArray || byArray.length <= n) {
            return -1;
        }
        int n4 = 0;
        int n5 = 1;
        for (n3 = n + n2 - 1; n <= n3 && (' ' == (c = (char)byArray[n3]) || '\t' == c); --n3) {
        }
        while (n <= n3) {
            int n6 = byArray[n3] - 48;
            if (0 > n6 || 9 < n6) {
                if (45 == byArray[n3]) break;
                throw new NumberFormatException("Invalid digit: " + byArray[n3]);
            }
            n4 += n6 * n5;
            n5 *= 10;
            --n3;
        }
        if (n <= n3 && byArray[n3] == 45) {
            n4 = -n4;
        }
        return n4;
    }

    public static byte[] asByteArray(int n) {
        int n2;
        if (0 == n) {
            return ZERO_BYTEARRAY;
        }
        byte[] byArray = new byte[10];
        boolean bl = false;
        if (0 > n) {
            bl = true;
            n = -n;
        }
        for (n2 = 9; 0 <= n2 && 0 != n; n /= 10, --n2) {
            byArray[n2] = HEX_BYTES[n % 10];
        }
        int n3 = 9 - n2;
        if (bl) {
            ++n3;
        }
        byte[] byArray2 = new byte[n3];
        int n4 = n3 - 1;
        int n5 = 9;
        while (0 <= n4) {
            byArray2[n4] = byArray[n5];
            --n4;
            --n5;
        }
        if (bl) {
            byArray2[0] = 45;
        }
        return byArray2;
    }

    public static byte[] asBytes(int n) {
        if (0 > n) {
            throw new IllegalArgumentException("value cannot be less than zero");
        }
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static String getEnglishString(WsByteBuffer[] wsByteBufferArray) {
        int n;
        if (null == wsByteBufferArray) {
            return null;
        }
        int n2 = 0;
        for (n = 0; n < wsByteBufferArray.length && null != wsByteBufferArray[n]; ++n) {
            n2 += wsByteBufferArray[n].remaining();
        }
        if (0 == n2) {
            return null;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = wsByteBufferArray[i].remaining();
            wsByteBufferArray[i].get(byArray, n3, n2);
            n3 += n2;
            wsByteBufferArray[i].position(0);
        }
        return GenericUtils.getEnglishString(byArray);
    }

    public static String asLowerCaseString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            cArray[i] = 'A' <= cArray[i] && 'Z' >= cArray[i] ? (char)(c + 32) : c;
        }
        return new String(cArray);
    }

    public static void dumpArrayToTraceLog(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "[ ");
            if (null == byArray) {
                Tr.debug(tc, "null");
            } else {
                for (int i = 0; i < byArray.length; ++i) {
                    Tr.debug(tc, byArray[i] + " ");
                }
            }
            Tr.debug(tc, "]");
        }
    }

    public static int byteIndexOf(byte[] byArray, byte by, int n) {
        int n2 = -1;
        for (int i = n; i < byArray.length; ++i) {
            if (by != byArray[i]) continue;
            n2 = i;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "byteIndexOf returning [" + n2 + "]");
        }
        return n2;
    }

    public static int byteIndexOf(byte[] byArray, byte by, int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        for (int i = n; i < byArray.length && n4 < n2; ++i, ++n4) {
            if (by != byArray[i]) continue;
            n3 = i;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "byteIndexOf returning [" + n3 + "]");
        }
        return n3;
    }

    public static byte[] byteSubstring(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        if (0 > n || n > byArray.length || n > n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid start position in byteSubstring: " + n);
            }
        } else if (0 > n2 || n2 > byArray.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid end position in byteSubstring: " + n2);
            }
        } else {
            int n3 = n2 - n;
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n3);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "byteSubstring returning: [" + GenericUtils.getEnglishString(byArray2) + "]");
        }
        return byArray2;
    }

    public static byte[] expandByteArray(byte[] byArray, byte[] byArray2) {
        int n = null != byArray ? byArray.length : 0;
        int n2 = null != byArray2 ? byArray2.length : 0;
        return GenericUtils.expandByteArray(byArray, byArray2, 0, n, 0, n2);
    }

    public static byte[] expandByteArray(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        int n5;
        byte[] byArray3 = null;
        if (null == byArray) {
            n2 = 0;
        }
        if (null == byArray2) {
            n4 = 0;
        }
        if (0 < (n5 = n2 + n4)) {
            byArray3 = new byte[n5];
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Created byte[] of size " + n5);
            }
            try {
                if (null != byArray) {
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                }
                if (null != byArray2) {
                    System.arraycopy(byArray2, n3, byArray3, n2, n4);
                }
            }
            catch (Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception " + exception + " while copying.");
                }
                byArray3 = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "expandByteArray returning: [" + GenericUtils.getEnglishString(byArray3) + "]");
        }
        return byArray3;
    }

    public static byte[] expandByteArray(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray3 = null;
        int n5 = n4 = null != byArray ? byArray.length : 0;
        if (null == byArray2) {
            n2 = 0;
        }
        if (0 < (n3 = n4 + n2)) {
            byArray3 = new byte[n3];
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Created byte[] of size " + n3);
            }
            try {
                if (null != byArray) {
                    System.arraycopy(byArray, 0, byArray3, 0, n4);
                }
                if (null != byArray2) {
                    System.arraycopy(byArray2, n, byArray3, n4, n2);
                }
            }
            catch (Exception exception) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception " + exception + " while copying.");
                }
                byArray3 = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "expandByteArray returning: [" + GenericUtils.getEnglishString(byArray3) + "]");
        }
        return byArray3;
    }

    public static byte[] expandByteArray(byte[] byArray, byte by) {
        int n = null != byArray ? byArray.length : 0;
        int n2 = n + 1;
        byte[] byArray2 = new byte[n2];
        try {
            if (null != byArray) {
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
            byArray2[n] = by;
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception " + exception + " while copying.");
            }
            byArray2 = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "expandByteArray returning: [" + GenericUtils.getEnglishString(byArray2) + "]");
        }
        return byArray2;
    }

    public static byte[] getBytes(StringBuffer stringBuffer) {
        if (null == stringBuffer) {
            return null;
        }
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static byte[] getBytes(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            return null;
        }
        int n = stringBuilder.length();
        char[] cArray = new char[n];
        stringBuilder.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static byte[] getBytes(String string) {
        if (null != string) {
            char[] cArray = string.toCharArray();
            byte[] byArray = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i] = (byte)cArray[i];
            }
            return byArray;
        }
        return null;
    }

    public static byte[] getEnglishBytes(String string) {
        return GenericUtils.getBytes(string);
    }

    public static String getEnglishString(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    private static char convertHex(int n) {
        return (char)HEX_BYTES[n & 0xF];
    }

    private static StringBuilder formatLineId(StringBuilder stringBuilder, int n) {
        char[] cArray = new char[4];
        for (int i = 3; i >= 0; --i) {
            cArray[i] = (char)HEX_BYTES[n % 16 & 0xF];
            n >>= 4;
        }
        return stringBuilder.append(cArray);
    }

    private static StringBuilder formatHexData(StringBuilder stringBuilder, byte[] byArray, int n) {
        int n2 = n + 8;
        if (n >= byArray.length) {
            stringBuilder.append("                       ");
            return stringBuilder;
        }
        stringBuilder.append(GenericUtils.convertHex((0xFF & byArray[n]) / 16));
        stringBuilder.append(GenericUtils.convertHex((0xFF & byArray[n]) % 16));
        ++n;
        while (n < n2) {
            if (n >= byArray.length) {
                stringBuilder.append("   ");
            } else {
                stringBuilder.append(' ');
                stringBuilder.append(GenericUtils.convertHex((0xFF & byArray[n]) / 16));
                stringBuilder.append(GenericUtils.convertHex((0xFF & byArray[n]) % 16));
            }
            ++n;
        }
        return stringBuilder;
    }

    private static StringBuilder formatTextData(StringBuilder stringBuilder, byte[] byArray, int n) {
        int n2 = n + 16;
        while (n < n2) {
            if (n >= byArray.length) {
                stringBuilder.append(" ");
            } else if (Character.isLetterOrDigit(byArray[n])) {
                stringBuilder.append((char)byArray[n]);
            } else {
                stringBuilder.append('.');
            }
            ++n;
        }
        return stringBuilder;
    }

    public static String getHexDump(byte[] byArray) {
        return null == byArray ? null : GenericUtils.getHexDump(byArray, byArray.length);
    }

    public static String getHexDump(byte[] byArray, int n) {
        if (null == byArray || 0 > n) {
            return null;
        }
        if (byArray.length < n) {
            n = byArray.length;
        }
        int n2 = n / 16 + (n % 16 > 0 ? 1 : 0);
        StringBuilder stringBuilder = new StringBuilder(73 * n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            stringBuilder = GenericUtils.formatLineId(stringBuilder, n3);
            stringBuilder.append(": ");
            stringBuilder = GenericUtils.formatHexData(stringBuilder, byArray, n3);
            stringBuilder.append("  ");
            stringBuilder = GenericUtils.formatHexData(stringBuilder, byArray, n3 + 8);
            stringBuilder.append("  ");
            stringBuilder = GenericUtils.formatTextData(stringBuilder, byArray, n3);
            stringBuilder.append('\n');
            ++n4;
            n3 += 16;
        }
        return stringBuilder.toString();
    }

    public static String getEnglishString(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (null == byArray || 0 > n3) {
            return null;
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            cArray[n4] = (char)(byArray[i] & 0xFF);
            ++n4;
        }
        return new String(cArray);
    }

    public static Vector byteArrayTokenize(byte[] byArray, byte by) {
        Vector<byte[]> vector = new Vector<byte[]>();
        if (null == byArray || 0 == byArray.length) {
            return vector;
        }
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (32 == byArray[i] || by == byArray[i]) {
                if (0 < n2) {
                    byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    vector.add(byArray2);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Parsed out token: [" + GenericUtils.getEnglishString(byArray2) + "]");
                    }
                }
                n2 = 0;
                n = i + 1;
                continue;
            }
            ++n2;
        }
        if (0 < n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            vector.add(byArray2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsed out token: [" + GenericUtils.getEnglishString(byArray2) + "]");
            }
        }
        return vector;
    }

    public static List byteArrayTokenize(byte[] byArray, byte[] byArray2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "byteArrayTokenize: " + byArray + " " + byArray2);
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (null == byArray || null == byArray2 || 0 == byArray.length || 0 == byArray2.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "byteArrayTokenize: " + arrayList.size());
            }
            return arrayList;
        }
        byte[] byArray3 = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < byArray2.length && !bl; ++j) {
                if (byArray2[j] != byArray[i]) continue;
                bl = true;
                if (0 < n2) {
                    byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    arrayList.add(byArray3);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Parsed out token: [" + GenericUtils.getEnglishString(byArray3) + "]");
                    }
                }
                n2 = 0;
                n = i + 1;
            }
            if (bl) continue;
            ++n2;
        }
        if (0 < n2) {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            arrayList.add(byArray3);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsed out token: [" + GenericUtils.getEnglishString(byArray3) + "]");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "byteArrayTokenize: " + arrayList.size());
        }
        return arrayList;
    }

    public static int skipToChar(byte[] byArray, int n, byte by) {
        int n2;
        for (n2 = n; n2 < byArray.length && by != byArray[n2]; ++n2) {
        }
        return n2;
    }

    public static int skipToChars(byte[] byArray, int n, byte[] byArray2) {
        int n2;
        int n3 = 0;
        for (n2 = n; n2 < byArray.length; ++n2) {
            byte by = byArray[n2];
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                if (by != byArray2[n3]) continue;
                return n2;
            }
        }
        return n2;
    }

    public static int skipWhiteSpace(byte[] byArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < byArray.length && 32 == byArray[n2]; ++n2) {
        }
        return n2;
    }

    public static byte reverseCase(byte by) {
        by = (byte)(by + (65 <= by && 90 >= by ? 32 : -32));
        return by;
    }

    public static char reverseCase(char c) {
        c = (char)(c + ('A' <= c && 'Z' >= c ? 32 : -32));
        return c;
    }

    public static int sizeOf(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (null == wsByteBufferArray[i]) continue;
            n += wsByteBufferArray[i].remaining();
        }
        return n;
    }

    public static byte[] readValue(ObjectInput objectInput, int n) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = objectInput.read(byArray, i, n - i);
            if (n2 != -1) continue;
            throw new IOException("Could not retrieve ");
        }
        return byArray;
    }

    public static String nullOutPasswords(byte[] byArray, byte by) {
        return GenericUtils.nullOutPasswords(GenericUtils.getEnglishString(byArray), by);
    }

    public static String nullOutPasswords(String string, byte by) {
        boolean bl = false;
        String string2 = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.indexOf(PASSWORD_PATTERN);
        while (-1 != n) {
            bl = true;
            n += PASSWORD_PATTERN.length();
            while (n < string2.length() && by != string2.charAt(n)) {
                stringBuffer.setCharAt(n, '*');
                ++n;
            }
            if (n == string2.length()) {
                n = -1;
                continue;
            }
            n = string2.indexOf(PASSWORD_PATTERN, n);
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static String blockContents(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 42;
        }
        return new String(cArray);
    }

    public static String blockContents(String string) {
        if (null == string) {
            return null;
        }
        char[] cArray = new char[string.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 42;
        }
        return new String(cArray);
    }
}

