/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.QuickHeaderMatcher;
import com.ibm.ws.genericbnf.impl.TokenCodes;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.GenericMessage;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class GenericMessageImpl
extends BNFHeadersImpl
implements GenericMessage {
    private static final TraceComponent tc = Tr.register(GenericMessageImpl.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final long serialVersionUID = 2516122741254647791L;
    private transient boolean completedFirstLine = false;
    private transient int numFirstLineTokensRead = 0;
    private transient boolean firstLineChanged = false;

    protected GenericMessageImpl(QuickHeaderMatcher quickHeaderMatcher, int n) {
        super(quickHeaderMatcher, n);
    }

    protected abstract void setParsedFirstToken(byte[] var1) throws Exception;

    protected abstract void setParsedSecondToken(byte[] var1) throws Exception;

    protected abstract void setParsedThirdToken(byte[] var1) throws Exception;

    protected boolean overChangeLimit() {
        return super.overHeaderChangeLimit();
    }

    protected abstract void parsingComplete() throws MalformedMessageException;

    protected abstract byte[] getMarshalledFirstToken();

    protected abstract byte[] getMarshalledSecondToken();

    protected abstract byte[] getMarshalledThirdToken();

    protected void setFirstLineComplete(boolean bl) {
        this.completedFirstLine = bl;
        if (bl) {
            this.firstLineChanged = false;
        }
    }

    protected final boolean isFirstLineComplete() {
        return this.completedFirstLine;
    }

    protected void setFirstLineChanged() {
        this.firstLineChanged = true;
    }

    protected boolean hasFirstLineChanged() {
        return this.firstLineChanged || super.overHeaderChangeLimit();
    }

    protected final int getNumberFirstLineTokens() {
        return this.numFirstLineTokensRead;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseLine(WsByteBuffer var1_1) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && GenericMessageImpl.tc.isDebugEnabled()) {
            Tr.debug(GenericMessageImpl.tc, "parseLine called for " + this);
        }
        var2_2 = false;
        var3_3 = TraceComponent.isAnyTracingEnabled() != false && GenericMessageImpl.tc.isDebugEnabled() != false ? var1_1.position() : 0;
        var4_4 = TokenCodes.TOKEN_RC_MOREDATA;
        while (!var2_2) {
            if (0 == this.getNumberFirstLineTokens()) {
                var4_4 = this.skipCRLFs(var1_1);
                if (TokenCodes.TOKEN_RC_DELIM.equals(var4_4)) {
                    try {
                        var4_4 = this.parseTokenExtract(var1_1, (byte)32, false, 0);
                        if (var4_4.equals(TokenCodes.TOKEN_RC_MOREDATA)) ** GOTO lbl53
                        this.setParsedFirstToken(this.getParsedToken());
                    }
                    catch (MalformedMessageException var5_5) {
                        if (TraceComponent.isAnyTracingEnabled() && GenericMessageImpl.tc.isDebugEnabled()) {
                            var6_6 = var1_1.position();
                            var1_1.position(var3_3);
                            var8_7 = 0;
                            if (null != this.getParsedToken()) {
                                var8_7 = this.getParsedToken().length;
                                var7_8 = new byte[var6_6 - var3_3 + var8_7];
                                System.arraycopy(this.getParsedToken(), 0, var7_8, 0, var8_7);
                            } else {
                                var7_8 = new byte[var6_6 - var3_3];
                            }
                            var1_1.get(var7_8, var8_7, var7_8.length - var8_7);
                            Tr.debug(GenericMessageImpl.tc, "Initial parse of message failed, (128) of buffer: \n" + GenericUtils.getHexDump(var7_8, 128));
                        }
                        throw var5_5;
                    }
                } else {
                    if (TokenCodes.TOKEN_RC_MOREDATA.equals(var4_4)) {
                        this.resetByteCache();
                        break;
                    }
                    if (TokenCodes.TOKEN_RC_CRLF.equals(var4_4)) {
                        throw new MalformedMessageException("Too many leading CRLFs");
                    }
                }
            } else if (1 == this.getNumberFirstLineTokens()) {
                var4_4 = this.parseTokenExtract(var1_1, (byte)32, true, 2);
                if (!var4_4.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                    this.setParsedSecondToken(this.getParsedToken());
                    if (var4_4.equals(TokenCodes.TOKEN_RC_CRLF)) {
                        if (TraceComponent.isAnyTracingEnabled() && GenericMessageImpl.tc.isDebugEnabled()) {
                            Tr.debug(GenericMessageImpl.tc, "Received CRLF after second token");
                        }
                        var2_2 = true;
                    }
                }
            } else if (2 == this.getNumberFirstLineTokens()) {
                var4_4 = this.parseCRLFTokenExtract(var1_1, 0);
                if (!var4_4.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                    this.setParsedThirdToken(this.getParsedToken());
                    var2_2 = true;
                }
            } else {
                var2_2 = true;
            }
lbl53:
            // 6 sources

            if (var4_4.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
                this.resetByteCache();
                break;
            }
            this.setParsedToken(null);
            ++this.numFirstLineTokensRead;
        }
        if (var2_2) {
            this.parsingComplete();
            this.setFirstLineComplete(true);
            this.decrementBytePositionIgnoringLFs();
        }
        if (TraceComponent.isAnyTracingEnabled() && GenericMessageImpl.tc.isDebugEnabled()) {
            Tr.debug(GenericMessageImpl.tc, "parseLine returning " + var2_2 + " for " + this);
        }
        return var2_2;
    }

    public WsByteBuffer[] marshallLine() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallLine");
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        wsByteBufferArray = this.putBytes(this.getMarshalledFirstToken(), wsByteBufferArray);
        wsByteBufferArray = this.putByte((byte)32, wsByteBufferArray);
        wsByteBufferArray = this.putBytes(this.getMarshalledSecondToken(), wsByteBufferArray);
        wsByteBufferArray = this.putByte((byte)32, wsByteBufferArray);
        wsByteBufferArray = this.putBytes(this.getMarshalledThirdToken(), wsByteBufferArray);
        wsByteBufferArray = this.putBytes(BNFHeaders.EOL, wsByteBufferArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallLine");
        }
        return wsByteBufferArray;
    }

    public boolean parseMessage(WsByteBuffer wsByteBuffer, boolean bl) throws Exception {
        boolean bl2 = false;
        if (!this.isFirstLineComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing First Line");
            }
            bl2 = this.parseLine(wsByteBuffer);
        }
        if (this.isFirstLineComplete()) {
            bl2 = this.parseHeaders(wsByteBuffer, bl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseMessage returning " + bl2);
        }
        return bl2;
    }

    public WsByteBuffer[] marshallMessage() throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallMessage");
        }
        this.preMarshallMessage();
        WsByteBuffer[] wsByteBufferArray = this.hasFirstLineChanged() ? this.marshallLine() : null;
        this.headerComplianceCheck();
        wsByteBufferArray = this.marshallHeaders(wsByteBufferArray);
        this.postMarshallMessage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallMessage");
        }
        return wsByteBufferArray;
    }

    protected abstract void headerComplianceCheck() throws MessageSentException;

    protected void preMarshallMessage() throws MessageSentException {
        super.resetByteCache();
    }

    protected void postMarshallMessage() {
    }

    public void clear() {
        super.clear();
        this.completedFirstLine = false;
        this.numFirstLineTokensRead = 0;
        this.firstLineChanged = false;
    }

    protected void destroy() {
        super.destroy();
    }

    public void debug() {
        super.debug();
    }

    public void duplicate(GenericMessageImpl genericMessageImpl) {
        if (null == genericMessageImpl) {
            throw new NullPointerException("Null message passed to duplicate");
        }
        super.duplicate(genericMessageImpl);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }
}

