/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeyReferenceVersionComparator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class WSKeySet {
    private static final WebSphereRuntimePermission GET_KEYPASSWORD = new WebSphereRuntimePermission("GetKeyPassword");
    private static final TraceComponent tc = Tr.register(WSKeySet.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private String name = null;
    private String aliasPrefix = null;
    private String password = null;
    private int maxKeyReferences = 3;
    private boolean deleteOldKeys = false;
    private boolean isKeyPair = false;
    private String keyGenerationClass = null;
    private String keyStoreName = null;
    private WSKeyStore keyStore = null;
    private String scope = ManagementScopeManager.getInstance().getCellScopeName();
    private Properties additionalProps = null;
    private TreeSet keyReferenceSet = new TreeSet(new WSKeyReferenceVersionComparator());

    public WSKeySet(KeySet keySet, KeyStore keyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySet");
        }
        this.name = keySet.getName();
        this.aliasPrefix = keySet.getAliasPrefix();
        this.password = keySet.getPassword();
        this.maxKeyReferences = keySet.getMaxKeyReferences();
        this.deleteOldKeys = keySet.isDeleteOldKeys();
        this.isKeyPair = keySet.isIsKeyPair();
        this.keyGenerationClass = keySet.getKeyGenerationClass();
        this.keyStoreName = keySet.getKeyStore().getName();
        this.keyStore = new WSKeyStore(keyStore);
        this.scope = keySet.getManagementScope().getScopeName();
        this.additionalProps = this.getProperties(keySet.getAdditionalKeySetAttrs());
        this.convertToWSKeyReferences(keySet.getKeyReference(), this.keyStore);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySet", new Object[]{this.toString()});
        }
    }

    public WSKeySet(KeySet keySet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySet");
        }
        this.name = keySet.getName();
        this.aliasPrefix = keySet.getAliasPrefix();
        this.password = keySet.getPassword();
        this.maxKeyReferences = keySet.getMaxKeyReferences();
        this.deleteOldKeys = keySet.isDeleteOldKeys();
        this.isKeyPair = keySet.isIsKeyPair();
        this.keyGenerationClass = keySet.getKeyGenerationClass();
        this.keyStoreName = keySet.getKeyStore().getName();
        this.keyStore = KeyStoreManager.getInstance().getKeyStore(this.keyStoreName);
        this.scope = keySet.getManagementScope().getScopeName();
        this.additionalProps = this.getProperties(keySet.getAdditionalKeySetAttrs());
        this.convertToWSKeyReferences(keySet.getKeyReference(), this.keyStore);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySet", new Object[]{this.toString()});
        }
    }

    private void convertToWSKeyReferences(List list, WSKeyStore wSKeyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToKeyReferences");
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                KeyReference keyReference;
                com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference2 = (com.ibm.websphere.models.config.ipc.ssl.KeyReference)list.get(i);
                if (this.isKeyPair) {
                    keyReference = new WSKeyPairReference(keyReference2, this, wSKeyStore);
                    this.keyReferenceSet.add(keyReference);
                    continue;
                }
                keyReference = new WSKeyReference(keyReference2, this, wSKeyStore);
                this.keyReferenceSet.add(keyReference);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToKeyReferences");
        }
    }

    public void addKeyReference(KeyReference keyReference) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKeyReference", new Object[]{keyReference});
        }
        this.keyReferenceSet.add(keyReference);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKeyReference");
        }
    }

    public Object getLatestKey() throws KeyException {
        KeyReference keyReference;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKey");
        }
        if ((keyReference = this.getLatestKeyReference()) instanceof WSKeyReference) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLatestKey (key)");
            }
            return ((WSKeyReference)keyReference).getKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKey (key pair)");
        }
        return ((WSKeyPairReference)keyReference).getKeyPair();
    }

    public KeyReference getLatestKeyReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyReference");
        }
        KeyReference keyReference = null;
        if (this.keyReferenceSet.size() > 0) {
            keyReference = (KeyReference)this.keyReferenceSet.last();
        }
        int n = -1;
        if (keyReference != null) {
            n = keyReference.getVersion();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeyReference -> " + n);
        }
        return keyReference;
    }

    public KeyReference getOldestKeyReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOldestKeyReference");
        }
        KeyReference keyReference = null;
        if (this.keyReferenceSet.size() > 0) {
            keyReference = (KeyReference)this.keyReferenceSet.first();
        }
        int n = -1;
        if (keyReference != null) {
            n = keyReference.getVersion();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOldestKeyReference -> " + n);
        }
        return keyReference;
    }

    public void removeOldestReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeOldestReference");
        }
        KeyReference keyReference = null;
        if (this.keyReferenceSet.size() > 0) {
            keyReference = (KeyReference)this.keyReferenceSet.first();
            this.keyReferenceSet.remove(keyReference);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeOldestReference -> " + keyReference.getVersion());
        }
    }

    public Map getAllKeys() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeys");
        }
        KeyReference[] keyReferenceArray = this.getAllKeyReferences();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        for (int i = 0; i < keyReferenceArray.length; ++i) {
            if (keyReferenceArray[i] != null && keyReferenceArray[i] instanceof WSKeyReference) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key alias " + keyReferenceArray[i].getKeyAlias() + " of type WSKeyReference.");
                }
                hashMap.put(keyReferenceArray[i].getKeyAlias(), ((WSKeyReference)keyReferenceArray[i]).getKey());
                continue;
            }
            if (keyReferenceArray[i] == null || !(keyReferenceArray[i] instanceof WSKeyPairReference)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding key alias " + keyReferenceArray[i].getKeyAlias() + " of type WSKeyPairReference.");
            }
            hashMap.put(keyReferenceArray[i].getKeyAlias(), ((WSKeyPairReference)keyReferenceArray[i]).getKeyPair());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeys");
        }
        return hashMap;
    }

    public KeyReference[] getAllKeyReferences() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeyReferences");
        }
        KeyReference[] keyReferenceArray = this.keyReferenceSet.toArray(new KeyReference[this.keyReferenceSet.size()]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeyReferences");
        }
        return keyReferenceArray;
    }

    public TreeSet getKeyReferenceTreeSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyReferenceTreeSet");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyReferenceTreeSet");
        }
        return this.keyReferenceSet;
    }

    private Properties getProperties(List list) {
        Properties properties = new Properties();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                properties.put(property.getName(), property.getValue());
            }
        }
        return properties;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WSKeySet.toString() {\n");
        stringBuffer.append("name = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("aliasPrefix = ");
        stringBuffer.append(this.aliasPrefix);
        stringBuffer.append("\n");
        if (this.password != null && !this.password.equals("")) {
            stringBuffer.append("password = ");
            stringBuffer.append(SSLConfigManager.mask(this.password));
            stringBuffer.append("\n");
        }
        stringBuffer.append("maxKeyReferences = ");
        stringBuffer.append(this.maxKeyReferences);
        stringBuffer.append("\n");
        stringBuffer.append("deleteOldKeys = ");
        stringBuffer.append(this.deleteOldKeys);
        stringBuffer.append("\n");
        stringBuffer.append("isKeyPair = ");
        stringBuffer.append(this.isKeyPair);
        stringBuffer.append("\n");
        stringBuffer.append("keyGenerationClass = ");
        stringBuffer.append(this.keyGenerationClass);
        stringBuffer.append("\n");
        stringBuffer.append("keyStoreName = ");
        stringBuffer.append(this.keyStoreName);
        stringBuffer.append("\n");
        stringBuffer.append("scope = ");
        stringBuffer.append(this.scope);
        stringBuffer.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getAliasPrefix() {
        return this.aliasPrefix;
    }

    public String getPassword() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYPASSWORD.toString());
            }
            try {
                securityManager.checkPermission(GET_KEYPASSWORD);
            }
            catch (SecurityException securityException) {
                FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.crypto.config.WSKeySet.getPassword", "382", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Permission exception: ", new Object[]{securityException});
                }
                throw securityException;
            }
        }
        return this.password;
    }

    public int getMaxKeyReferences() {
        return this.maxKeyReferences;
    }

    public boolean getDeleteOldKeys() {
        return this.deleteOldKeys;
    }

    public boolean getIsKeyPair() {
        return this.isKeyPair;
    }

    public String getKeyGenerationClass() {
        return this.keyGenerationClass;
    }

    public String getKeyStoreName() {
        return this.keyStoreName;
    }

    public WSKeyStore getWSKeyStore() {
        return this.keyStore;
    }

    public String getManagementScopeName() {
        return this.scope;
    }

    public Properties getCustomProperties() {
        return this.additionalProps;
    }
}

