/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.crypto.KeyPairGenerator;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.crypto.spec.SecretKeySpec;

public class WSKeyPairReference
extends KeyReference {
    private static final TraceComponent tc = Tr.register(WSKeyPairReference.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private KeyPair keyPair = null;
    private KeyPairGenerator keyPairGenerationClassImpl = null;
    private String keyGenerationClass = null;
    private WSKeySet wsKeySet = null;

    public WSKeyPairReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference, WSKeySet wSKeySet, WSKeyStore wSKeyStore) {
        super(keyReference, wSKeySet, wSKeyStore);
        this.keyGenerationClass = wSKeySet.getKeyGenerationClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyPairReference");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyPairReference", new Object[]{this.toString()});
        }
    }

    public WSKeyPairReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference, KeyPair keyPair, WSKeySet wSKeySet, WSKeyStore wSKeyStore) throws KeyException {
        super(keyReference, wSKeySet, wSKeyStore);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyPairReference (with keyPair)");
        }
        try {
            this.keyGenerationClass = wSKeySet.getKeyGenerationClass();
            KeyStore keyStore = wSKeyStore.getKeyStore(false, false);
            this.importKeyPair(keyPair, keyStore);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSKeyPairReference import key initialization failed.", new Object[]{exception});
            }
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyPairReference (with keyPair)", new Object[]{this.toString()});
        }
    }

    public KeyPair getKeyPair() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyPair");
        }
        if (this.keyPair == null) {
            try {
                KeyStore keyStore = null;
                String string = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreName");
                String string2 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
                String string3 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreProvider");
                String string4 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                String string5 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                String string6 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreScope");
                keyStore = KeyStoreManager.getInstance().getKeyStore(string, string2, string3, string4, string5, string6, true, null);
                if (keyStore != null) {
                    boolean bl = false;
                    String string7 = this.getKeyAlias();
                    String string8 = this.getPassword();
                    Key key = keyStore.getKey(string7, string8.toCharArray());
                    Certificate[] certificateArray = keyStore.getCertificateChain(string7);
                    if (certificateArray != null && key != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating a KeyPair from Certificate Chain and privateKey retrieved from KeyStore.");
                        }
                        this.keyPair = new KeyPair(certificateArray, (Key)((PrivateKey)key));
                    } else {
                        String string9 = string7 + "_private";
                        Key key2 = keyStore.getKey(string9, string8.toCharArray());
                        String string10 = string7 + "_public";
                        Key key3 = keyStore.getKey(string10, string8.toCharArray());
                        if (key2 != null && key3 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating a KeyPair from publicKey and privateKey retrieved from KeyStore.");
                            }
                            this.keyPair = new KeyPair(key3, key2);
                            bl = true;
                        }
                    }
                    if (this.keyPair == null && this.isValidKeyStoreType(bl)) {
                        this.keyPair = this.initializeReferenceIfNotInKeyStore(keyStore);
                    }
                }
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception getting KeyPair from KeyStore.", new Object[]{exception});
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSKeyPairReference.getKeyPair", "156", this);
                Tr.error(tc, "crypto.key.getkey.error.CWPKI0201E", new Object[]{this.getKeySetName(), this.getKeyAlias(), exception.getMessage()});
                if (exception instanceof KeyException) {
                    throw (KeyException)exception;
                }
                throw new KeyException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyPair");
        }
        return this.keyPair;
    }

    public KeyPair initializeReferenceIfNotInKeyStore(KeyStore keyStore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeReferenceIfNotInKeyStore");
        }
        FileOutputStream fileOutputStream = null;
        try {
            if (keyStore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore type is \"" + keyStore.getType() + "\" and the provider is \"" + keyStore.getProvider() + "\".");
            }
            if (this.keyGenerationClass == null || this.keyGenerationClass.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys as auto-generation class is not specified.");
                }
                throw new KeyException("KeyPair is not present and keyGenerationClass is null.");
            }
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)this.getKeyPairGeneratorImpl();
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            if (keyPair != null) {
                Object object;
                Object object2;
                String string;
                String string2 = this.getKeyAlias();
                String string3 = this.getPassword();
                Key key = keyPair.getPrivateKey();
                Key key2 = keyPair.getPublicKey();
                Certificate[] certificateArray = keyPair.getCertificateChain();
                if (certificateArray != null && key != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting public/private key using alias: " + string2);
                    }
                    keyStore.setKeyEntry(string2, key, string3.toCharArray(), certificateArray);
                } else if (key != null && key2 != null) {
                    string = string2 + "_private";
                    object2 = new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting private key (as secret) using alias: " + string);
                    }
                    keyStore.setKeyEntry(string, (Key)object2, string3.toCharArray(), null);
                    object = string2 + "_public";
                    SecretKeySpec secretKeySpec = new SecretKeySpec(key2.getEncoded(), key2.getAlgorithm());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting public key (as secret) using alias: " + (String)object);
                    }
                    keyStore.setKeyEntry((String)object, secretKeySpec, string3.toCharArray(), null);
                    this.keyPair = new KeyPair(secretKeySpec, (Key)object2);
                }
                string = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                object2 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                fileOutputStream = new FileOutputStream(string);
                keyStore.store(fileOutputStream, ((String)object2).toCharArray());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeReferenceIfNotInKeyStore (generated)");
                }
                object = this.keyPair;
                return object;
            }
            try {
                throw new KeyException("KeyPairGenerator " + this.keyGenerationClass + " did not return a KeyPair.");
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception generating Key.", new Object[]{exception});
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSKeySet.generate", "250", this);
                Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), exception.getMessage()});
                if (exception instanceof KeyException) {
                    throw (KeyException)exception;
                }
                throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), exception.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + exception.getMessage()));
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void importKeyPair(KeyPair keyPair, KeyStore keyStore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importKeyPair");
        }
        FileOutputStream fileOutputStream = null;
        try {
            Object object;
            String string;
            if (keyStore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot update keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore type is \"" + keyStore.getType() + "\" and the provider is \"" + keyStore.getProvider() + "\".");
            }
            if (keyPair == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot updates keys as the KeyPair is not specified.");
                }
                throw new KeyException("KeyPair was not passed in.");
            }
            String string2 = this.getKeyAlias();
            String string3 = this.getPassword();
            Key key = keyPair.getPrivateKey();
            Key key2 = keyPair.getPublicKey();
            Certificate[] certificateArray = keyPair.getCertificateChain();
            if (certificateArray != null && key != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting public/private key using alias: " + string2);
                }
                keyStore.setKeyEntry(string2, key, string3.toCharArray(), certificateArray);
            } else if (key != null && key2 != null) {
                string = string2 + "_private";
                object = new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting private key (as secret) using alias: " + string);
                }
                keyStore.setKeyEntry(string, (Key)object, string3.toCharArray(), null);
                String string4 = string2 + "_public";
                SecretKeySpec secretKeySpec = new SecretKeySpec(key2.getEncoded(), key2.getAlgorithm());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting public key (as secret) using alias: " + string4);
                }
                keyStore.setKeyEntry(string4, secretKeySpec, string3.toCharArray(), null);
            }
            string = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
            object = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
            fileOutputStream = new FileOutputStream(string);
            keyStore.store(fileOutputStream, ((String)object).toCharArray());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importKeyPair (imported)");
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception updating KeyStore with keys.", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSKeyPairReference.importKeyPair", "338", this);
            Tr.error(tc, "crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), exception.getMessage()});
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), exception.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + exception.getMessage()));
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Object getKeyPairGeneratorImpl() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyGeneratorImpl");
        }
        if (this.keyPairGenerationClassImpl == null) {
            if (this.keyGenerationClass != null && !this.keyGenerationClass.equals("")) {
                Object object;
                Object var1_1;
                block11: {
                    var1_1 = null;
                    try {
                        object = Class.forName(this.keyGenerationClass);
                        var1_1 = ((Class)object).newInstance();
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Could not load using class using current class loader.");
                    }
                }
                if (var1_1 == null) {
                    object = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(this.keyGenerationClass, true, (ClassLoader)object);
                    var1_1 = clazz.newInstance();
                }
                if (var1_1 != null && var1_1 instanceof KeyPairGenerator) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Instantiating new KeyPairGenerator: " + this.keyGenerationClass);
                    }
                    this.keyPairGenerationClassImpl = var1_1;
                    if (this.getWSKeySet().getCustomProperties() != null) {
                        this.keyPairGenerationClassImpl.init(this.getWSKeySet().getCustomProperties());
                    }
                    return this.keyPairGenerationClassImpl;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getKeyGeneratorImpl is not an implementation of KeyPairGenerator.");
                }
                throw new KeyException("The custom key generator class " + this.keyGenerationClass + " is not an implementation of com.ibm.websphere.crypto.KeyPairGenerator.");
            }
            Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()});
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyGeneratorImpl");
        }
        return this.keyPairGenerationClassImpl;
    }

    private boolean isValidKeyStoreType(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidKeyStoreType");
        }
        if (this.getWSKeyStore() != null) {
            String string = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreReadOnly");
            if (string == null || string.equals("")) {
                string = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreReadOnly");
            }
            if (string != null && string.equals("true")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidKeyStoreType (readonly) -> false");
                }
                return false;
            }
            if (bl) {
                String string2 = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
                if (string2 == null || string2.equals("")) {
                    string2 = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreType");
                }
                if (string2 != null && !string2.equals("JCEKS")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isValidKeyStoreType (not jceks) -> false");
                    }
                    return false;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidKeyStoreType -> true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidKeyStoreType (null keystore) -> false");
        }
        return false;
    }
}

