/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.ws.cluster.topography.ConcernImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class SelectionDescriptionImpl
extends DescriptionA
implements SelectionDescription {
    private static final TraceComponent tc = Tr.register(SelectionDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private String[] rules = null;

    public SelectionDescriptionImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
    }

    public String getDefinitionKey() {
        return SelectionDescription.class.getName();
    }

    public void modifyRules(String[] stringArray) {
        this.rules = stringArray;
        this.updateMemento();
    }

    public void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        dataOutput.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        if (this.rules == null) {
            dataOutput.writeInt(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote rules length 0");
            }
        } else {
            dataOutput.writeInt(this.rules.length);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote rules length " + this.rules.length);
            }
            for (int i = 0; i < this.rules.length; ++i) {
                dataOutput.writeUTF(this.rules[i]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "wrote rules " + this.rules[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        MementoImpl mementoImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((mementoImpl = (MementoImpl)memento) == null) {
            mementoImpl = (MementoImpl)this.createMemento();
        }
        byte by = dataInput.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + by);
        }
        int n = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read rules length " + n);
        }
        if (n == 0) {
            MementoImpl.access$002(mementoImpl, null);
        } else {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = dataInput.readUTF();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "read rules " + stringArray[i]);
            }
            MementoImpl.access$002(mementoImpl, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoImpl;
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public String toString() {
        return "[" + Arrays.toString(this.rules) + ']';
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.7 ");
        }
    }

    public class MementoImpl
    extends DescriptionA.MementoA
    implements SelectionDescription.Memento {
        private Concern concern = new ConcernImpl(Integer.MAX_VALUE);
        private String[] m_rules = null;

        public Concern getConcern() {
            return this.concern;
        }

        public String[] getRules() {
            return this.m_rules;
        }

        public String toString() {
            return "[" + Arrays.toString(this.m_rules) + ']';
        }

        static /* synthetic */ String[] access$002(MementoImpl mementoImpl, String[] stringArray) {
            mementoImpl.m_rules = stringArray;
            return stringArray;
        }
    }
}

