/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SelectionClusterMemberDescriptionImpl
extends DescriptionA
implements SelectionClusterMemberDescription {
    private static final TraceComponent tc = Tr.register(SelectionClusterMemberDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String LOCAL_HOST = "localhost";
    private String host = "localhost";
    private Set attributes = Collections.synchronizedSet(new HashSet());
    private DescriptionKey clusterMemberAssociation = null;
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();

    public SelectionClusterMemberDescriptionImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
    }

    public String getDefinitionKey() {
        return SelectionClusterMemberDescription.class.getName();
    }

    public void setClusterMemberAssociation(DescriptionKey descriptionKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterMemberAssociation", descriptionKey);
        }
        this.clusterMemberAssociation = descriptionKey;
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterMemberAssociation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        int n = format.getType();
        SelectionClusterMemberDescription.Memento memento = null;
        if (n == 3) {
            memento = (SelectionClusterMemberDescription.Memento)this.getMemento();
        }
        Set set = this.attributes;
        DescriptionKey descriptionKey = this.clusterMemberAssociation;
        String string = this.host;
        if (memento != null) {
            set = memento.getAttributes();
            descriptionKey = memento.getClusterMemberAssociation();
            string = memento.getHost();
        }
        dataOutput.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        if (descriptionKey != null) {
            dataOutput.writeInt(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote association length = 1");
            }
            this.keyRepository.exportToStream(dataOutput, descriptionKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote clusterMemberAssociation " + descriptionKey);
            }
        } else {
            dataOutput.writeInt(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote association length = 0");
            }
        }
        dataOutput.writeUTF(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote host: " + string);
        }
        Set set2 = set;
        synchronized (set2) {
            int n2 = set.size();
            Iterator iterator = set.iterator();
            dataOutput.writeInt(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote size: " + n2);
            }
            for (int i = 0; i < n2; ++i) {
                String string2 = (String)iterator.next();
                dataOutput.writeUTF(string2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "wrote attribute " + string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        String string;
        MementoImpl mementoImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((mementoImpl = (MementoImpl)memento) == null) {
            mementoImpl = (MementoImpl)this.createMemento();
        }
        dataInput.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version 0");
        }
        int n = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read association size " + n);
        }
        if (n > 0) {
            try {
                mementoImpl.m_clusterMemberAssociation = this.keyRepository.importFromStream(dataInput);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read clusterMemberAssociation " + mementoImpl.m_clusterMemberAssociation);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, SelectionClusterMemberDescriptionImpl.class.getName() + ".importFromStream", "176", this);
                Tr.debug(tc, "unexpected exception ", exception);
            }
        }
        if (!(string = dataInput.readUTF()).equals(LOCAL_HOST)) {
            mementoImpl.m_host = string;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read host: " + string + " memento host:" + mementoImpl.m_host);
        }
        int n2 = dataInput.readInt();
        for (int i = 0; i < n2; ++i) {
            String string2 = dataInput.readUTF();
            mementoImpl.m_attributes.add(string2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "read attribute " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream", mementoImpl);
        }
        return mementoImpl;
    }

    public void setHost(String string) {
        this.host = string;
        this.updateMemento();
    }

    public void addAttribute(String string) {
        this.attributes.add(string);
        this.updateMemento();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
        this.updateMemento();
    }

    public boolean isAttributeEmpty() {
        return this.attributes.isEmpty();
    }

    public String toString() {
        return "[" + super.toString() + this.host + ' ' + this.attributes + ']';
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setMemento(Description.Memento memento) {
        String string;
        MementoImpl mementoImpl = (MementoImpl)memento;
        MementoImpl mementoImpl2 = (MementoImpl)this.getMemento();
        super.setMemento(memento);
        Iterator iterator = mementoImpl2.m_attributes.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (mementoImpl.m_attributes.contains(string)) continue;
            this.notifyListeners("type.attribute.removed", string);
        }
        iterator = mementoImpl.m_attributes.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (mementoImpl2.m_attributes.contains(string)) continue;
            this.notifyListeners("type.attribute.added", string);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.13 ");
        }
    }

    public class MementoImpl
    extends DescriptionA.MementoA
    implements SelectionClusterMemberDescription.Memento {
        private Concern concern = new ConcernImpl(Integer.MAX_VALUE);
        private String m_host = "localhost";
        private DescriptionKey m_clusterMemberAssociation;
        private Set m_attributes = new HashSet();

        public Concern getConcern() {
            return this.concern;
        }

        public String getHost() {
            return this.m_host;
        }

        public DescriptionKey getClusterMemberAssociation() {
            return this.m_clusterMemberAssociation;
        }

        public Set getAttributes() {
            return Collections.unmodifiableSet(this.m_attributes);
        }

        public String toString() {
            return "[" + super.toString() + this.m_host + this.m_attributes + ']';
        }
    }
}

