/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.ws.cluster.topography.ClusterMemberDescriptionImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ProcessDescriptionImpl
extends ClusterMemberDescriptionImpl
implements ProcessDescription {
    private static final TraceComponent tc = Tr.register(ProcessDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected String nodeName = "nil";
    protected String processName = "nil";

    public ProcessDescriptionImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
    }

    public void setNodeName(String string) {
        this.nodeName = string;
        this.updateMemento();
    }

    public void setProcessName(String string) {
        this.processName = string;
        this.updateMemento();
    }

    public String getDefinitionKey() {
        return ProcessDescription.class.getName();
    }

    public synchronized void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream", format);
        }
        super.exportToStream(dataOutput, format);
        int n = format.getType();
        ProcessDescription.Memento memento = null;
        if (n == 3) {
            memento = (ProcessDescription.Memento)this.getMemento();
        }
        dataOutput.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        String string = this.nodeName;
        String string2 = this.processName;
        if (memento != null) {
            string = memento.getNodeName();
            string2 = memento.getProcessName();
        }
        dataOutput.writeUTF(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote nodeName " + string);
        }
        dataOutput.writeUTF(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote processName " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public synchronized Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        MementoImpl mementoImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((mementoImpl = (MementoImpl)memento) == null) {
            mementoImpl = (MementoImpl)this.createMemento();
        }
        super.importFromStream(dataInput, format, mementoImpl);
        dataInput.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version 0");
        }
        mementoImpl.m_nodeName = dataInput.readUTF();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read nodename " + mementoImpl.m_nodeName);
        }
        mementoImpl.m_processName = dataInput.readUTF();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read processName " + mementoImpl.m_processName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoImpl;
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public String toString() {
        return "[" + super.toString() + this.nodeName + ':' + this.processName + ']';
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.12 ");
        }
    }

    public class MementoImpl
    extends ClusterMemberDescriptionImpl.MementoImpl
    implements ProcessDescription.Memento {
        private String m_processName = "";
        private String m_nodeName = "";

        protected MementoImpl() {
        }

        public String getProcessName() {
            return this.m_processName;
        }

        public String getNodeName() {
            return this.m_nodeName;
        }

        public String toString() {
            return "[" + super.toString() + this.m_nodeName + ':' + this.m_processName + ']';
        }
    }
}

