/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EndPointImpl
extends DescriptionA
implements EndPoint,
ExtrinsicDescription {
    private static final TraceComponent tc = Tr.register(EndPointImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final String TYPE_STATE_CHANGE_REACHABILITY = "type.state.change.reachability";
    private byte[] data = new byte[0];
    private boolean reachable = true;
    private boolean local = false;
    private Map dataCache = Collections.synchronizedMap(new HashMap(3));
    private boolean hadZeroData = false;

    public EndPointImpl(DescriptionKey descriptionKey) {
        super(descriptionKey);
    }

    public Identity getIdentity() {
        return this.getKey();
    }

    public byte[] getData() {
        return ((MementoImpl)this.getMemento()).m_data;
    }

    public void setData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setData");
        }
        this.data = byArray;
        if (this.local) {
            MementoImpl mementoImpl = (MementoImpl)this.createMemento();
            MementoImpl.access$002(mementoImpl, byArray);
            this.setMemento(mementoImpl);
        } else {
            this.updateMemento();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setData", this);
        }
    }

    public void setAvailability(boolean bl) {
        if (this.reachable != bl) {
            this.reachable = bl;
            this.notifyListeners(TYPE_STATE_CHANGE_REACHABILITY, this);
        }
    }

    public boolean isAvailable() {
        return this.reachable;
    }

    public void setlocal(boolean bl) {
        this.local = bl;
    }

    public boolean islocal() {
        return this.local;
    }

    public boolean isChannelEndPoint() {
        Identity identity = this.getIdentity();
        Map map = identity.getProperties();
        return map.size() == 6 && map.containsKey("TYPE") && map.containsValue("CHANNEL");
    }

    public String getDefinitionKey() {
        return EndPoint.class.getName();
    }

    public Description.Memento importFromStream(DataInput dataInput, Format format, Description.Memento memento) throws IOException {
        byte[] byArray;
        MementoImpl mementoImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((mementoImpl = (MementoImpl)memento) == null) {
            mementoImpl = (MementoImpl)this.createMemento();
        }
        byte by = dataInput.readByte();
        int n = dataInput.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + by);
            Tr.debug(tc, "read length " + n);
        }
        if ((byArray = new byte[n]).length > 0) {
            dataInput.readFully(byArray, 0, n);
        }
        MementoImpl.access$002(mementoImpl, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return mementoImpl;
    }

    public void exportToStream(DataOutput dataOutput, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream", this);
        }
        int n = 0;
        dataOutput.writeByte(n);
        byte[] byArray = null;
        int n2 = 0;
        if (this.islocal()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Endpoint is local don't export");
            }
            byArray = new byte[]{};
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Endpoint is not local so export");
            }
            byArray = this.data;
            if (format.getType() == 3) {
                byArray = this.getData();
            }
            n2 = byArray.length;
        }
        dataOutput.writeInt(n2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version " + n);
            Tr.debug(tc, "wrote length " + n2);
            Tr.debug(tc, "wrote data", byArray);
        }
        if (n2 > 0) {
            dataOutput.write(byArray, 0, n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setClusterMemberAssociation(DescriptionKey descriptionKey) {
    }

    public Object getCachedData(String string) {
        return this.dataCache.get(string);
    }

    public Object putCachedData(String string, Object object) {
        return this.dataCache.put(string, object);
    }

    public void emptyCachedData() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "emptying dataCache for EndPoint " + this.getIdentity());
        }
        this.dataCache.clear();
    }

    public String toString() {
        MementoImpl mementoImpl = (MementoImpl)this.getMemento();
        byte[] byArray = mementoImpl.getData();
        if (byArray == null) {
            return super.toString() + "[" + this.reachable + ":null EPData:" + this.getKey() + ":" + this.local + "]";
        }
        if (byArray.length == 0) {
            return super.toString() + "[" + this.reachable + ":EPData.length == 0:" + this.getKey() + ":" + this.local + "]";
        }
        return super.toString() + "[" + this.reachable + ":" + ":" + this.getKey() + ":" + this.local + "]";
    }

    public void setMemento(Description.Memento memento) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMemento");
        }
        MementoImpl mementoImpl = (MementoImpl)this.getMemento();
        MementoImpl mementoImpl2 = (MementoImpl)memento;
        byte[] byArray = mementoImpl.getData();
        byte[] byArray2 = mementoImpl2.getData();
        if (byArray2.length == 0) {
            this.setAvailability(false);
            this.hadZeroData = true;
        } else if (this.hadZeroData) {
            this.setAvailability(true);
            this.hadZeroData = false;
        }
        super.setMemento(memento);
        this.emptyCachedData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMemento");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.22.1.3 ");
        }
    }

    public final class MementoImpl
    extends DescriptionA.MementoA
    implements ExtrinsicDescription.Memento {
        private final Concern concern = new ConcernImpl(Integer.MAX_VALUE);
        private byte[] m_data = new byte[0];

        public Concern getConcern() {
            return this.concern;
        }

        public DescriptionKey getClusterMemberAssociation() {
            return null;
        }

        public byte[] getData() {
            if (this.m_data == null) {
                return new byte[0];
            }
            return this.m_data;
        }

        public String toString() {
            if (this.m_data == null) {
                return super.toString() + "[" + EndPointImpl.this.reachable + ":null EPData:" + EndPointImpl.this.getKey() + ":" + EndPointImpl.this.local + "]";
            }
            if (this.m_data.length == 0) {
                return super.toString() + "[" + EndPointImpl.this.reachable + ":EPData.length == 0:" + EndPointImpl.this.getKey() + ":" + EndPointImpl.this.local + "]";
            }
            return super.toString() + "[" + EndPointImpl.this.reachable + ":" + ":" + EndPointImpl.this.getKey() + ":" + EndPointImpl.this.local + "]";
        }

        static /* synthetic */ byte[] access$002(MementoImpl mementoImpl, byte[] byArray) {
            mementoImpl.m_data = byArray;
            return byArray;
        }
    }
}

