/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.service.ClusterServiceImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TargetImpl
implements Target,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(TargetImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ClusterMemberService cms = (ClusterMemberService)ProcessProperties.getInstance().get("key.clustermember.service");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final ProcessProperties processProps = ProcessProperties.getInstance();
    private static final Map scmdDistinction = new HashMap(1);
    Identity[] clusterIdentities = null;
    Identity memberIdentity = null;
    ClusterMemberDescription member = null;
    boolean inHost = false;
    boolean inProcess = false;
    boolean inServer = false;
    Map endPoints = null;
    ClusterService ivClusterService = ClusterServiceFactory.getClusterService();
    private long endPointVersion = 0L;
    private Integer endPointMutex = new Integer(98);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetImpl(Identity[] identityArray, Identity identity, EndPoint[] endPointArray) {
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{Arrays.toString(identityArray), identity, Arrays.toString(endPointArray)});
        }
        this.clusterIdentities = identityArray;
        this.memberIdentity = identity;
        this.member = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)this.memberIdentity);
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)this.member.getMemento();
        SelectionClusterMemberDescription selectionClusterMemberDescription = (SelectionClusterMemberDescription)memento.getExtrinsicData(descriptionKey = keyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction));
        if (selectionClusterMemberDescription != null && ((SelectionClusterMemberDescription.Memento)selectionClusterMemberDescription.getMemento()).getHost().equals(processProps.get("key.virtual.host"))) {
            this.inHost = true;
        }
        if (this.cms != null) {
            this.inServer = this.cms.getServerClusterContextListener().validateClusterResidency(this.clusterIdentities[this.clusterIdentities.length - 1]);
            this.inProcess = this.cms.getServerClusterContextListener().validateClusterProcessResidency(this.clusterIdentities[this.clusterIdentities.length - 1]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", "ClusterMember=" + identity);
        }
        if (identity == null) {
            Tr.error(tc, "Target member is null for the key=" + identity);
        }
        Integer n = this.endPointMutex;
        synchronized (n) {
            HashMap<Identity, EndPoint> hashMap = new HashMap<Identity, EndPoint>();
            for (int i = 0; i < endPointArray.length; ++i) {
                if (endPointArray[i] instanceof ExtrinsicDescription) {
                    ((ExtrinsicDescription)((Object)endPointArray[i])).registerNotificationListener(this, "type.memento.updated", null);
                }
                hashMap.put(endPointArray[i].getIdentity(), endPointArray[i]);
            }
            this.endPoints = hashMap;
            this.endPointVersion = System.currentTimeMillis();
        }
        this.member.registerNotificationListener(this, "type.add.extrinsic", null);
        this.member.registerNotificationListener(this, "type.remove.extrinsic", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Identity getMemberIdentity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberIdentity");
            Tr.exit(tc, "getMemberIdentity", this.memberIdentity);
        }
        return this.memberIdentity;
    }

    public Identity[] getClusterIdentities() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentities");
            Tr.exit(tc, "getClusterIdentities", this.clusterIdentities);
        }
        return this.clusterIdentities;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[clusterIdentities ");
        for (int i = 0; i < this.clusterIdentities.length; ++i) {
            stringBuffer.append(this.clusterIdentities[i]);
        }
        stringBuffer.append(", memberIdentity ").append(this.memberIdentity);
        Map map = this.endPoints;
        stringBuffer.append(", endPoints ").append(map);
        stringBuffer.append(", inHost ").append(this.inHost);
        stringBuffer.append(", inProcess ").append(this.inProcess);
        stringBuffer.append(", inServer ").append(this.inServer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPoint selectEndPoint(Identity identity) {
        Integer n = this.endPointMutex;
        synchronized (n) {
            return (EndPoint)this.endPoints.get(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPoint[] matchEndPoints(Map map) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", map);
        }
        EndPoint[] endPointArray = null;
        Integer n = this.endPointMutex;
        synchronized (n) {
            endPointArray = ((ClusterServiceImpl)this.ivClusterService).matchEndPoints(this.endPoints, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints", endPointArray);
        }
        return endPointArray;
    }

    public void setAvailability(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailability", Boolean.toString(bl));
        }
        byte by = bl ? (byte)0 : 4;
        this.member.setReachability(by);
    }

    public boolean isTargetInHost() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInHost");
            Tr.exit(tc, "isTargetInHost", Boolean.toString(this.inHost));
        }
        return this.inHost;
    }

    public boolean isTargetInProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInProcess");
            Tr.exit(tc, "isTargetInProcess", Boolean.toString(this.inProcess));
        }
        return this.inProcess;
    }

    public ClusterMemberDescription getMember() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMember");
            Tr.exit(tc, "getMember", this.member);
        }
        return this.member;
    }

    public boolean isAvailable() {
        return ((ClusterMemberDescription.Memento)this.member.getMemento()).getState() == 0;
    }

    public boolean isTargetInServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInServer");
            Tr.exit(tc, "isTargetInServer", Boolean.toString(this.inServer));
        }
        return this.inServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEndPointVersion() {
        Integer n = this.endPointMutex;
        synchronized (n) {
            return this.endPointVersion;
        }
    }

    public Object getEndPointMutex() {
        return this.endPointMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2, "This cluster: " + Arrays.toString(this.clusterIdentities) + " This member: " + this.memberIdentity});
        }
        long l = -1L;
        if (string.equals("type.add.extrinsic") || string.equals("type.remove.extrinsic") || string.equals("type.memento.updated")) {
            Object object3;
            ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)this.member.getMemento();
            ArrayList arrayList = new ArrayList(memento.getExtrinsicData().values());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of Endpoints in Memento: " + String.valueOf(arrayList.size()));
                Tr.debug(tc, "Endpoint List", arrayList);
            }
            EndPoint[] endPointArray = arrayList.iterator();
            while (endPointArray.hasNext()) {
                object3 = (ExtrinsicDescription)endPointArray.next();
                if (!(object3 instanceof EndPoint)) {
                    endPointArray.remove();
                    continue;
                }
                object3.registerNotificationListener(this, "type.memento.updated", null);
            }
            endPointArray = new EndPoint[arrayList.size()];
            arrayList.toArray(endPointArray);
            object3 = new HashMap();
            for (int i = 0; i < endPointArray.length; ++i) {
                object3.put(endPointArray[i].getIdentity(), endPointArray[i]);
            }
            Integer n = this.endPointMutex;
            synchronized (n) {
                this.endPoints = object3;
                for (l = System.currentTimeMillis(); this.endPointVersion >= l; ++l) {
                }
                this.endPointVersion = l;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification " + l);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.16.1.3 : none");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

