/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.ws.cluster.selection.algorithm.AffinityAlgorithm;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.algorithm.WeightedProportionalAlgorithm;
import com.ibm.ws.cluster.selection.feedback.BlendedWeightFeedback;
import com.ibm.ws.cluster.selection.feedback.DesiredWeightFeedback;
import com.ibm.ws.cluster.selection.feedback.ObservedWeightFeedback;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.ws.cluster.selection.rule.ApplicableStatesRule;
import com.ibm.ws.cluster.selection.rule.ReachabilityRule;
import com.ibm.ws.cluster.selection.rule.RuleEtiquette;
import com.ibm.ws.cluster.selection.rule.ZeroWeightRule;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import com.ibm.wsspi.cluster.selection.rule.AttributeRule;
import com.ibm.wsspi.cluster.selection.rule.EndPointRule;
import com.ibm.wsspi.cluster.selection.rule.QuiesceRule;
import java.util.Map;
import java.util.Set;

public final class SelectionAdvisor
implements DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(SelectionAdvisor.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr;
    private final DescriptionKey clusterKey;
    private RuleEtiquette[] etiquette;
    private SelectionAlgorithm[] algorithms;
    private StringBuffer[] reason;
    private final Map attributes;
    private final Integer syncObject = new Integer(42);
    private boolean beingRemoved = false;

    SelectionAdvisor(DescriptionKey descriptionKey, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{descriptionKey, map});
        }
        this.clusterKey = descriptionKey;
        this.attributes = map;
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        SelectionRule[][] selectionRuleArray = this.assembleRules(this.attributes);
        SelectionAlgorithm[] selectionAlgorithmArray = new SelectionAlgorithm[selectionRuleArray.length];
        StringBuffer[] stringBufferArray = new StringBuffer[selectionRuleArray.length];
        RuleEtiquette[] ruleEtiquetteArray = new RuleEtiquette[selectionRuleArray.length];
        boolean bl = tc.isDebugEnabled();
        for (int i = 0; i < selectionRuleArray.length; ++i) {
            if (bl) {
                Tr.debug(tc, "Building Rules", selectionRuleArray[i]);
            }
            selectionAlgorithmArray[i] = this.getAlgorithm(this.attributes);
            WeightBasedFeedback weightBasedFeedback = this.getFeedback(this.attributes);
            weightBasedFeedback.init(this.clusterKey, selectionAlgorithmArray[i]);
            stringBufferArray[i] = new StringBuffer(256);
            ruleEtiquetteArray[i] = new RuleEtiquette(this.clusterKey, selectionRuleArray[i], stringBufferArray[i], weightBasedFeedback, this.attributes);
        }
        Integer n = this.syncObject;
        synchronized (n) {
            this.etiquette = ruleEtiquetteArray;
            this.reason = stringBufferArray;
            this.algorithms = selectionAlgorithmArray;
        }
    }

    private SelectionRule[][] assembleRules(Map map) {
        SelectionRule[] selectionRuleArray = this.assembleLayers(this.clusterKey, map);
        SelectionRule[] selectionRuleArray2 = this.assembleOrder(this.clusterKey, map);
        SelectionRule[][] selectionRuleArray3 = new SelectionRule[selectionRuleArray2.length][];
        for (int i = 0; i < selectionRuleArray2.length; ++i) {
            selectionRuleArray3[i] = new SelectionRule[selectionRuleArray.length + 1];
            System.arraycopy(selectionRuleArray, 0, selectionRuleArray3[i], 0, selectionRuleArray.length);
            selectionRuleArray3[i][selectionRuleArray.length] = selectionRuleArray2[i];
        }
        return selectionRuleArray3;
    }

    private SelectionRule[] assembleLayers(DescriptionKey descriptionKey, Map map) {
        SelectionRule[] selectionRuleArray = (SelectionRule[])map.get("rules.restriction");
        if (selectionRuleArray == null) {
            selectionRuleArray = new SelectionRule[]{};
        }
        int n = selectionRuleArray.length;
        ReachabilityRule reachabilityRule = new ReachabilityRule();
        ++n;
        ZeroWeightRule zeroWeightRule = new ZeroWeightRule(descriptionKey);
        ++n;
        byte[] byArray = (byte[])map.get("AcceptableStates");
        if (byArray == null) {
            byArray = new byte[]{0};
        }
        ApplicableStatesRule applicableStatesRule = new ApplicableStatesRule(byArray);
        ++n;
        AttributeRule attributeRule = null;
        Set set = (Set)map.get("attributes");
        if (set != null) {
            attributeRule = new AttributeRule(set);
            ++n;
        }
        EndPointRule endPointRule = null;
        Map map2 = (Map)map.get("endpoints");
        if (map2 != null) {
            endPointRule = new EndPointRule(map2);
            ++n;
        }
        QuiesceRule quiesceRule = null;
        if (!map.containsKey("affinity.key")) {
            quiesceRule = new QuiesceRule(descriptionKey);
            ++n;
        }
        SelectionRule[] selectionRuleArray2 = new SelectionRule[n];
        System.arraycopy(selectionRuleArray, 0, selectionRuleArray2, 0, selectionRuleArray.length);
        int n2 = selectionRuleArray.length;
        if (reachabilityRule != null) {
            selectionRuleArray2[n2++] = reachabilityRule;
        }
        if (applicableStatesRule != null) {
            selectionRuleArray2[n2++] = applicableStatesRule;
        }
        if (attributeRule != null) {
            selectionRuleArray2[n2++] = attributeRule;
        }
        if (endPointRule != null) {
            selectionRuleArray2[n2++] = endPointRule;
        }
        if (quiesceRule != null) {
            selectionRuleArray2[n2++] = quiesceRule;
        }
        if (zeroWeightRule != null) {
            selectionRuleArray2[n2++] = zeroWeightRule;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "assembleLayers", selectionRuleArray2);
        }
        return selectionRuleArray2;
    }

    private SelectionRule[] assembleOrder(DescriptionKey descriptionKey, Map map) {
        SelectionRule[] selectionRuleArray = (SelectionRule[])map.get("rules.precedence");
        if (selectionRuleArray == null) {
            ClusterDescription clusterDescription = (ClusterDescription)descMgr.getDescription(descriptionKey);
            clusterDescription.registerNotificationListener(this, "type.selection.description.modified", null);
            ClusterDescription.Memento memento = (ClusterDescription.Memento)clusterDescription.getMemento();
            SelectionDescription selectionDescription = memento.getSelectionDescription();
            SelectionService selectionService = SelectionServiceFactory.getSelectionService();
            selectionRuleArray = selectionDescription.getKey().equals(SelectionDescription.KEY_WEIGHTED_PREFER_LOCAL) ? new SelectionRule[]{selectionService.getRule("rule.local.server"), selectionService.getRule("rule.local.host"), selectionService.getRule("rule.default")} : new SelectionRule[]{selectionService.getRule("rule.local.server"), selectionService.getRule("rule.default")};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "assembleOrder", selectionRuleArray);
        }
        return selectionRuleArray;
    }

    private WeightBasedFeedback getFeedback(Map map) {
        Byte by = (Byte)map.get("FeedbackMechanism");
        WeightBasedFeedback weightBasedFeedback = by == null || by.equals(SelectionCriteria.FEEDBACK_THRESHOLD) ? new BlendedWeightFeedback() : (by.equals(SelectionCriteria.FEEDBACK_ERROR) ? new ObservedWeightFeedback() : (by.equals(SelectionCriteria.FEEDBACK_STATIC) ? new DesiredWeightFeedback() : new BlendedWeightFeedback()));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFeedback", weightBasedFeedback);
        }
        return weightBasedFeedback;
    }

    private SelectionAlgorithm getAlgorithm(Map map) {
        Identity identity = (Identity)map.get("affinity.key");
        if (identity == null) {
            return new WeightedProportionalAlgorithm();
        }
        return new AffinityAlgorithm(identity);
    }

    public ClusterMemberDescription select() {
        ClusterMemberDescription clusterMemberDescription = null;
        Identity identity = null;
        SelectionAlgorithm[] selectionAlgorithmArray = this.algorithms;
        for (int i = 0; i < selectionAlgorithmArray.length; ++i) {
            identity = selectionAlgorithmArray[i].select();
            if (identity == null || (clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)identity)) == null) continue;
            return clusterMemberDescription;
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "select failed", this.reason);
        }
        return null;
    }

    public String getReason() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer[] stringBufferArray = this.reason;
        for (int i = 0; i < stringBufferArray.length; ++i) {
            stringBuffer.append(stringBufferArray[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
        }
        if (!this.beingRemoved && string.equals("type.selection.description.modified")) {
            this.initialize();
        } else if (this.beingRemoved && tc.isDebugEnabled()) {
            Tr.debug(tc, "beingRemoved");
        }
    }

    public String toString() {
        SelectionAlgorithm[] selectionAlgorithmArray = this.algorithms;
        RuleEtiquette[] ruleEtiquetteArray = this.etiquette;
        StringBuffer[] stringBufferArray = this.reason;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[");
        for (int i = 0; i < selectionAlgorithmArray.length; ++i) {
            stringBuffer.append(selectionAlgorithmArray[i]).append("::");
            stringBuffer.append(ruleEtiquetteArray[i]).append("::");
            stringBuffer.append(stringBufferArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void beingRemoved() {
        this.beingRemoved = true;
        RuleEtiquette[] ruleEtiquetteArray = this.etiquette;
        for (int i = 0; i < this.etiquette.length; ++i) {
            ruleEtiquetteArray[i].beingRemoved();
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.31 ");
        }
        descMgr = DescriptionManagerFactory.getDescriptionManager();
    }
}

