/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import java.util.HashMap;
import java.util.Map;

public class ChannelTargetImpl
implements ChannelTarget {
    private static final TraceComponent tc = Tr.register(ChannelTargetImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final Map distinction = new HashMap();
    private Target target;
    private CFEndPointCriteria criteria;
    private EndPoint[] wlmEndPoints = null;
    private CFEndPoint[] cfEndpoints = new CFEndPoint[0];
    private long wlmEndPointsVersion = 0L;
    private boolean endPointsChanged = false;

    public ChannelTargetImpl(Target target, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ChannelTargetImpl", new Object[]{target, cFEndPointCriteria});
        }
        if (target == null) {
            throw new IllegalArgumentException("The Target passed in was null.");
        }
        if (cFEndPointCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria passed in was null.");
        }
        this.target = target;
        this.criteria = cFEndPointCriteria;
        this.updateCachedEndpoints();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ChannelTargetImpl " + this.wlmEndPointsVersion);
        }
    }

    public Identity getMemberIdentity() {
        return this.target.getMemberIdentity();
    }

    public Identity[] getClusterIdentities() {
        return this.target.getClusterIdentities();
    }

    public CFEndPoint[] getCFEndpoints() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndpoints " + this.wlmEndPointsVersion);
        }
        this.updateCachedEndpoints();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCFEndpoints " + this.wlmEndPointsVersion + " " + this.cfEndpoints.length);
        }
        return this.cfEndpoints;
    }

    public EndPoint[] getEndpoints() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpoints " + this.wlmEndPointsVersion);
        }
        this.updateCachedEndpoints();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpoints " + this.wlmEndPointsVersion);
        }
        return this.wlmEndPoints;
    }

    public CFEndPointCriteria getCFEndPointCriteria() {
        return this.criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFEndPoint getCFEndPoint() {
        CFEndPoint[] cFEndPointArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndPoint", this);
        }
        CFEndPoint cFEndPoint = null;
        if (ChannelSelectionAdapterImpl.cfService != null) {
            cFEndPointArray = this.getCFEndpoints();
            if (tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer(this.criteria.toString());
                stringBuffer.append("[");
                if (this.criteria instanceof DetailedCFEndPointCriteria) {
                    stringBuffer.append(((DetailedCFEndPointCriteria)this.criteria).getChainProperties() + ":");
                } else {
                    stringBuffer.append("Not DetailedCFEndPointCriteria:");
                }
                stringBuffer.append("]");
                Tr.debug(tc, "subset CFEndPointCriteria= ", stringBuffer);
                if (this.endPointsChanged) {
                    Object object = ((TargetImpl)this.target).getEndPointMutex();
                    synchronized (object) {
                        this.endPointsChanged = false;
                    }
                    object = new StringBuffer(128);
                    if (cFEndPointArray != null) {
                        ((StringBuffer)object).append("CFEndPoints list size = " + cFEndPointArray.length + " ");
                        for (int i = 0; i < cFEndPointArray.length; ++i) {
                            ((StringBuffer)object).append("[" + cFEndPointArray[i] + "]");
                        }
                    } else {
                        ((StringBuffer)object).append("unexpected: CFEndPoints list is null");
                    }
                    Tr.debug(tc, "end points changed: ", ((StringBuffer)object).toString());
                }
            }
        } else {
            if (tc.isErrorEnabled()) {
                Tr.error(tc, "NLSKEY_CFS_UNAVAILABLE");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCFEndPoint", "unexpected: ChannelFrameworkService is not available.");
            }
            throw new IllegalStateException("The ChannelFrameworkService is not available for determining the best end point.");
        }
        cFEndPoint = ChannelSelectionAdapterImpl.cfService.determineBestEndPoint(cFEndPointArray, this.criteria);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCFEndPoint", cFEndPoint);
        }
        return cFEndPoint;
    }

    public boolean isMemberInProcess() {
        boolean bl;
        block3: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInProcess();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, ChannelTargetImpl.class.getName() + ".isMemberInProcess", "193", this);
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "unexpected", classCastException);
            }
        }
        return bl;
    }

    public boolean isMemberInHost() {
        boolean bl;
        block4: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInHost();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, ChannelTargetImpl.class.getName() + ".isMemberInHost", "215", this);
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "unexpected", classCastException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isMemberInHost: " + bl);
        }
        return bl;
    }

    public boolean isMemberInServer() {
        boolean bl;
        block3: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInServer();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, ChannelTargetImpl.class.getName() + ".isMemberInServer", "236", this);
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "unexpected", classCastException);
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("Target is: ");
        stringBuffer.append(this.target);
        stringBuffer.append("Criteria is: ");
        stringBuffer.append(this.criteria);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCachedEndpoints() {
        boolean bl = false;
        EndPoint[] endPointArray = null;
        long l = 0L;
        CFEndPoint[] cFEndPointArray = new CFEndPoint[]{};
        Object object = ((TargetImpl)this.target).getEndPointMutex();
        synchronized (object) {
            if (((TargetImpl)this.target).getEndPointVersion() > this.wlmEndPointsVersion) {
                this.endPointsChanged = true;
                bl = true;
                endPointArray = this.target.matchEndPoints(distinction);
                l = ((TargetImpl)this.target).getEndPointVersion();
            }
        }
        if (bl) {
            cFEndPointArray = new CFEndPoint[endPointArray.length];
            for (int i = 0; i < cFEndPointArray.length; ++i) {
                cFEndPointArray[i] = IdentityMapping.getCFEndPoint(endPointArray[i].getIdentity());
            }
            Object object2 = ((TargetImpl)this.target).getEndPointMutex();
            synchronized (object2) {
                if (l > this.wlmEndPointsVersion) {
                    this.wlmEndPoints = endPointArray;
                    this.wlmEndPointsVersion = l;
                    this.cfEndpoints = cFEndPointArray;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateCachedEndpoints" + this.cfEndpoints.length);
                    }
                }
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.26.1.3 ");
        }
        distinction.put("TYPE", "CHANNEL");
        distinction.put("COMPONENT", "CF");
    }
}

