/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.Handler;
import com.ibm.ws.classloader.ResourceCache;
import com.ibm.ws.classloader.ZipFileHandle;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SinglePathClassProvider {
    private static TraceComponent tc = Tr.register(SinglePathClassProvider.class.getName(), "Websphere ClassLoader", null);
    protected File pathFile = null;
    protected boolean pathExists = false;
    protected boolean isDirectory = false;
    protected URL url = null;
    protected String path = null;
    protected ZipFile cachedZip = null;
    protected boolean cachingEnabled = false;
    protected Manifest manifest = null;
    private static final boolean emulateURLClassLoader = Boolean.getBoolean("com.ibm.ws.classloader.strict");
    private static String resourceURLProtocol = Handler.register() ? "wsjar" : "jar";
    private static final boolean encodeResourceURLs = Boolean.getBoolean("com.ibm.ws.classloader.encodeResourceURLs");
    private static final int zipFileCacheSize = Integer.getInteger("com.ibm.ws.classloader.zipFileCacheSize", 8);
    private static Map providerCache = new HashMap();
    private static ZipFileCache zipFileCache = new ZipFileCache();
    private ResourceCache resourcesInJar = new ResourceCache('/');
    private ResourceCache classesInJar = new ResourceCache('.');
    private Set metaInfEntries = new HashSet();
    private int numClassLoaderRefs;

    public SinglePathClassProvider(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SinglePathClassProvider");
        }
        this.pathFile = new File(string);
        try {
            this.path = this.pathFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "40", this);
            this.path = string;
        }
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        if (tc.isDebugEnabled()) {
            if (this.pathExists) {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " exists");
            } else {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " does not exist");
            }
            if (this.isDirectory) {
                Tr.debug(tc, "path " + this.pathFile.getPath() + " is a directory");
            }
        }
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
        try {
            File file = this.pathFile.getCanonicalFile();
            this.url = encodeResourceURLs ? file.toURI().toURL() : file.toURL();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.run", "59", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SinglePathClassProvider");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SinglePathClassProvider create(String string, boolean bl) {
        SinglePathClassProvider singlePathClassProvider;
        if (!bl) {
            return new SinglePathClassProvider(string);
        }
        Map map = providerCache;
        synchronized (map) {
            singlePathClassProvider = (SinglePathClassProvider)providerCache.get(string);
            if (singlePathClassProvider == null) {
                singlePathClassProvider = new SinglePathClassProvider(string);
                providerCache.put(string, singlePathClassProvider);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding cached provider " + singlePathClassProvider);
                }
            }
            ++singlePathClassProvider.numClassLoaderRefs;
        }
        return singlePathClassProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZipFileHandle openZipFile(String string, SinglePathClassProvider singlePathClassProvider) throws IOException {
        ZipFileHandle zipFileHandle;
        if (zipFileCacheSize == 0) {
            zipFileHandle = new ZipFileHandle(string);
        } else {
            ZipFileCache zipFileCache = SinglePathClassProvider.zipFileCache;
            synchronized (zipFileCache) {
                zipFileHandle = (ZipFileHandle)SinglePathClassProvider.zipFileCache.get(string);
                if (zipFileHandle == null) {
                    zipFileHandle = new ZipFileHandle(string);
                    Map map = providerCache;
                    synchronized (map) {
                        if (singlePathClassProvider == null) {
                            singlePathClassProvider = (SinglePathClassProvider)providerCache.get(string);
                        }
                        if (singlePathClassProvider != null && singlePathClassProvider.numClassLoaderRefs != 0) {
                            zipFileHandle.ref();
                            SinglePathClassProvider.zipFileCache.put(string, zipFileHandle);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "adding cached zip file " + string);
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "opening non-cached zip file " + string);
                        }
                    }
                }
            }
        }
        zipFileHandle.open();
        return zipFileHandle;
    }

    static ZipFileHandle openZipFile(String string) throws IOException {
        return SinglePathClassProvider.openZipFile(string, null);
    }

    private ZipFileHandle openZipFile() throws IOException {
        return SinglePathClassProvider.openZipFile(this.path, this);
    }

    protected Manifest getManifest() {
        return this.manifest;
    }

    public void reload() {
        this.pathFile = new File(this.path);
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        this.resourcesInJar.clear();
        this.classesInJar.clear();
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = providerCache;
        synchronized (map) {
            if (--this.numClassLoaderRefs != 0) {
                return;
            }
            providerCache.remove(this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removing cached provider " + this);
            }
        }
        if (zipFileCacheSize != 0) {
            map = zipFileCache;
            synchronized (map) {
                ZipFileHandle zipFileHandle = (ZipFileHandle)zipFileCache.remove(this.path);
                if (zipFileHandle != null) {
                    zipFileHandle.close();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "removing cached zip file " + this.path);
                    }
                }
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.pathExists;
    }

    public byte[] getClassBytes(String string, ClassProviderListener classProviderListener) {
        byte[] byArray = null;
        if (this.pathExists) {
            byArray = this.isDirectory ? this.getClassBytesFromDir(string, classProviderListener) : this.getClassBytesFromJar(string, classProviderListener);
        }
        return byArray;
    }

    protected byte[] getClassBytesFromDir(final String string, final ClassProviderListener classProviderListener) {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                String string3 = string.replace('.', '/');
                FileInputStream fileInputStream = null;
                try {
                    String string2 = SinglePathClassProvider.this.getRealResourcePath(string3 + ".class");
                    File file = new File(string2);
                    if (!file.exists()) {
                        Object var5_7 = null;
                        return var5_7;
                    }
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[(int)file.length()];
                    SinglePathClassProvider.this.readFully(fileInputStream, byArray);
                    classProviderListener.classLoadedFromFile(file);
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "164", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getClassBytesFromDir", iOException);
                    }
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                    }
                }
                return null;
            }
        });
    }

    protected byte[] getClassBytesFromJar(final String string, final ClassProviderListener classProviderListener) {
        if (this.classesInJar.contains(string, '.')) {
            return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    byte[] byArray = null;
                    InputStream inputStream = null;
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    ZipFileHandle zipFileHandle = null;
                    try {
                        zipFileHandle = SinglePathClassProvider.this.openZipFile();
                        String string2 = string.replace('.', '/');
                        ZipEntry zipEntry = zipFileHandle.getZipFile().getEntry(string2 + ".class");
                        if (zipEntry != null) {
                            inputStream = zipFileHandle.getZipFile().getInputStream(zipEntry);
                            long l = zipEntry.getSize();
                            if (l != -1L) {
                                int n = (int)l;
                                byArray = new byte[n];
                                SinglePathClassProvider.this.readFully(inputStream, byArray);
                            } else {
                                byte[] byArray2 = new byte[4096];
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                int n = 0;
                                while ((n = inputStream.read(byArray2, 0, byArray2.length)) != -1) {
                                    byteArrayOutputStream.write(byArray2, 0, n);
                                }
                                byArray = byteArrayOutputStream.toByteArray();
                            }
                            classProviderListener.classLoadedFromFile(SinglePathClassProvider.this.pathFile);
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "214", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, iOException.toString());
                        }
                    }
                    finally {
                        if (zipFileHandle != null) {
                            zipFileHandle.close();
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                            }
                        }
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                            }
                        }
                    }
                    if (byArray == null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "failed to read " + string + " from " + SinglePathClassProvider.this.path);
                    }
                    return byArray;
                }
            });
        }
        return null;
    }

    protected String getRealResourcePath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.path.length() + string.length() + 1);
        stringBuffer.append(this.path);
        stringBuffer.append(File.separatorChar);
        char[] cArray = string.toCharArray();
        if (cArray.length != 1 || cArray[0] != '/' && cArray[0] != '\\') {
            boolean bl = true;
            int n = 0;
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                if (bl) {
                    while ((cArray[i] == '/' || cArray[i] == '\\') && ++i < n2) {
                    }
                }
                if (cArray[i] == '/' || cArray[i] == '\\') {
                    bl = true;
                    cArray[n++] = File.separatorChar;
                    continue;
                }
                bl = false;
                cArray[n++] = cArray[i];
            }
            stringBuffer.append(cArray, 0, n);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public String toString() {
        return "SinglePathClassProvider : " + super.toString() + " classpath = " + this.pathFile.getPath();
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (this.pathExists && string != null) {
            String string2;
            if (emulateURLClassLoader && string.startsWith("/")) {
                return null;
            }
            boolean bl = true;
            if (!this.isDirectory) {
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                bl = string.startsWith("META-INF/") ? this.metaInfEntries.contains(string) : (string.endsWith(".class") ? this.classesInJar.contains(string, '/') : (string.endsWith("/") ? this.classesInJar.containsDir(string, '/') || this.resourcesInJar.containsDir(string, '/') : this.resourcesInJar.contains(string, '/')));
            }
            if (bl && (uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(string2 = string){
                private final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    URL uRL;
                    block14: {
                        uRL = null;
                        if (SinglePathClassProvider.this.isDirectory) {
                            try {
                                String string = SinglePathClassProvider.this.getRealResourcePath(this.val$name);
                                File file = new File(string);
                                if (!file.exists()) break block14;
                                File file2 = file.getCanonicalFile();
                                URL uRL2 = uRL = encodeResourceURLs ? file2.toURI().toURL() : file2.toURL();
                                if (string.indexOf("..") >= 0 && string.indexOf("...") < 0 && !uRL.getFile().startsWith(SinglePathClassProvider.this.url.getFile())) {
                                    return null;
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.SinglePathClassProvider.run", "324", this);
                            }
                        } else {
                            ZipFileHandle zipFileHandle = null;
                            try {
                                zipFileHandle = SinglePathClassProvider.this.openZipFile();
                                ZipEntry zipEntry = zipFileHandle.getZipFile().getEntry(this.val$name);
                                if (zipEntry != null) {
                                    URL uRL3 = encodeResourceURLs ? SinglePathClassProvider.this.pathFile.toURI().toURL() : SinglePathClassProvider.this.pathFile.toURL();
                                    uRL = new URL(new URL(resourceURLProtocol, "", -1, uRL3 + "!/"), this.val$name);
                                }
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.run", "350", this);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.classloader.SinglePathClassProvider.run", "354", this);
                            }
                            finally {
                                if (zipFileHandle != null) {
                                    zipFileHandle.close();
                                }
                            }
                        }
                    }
                    return uRL;
                }
            })) == null && !this.isDirectory && tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to read " + string + " from " + this.path);
            }
        }
        if (uRL != null) {
            uRL = SinglePathClassProvider.checkURL(uRL);
        }
        return uRL;
    }

    private static URL checkURL(URL uRL) {
        try {
            SinglePathClassProvider.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    private static void check(URL uRL) throws IOException {
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = uRL.openConnection().getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void buildContentsCache() {
        try {
            JarFile jarFile = new JarFile(this.path);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (string.startsWith("META-INF/")) {
                    this.metaInfEntries.add(string);
                    continue;
                }
                if (!emulateURLClassLoader && zipEntry.isDirectory()) continue;
                if (string.endsWith(".class")) {
                    this.classesInJar.add(string, '/');
                    continue;
                }
                this.resourcesInJar.add(string, '/');
            }
            try {
                this.manifest = jarFile.getManifest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.classloader.SinglePathClassProvider.buildContentsCache", "453", this);
        }
    }

    private final void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n2) {
            n2 = inputStream.read(byArray, n, i);
            if (n2 < 0) {
                throw new EOFException();
            }
            n += n2;
        }
    }

    private static class ZipFileCache
    extends LinkedHashMap {
        ZipFileCache() {
            super(zipFileCacheSize, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > zipFileCacheSize) {
                ((ZipFileHandle)entry.getValue()).close();
                return true;
            }
            return false;
        }
    }
}

