/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.ctm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelData;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.GenericInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.GenericOutboundChannel;
import com.ibm.websphere.models.descriptor.channel.ChannelFactoryType;
import com.ibm.websphere.models.descriptor.channel.ChannelType;
import com.ibm.websphere.models.descriptor.channel.impl.ChannelPackageImpl;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.PlatformCheck;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.channel.framework.exception.ChannelJARAlreadyLoadedException;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.osgi.framework.Bundle;

public abstract class BaseChannelTypeManager
implements ChannelTypeManager {
    private static TraceComponent tc = Tr.register(BaseChannelTypeManager.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    protected Set _jarSet;
    protected Map _typeMap = new HashMap();

    public BaseChannelTypeManager() {
        this._jarSet = new HashSet();
        ChannelPackageImpl.init();
        ArchiveInit.init();
    }

    private void addOSGiChannelFactoryTypes() {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".channel-framework-channel-factory-type";
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            this.addChannelFactoryMetaData(new OSGiChannelFactoryMetaDataImpl(iConfigurationElementArray[i]));
        }
    }

    private void addOSGiChannelTypes() {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".channel-framework-channel-type";
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            try {
                this.addChannelMetaData(new OSGiChannelMetaDataImpl(iConfigurationElementArray[i]));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.channel.framework.ctm.BaseChannelTypeManager.BaseChannelTypeManager", "87", this);
            }
        }
    }

    public ChannelTypeManager.ChannelMetaData getChannelType(Object object) {
        try {
            return (ChannelTypeManager.ChannelMetaData)this.getTypeMetaData(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public ChannelTypeManager.ChannelFactoryMetaData getChannelFactoryType(Object object) {
        try {
            return (ChannelTypeManager.ChannelFactoryMetaData)this.getTypeMetaData(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public String createFullyQualifiedGenericID(GenericChannelData genericChannelData) {
        return BaseChannelTypeManager.createFullyQualifiedGenericID(genericChannelData.getTypeID());
    }

    protected Object getTypeMetaData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this._typeMap.get(object);
        }
        if (object instanceof Class) {
            Object object2 = this._typeMap.get(object);
            if (object2 == null) {
                Class clazz = (Class)object;
                object2 = this.getTypeMetaData(clazz.getName());
                if (object2 == null) {
                    Class<?>[] classArray = clazz.getInterfaces();
                    for (int i = 0; i < classArray.length && object2 == null; ++i) {
                        object2 = this.getTypeMetaData(classArray[i]);
                    }
                }
                if (object2 == null) {
                    object2 = this.getTypeMetaData(clazz.getSuperclass());
                }
                this._typeMap.put(object, object2);
            }
            return object2;
        }
        Object object3 = object instanceof GenericChannelData ? this.getTypeMetaData(this.createFullyQualifiedGenericID((GenericChannelData)object)) : this.getTypeMetaData(object.getClass());
        if (object3 == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "could not find channel or channel factory metadata for " + object);
        }
        return object3;
    }

    protected void addChannelMetaData(ChannelTypeManager.ChannelMetaData channelMetaData) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChannelMetaData");
        }
        boolean bl = false;
        String string = channelMetaData.getConfigurationClass();
        if (this.checkGeneric(string)) {
            string = BaseChannelTypeManager.createFullyQualifiedGenericID(channelMetaData.getTypeID());
        }
        if (PlatformCheck.validOn(channelMetaData.getPlatform())) {
            object = (ChannelTypeManager.ChannelMetaData)this._typeMap.get(string);
            if (object != null) {
                if (object.getPlatform() == null) {
                    if (channelMetaData.getPlatform() == null) {
                        bl = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found redundant metadata for configType: " + string);
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Former type exists and platform specified, configType: " + string);
                    }
                    if (channelMetaData.getPlatform() != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found redundant metadata for configType: " + string);
                    }
                }
            } else {
                bl = true;
            }
        } else {
            bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Platform does not match current system, configType: " + string);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                object = new StringBuffer();
                ((StringBuffer)object).append("associating ");
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append('/');
                ((StringBuffer)object).append(channelMetaData);
                Tr.debug(tc, ((StringBuffer)object).toString());
            }
            this._typeMap.put(string, channelMetaData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChannelMetaData");
        }
    }

    protected void addChannelFactoryMetaData(ChannelTypeManager.ChannelFactoryMetaData channelFactoryMetaData) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChannelFactoryMetaData");
        }
        boolean bl = false;
        String string = channelFactoryMetaData.getConfigurationClass();
        if (this.checkGeneric(string)) {
            string = BaseChannelTypeManager.createFullyQualifiedGenericID(channelFactoryMetaData.getTypeID());
        }
        if (PlatformCheck.validOn(channelFactoryMetaData.getPlatform())) {
            object = (ChannelTypeManager.ChannelFactoryMetaData)this._typeMap.get(string);
            if (object != null) {
                if (object.getPlatform() == null) {
                    if (channelFactoryMetaData.getPlatform() == null) {
                        bl = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found redundant metadata for configType: " + string);
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    bl = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Former type exists and platform specified, configType: " + string);
                    }
                    if (channelFactoryMetaData.getPlatform() != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found redundant metadata for configType: " + string);
                    }
                }
            } else {
                bl = true;
            }
        } else {
            bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Platform does not match current system, configType: " + string);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                object = new StringBuffer();
                ((StringBuffer)object).append("associating ");
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append('/');
                ((StringBuffer)object).append(channelFactoryMetaData);
                Tr.debug(tc, ((StringBuffer)object).toString());
            }
            this._typeMap.put(string, channelFactoryMetaData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChannelFactoryMetaData");
        }
    }

    protected boolean checkGeneric(String string) {
        return string.equals(GenericInboundChannel.class.getName()) || string.equals(GenericOutboundChannel.class.getName()) || string.equals(GenericChannelFactory.class.getName());
    }

    protected boolean validate(File file, ChannelTypeManager.ChannelMetaData channelMetaData) {
        boolean bl = true;
        if (channelMetaData.getRuntimeClass() == null) {
            Tr.error(tc, "channel.descriptor.factory.missing", file);
            bl = false;
        }
        if (channelMetaData.getConfigurationClass() == null) {
            Tr.error(tc, "channel.descriptor.channel.missing", file);
            bl = false;
        }
        if (channelMetaData.getApplicationInterface() == null && channelMetaData.getDeviceInterface().isEmpty()) {
            Tr.error(tc, "channel.descriptor.interfaces.missing", file);
            bl = false;
        }
        if (channelMetaData.isSetDefaultWeight() && channelMetaData.getDefaultWeight() < 0) {
            Tr.error(tc, "channel.descriptor.weight.invalid", new Object[]{file, new Integer(channelMetaData.getDefaultWeight())});
            bl = false;
        }
        return bl;
    }

    protected boolean validate(File file, ChannelTypeManager.ChannelFactoryMetaData channelFactoryMetaData) {
        boolean bl = true;
        if (channelFactoryMetaData.getRuntimeClass() == null) {
            Tr.error(tc, "channel.descriptor.factory.missing", file);
            bl = false;
        }
        if (channelFactoryMetaData.getConfigurationClass() == null) {
            Tr.error(tc, "channel.descriptor.channel.config.missing", file);
            bl = false;
        }
        return bl;
    }

    protected boolean loadChannelDefinitions(File[] fileArray) {
        this.addOSGiChannelFactoryTypes();
        this.addOSGiChannelTypes();
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                bl &= this.loadChannelDefinitions(fileArray[i]);
                continue;
            }
            catch (ChannelJARAlreadyLoadedException channelJARAlreadyLoadedException) {
                Tr.error(tc, "channel.jar.already.loaded", channelJARAlreadyLoadedException.getOffendingFile().getAbsolutePath());
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadChannelDefinitions(File file) throws ChannelJARAlreadyLoadedException {
        if (file == null) {
            return false;
        }
        if (this._jarSet.contains(file)) {
            throw new ChannelJARAlreadyLoadedException(file);
        }
        Archive archive = null;
        try {
            archive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(file.getAbsolutePath());
            Resource resource = archive.getMofResource("META-INF/ws-channel.xmi");
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                WCCMChannelFactoryMetaDataImpl wCCMChannelFactoryMetaDataImpl;
                Object e = iterator.next();
                if (e instanceof ChannelType) {
                    WCCMChannelMetaDataImpl wCCMChannelMetaDataImpl = new WCCMChannelMetaDataImpl(file, (ChannelType)e);
                    if (!this.validate(file, wCCMChannelMetaDataImpl)) continue;
                    this.addChannelMetaData(wCCMChannelMetaDataImpl);
                    continue;
                }
                if (!(e instanceof ChannelFactoryType) || !this.validate(file, wCCMChannelFactoryMetaDataImpl = new WCCMChannelFactoryMetaDataImpl(file, (ChannelFactoryType)e))) continue;
                this.addChannelFactoryMetaData(wCCMChannelFactoryMetaDataImpl);
            }
            this._jarSet.add(file);
            boolean bl = true;
            return bl;
        }
        catch (OpenFailureException openFailureException) {
            Tr.error(tc, "channel.jar.open.failure", new Object[]{file, openFailureException});
        }
        catch (FileNotFoundException fileNotFoundException) {
            Tr.error(tc, "channel.descriptor.missing", file);
        }
        catch (ResourceLoadException resourceLoadException) {
            Tr.error(tc, "channel.descriptor.parse.failure", new Object[]{file, resourceLoadException});
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
        return false;
    }

    protected static String createFullyQualifiedGenericID(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static class WCCMChannelFactoryMetaDataImpl
    implements ChannelTypeManager.ChannelFactoryMetaData {
        private String _typeID;
        private String _shortName;
        private String _configurationClass;
        private String _runtimeClass;
        private String _validatorClass;
        private String _string;
        private String _hash;
        private String _platform;
        private String _jarFile;

        public WCCMChannelFactoryMetaDataImpl(File file, ChannelFactoryType channelFactoryType) {
            this._shortName = channelFactoryType.getConfigurationClass();
            this._configurationClass = channelFactoryType.getConfigurationClass();
            this._runtimeClass = channelFactoryType.getRuntimeClass();
            this._validatorClass = channelFactoryType.getValidatorClass();
            this._jarFile = file.getName();
            this._typeID = channelFactoryType.eResource().getURIFragment((EObject)channelFactoryType);
            this._hash = this._jarFile + '#' + this._typeID;
            if (this._shortName != null) {
                this._shortName = this._shortName.substring(this._shortName.lastIndexOf(46) + 1);
            }
        }

        public Class getClass(String string) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (string != null) {
                ClassLoader classLoader = ExtClassLoader.getInstance();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                clazz = Class.forName(string, true, classLoader);
            }
            return clazz;
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._shortName);
                stringBuffer.append(", typeID=");
                stringBuffer.append(this._typeID);
                stringBuffer.append(") (configClass=");
                stringBuffer.append(this._configurationClass);
                stringBuffer.append(", runtimeClass=");
                stringBuffer.append(this._runtimeClass);
                if (this._validatorClass != null) {
                    stringBuffer.append(", validator=");
                    stringBuffer.append(this._validatorClass);
                }
                stringBuffer.append(')');
                this._string = stringBuffer.toString();
            }
            return this._string;
        }

        public String getConfigurationClass() {
            return this._configurationClass;
        }

        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        public String getValidatorClass() {
            return this._validatorClass;
        }

        public String getTypeID() {
            return this._typeID;
        }

        public String getPlatform() {
            return this._platform;
        }
    }

    public static class OSGiChannelFactoryMetaDataImpl
    implements ChannelTypeManager.ChannelFactoryMetaData {
        private String _typeID;
        private String _shortName;
        private String _configurationClass;
        private String _runtimeClass;
        private String _validatorClass;
        private String _string;
        private String _hash;
        private String _platform;
        private String _bundleName;

        public OSGiChannelFactoryMetaDataImpl(IConfigurationElement iConfigurationElement) {
            this._bundleName = iConfigurationElement.getNamespace();
            this._shortName = iConfigurationElement.getAttribute("configurationClass");
            this._configurationClass = iConfigurationElement.getAttribute("configurationClass");
            this._runtimeClass = iConfigurationElement.getAttribute("runtimeClass");
            this._validatorClass = iConfigurationElement.getAttribute("validatorClass");
            this._typeID = iConfigurationElement.getAttribute("id");
            this._platform = iConfigurationElement.getAttribute("platform");
            this._hash = this._bundleName + '#' + this._typeID;
        }

        public Class getClass(final String string) throws ClassNotFoundException {
            Class clazz = null;
            if (string != null) {
                final Bundle bundle = Platform.getBundle((String)this._bundleName);
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(string);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)privilegedActionException.getCause();
                    }
                    throw new ClassNotFoundException(string, privilegedActionException);
                }
            }
            return clazz;
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._shortName);
                stringBuffer.append(", typeID=");
                stringBuffer.append(this._typeID);
                stringBuffer.append(") (configClass=");
                stringBuffer.append(this._configurationClass);
                stringBuffer.append(", runtimeClass=");
                stringBuffer.append(this._runtimeClass);
                if (this._validatorClass != null) {
                    stringBuffer.append(", validator=");
                    stringBuffer.append(this._validatorClass);
                }
                stringBuffer.append(')');
                this._string = stringBuffer.toString();
            }
            return this._string;
        }

        public String getConfigurationClass() {
            return this._configurationClass;
        }

        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        public String getValidatorClass() {
            return this._validatorClass;
        }

        public String getTypeID() {
            return this._typeID;
        }

        public String getPlatform() {
            return this._platform;
        }
    }

    private static class OSGiChannelMetaDataImpl
    implements ChannelTypeManager.ChannelMetaData {
        private String _jarFile;
        private String _typeID;
        private String _shortName;
        private String _runtimeClass;
        private String _configurationClass;
        private String _validatorClass;
        private int _defaultWeight;
        private boolean _setDefaultWeight;
        private String _appInterface;
        private List _deviceInterface;
        private ChannelTypeManager.ChannelKind _kind;
        private String _platform;
        private String _string;
        private String _hash;
        private String _bundleName;

        public OSGiChannelMetaDataImpl(IConfigurationElement iConfigurationElement) throws ClassNotFoundException {
            CharSequence charSequence;
            this._bundleName = iConfigurationElement.getNamespace();
            if (tc.isDebugEnabled()) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("constructing ChannelMetaData:\r\n");
                ((StringBuffer)charSequence).append("\tconfigurationClass: " + iConfigurationElement.getAttribute("configurationClass") + "\r\n");
                ((StringBuffer)charSequence).append("\truntimeClass: " + iConfigurationElement.getAttribute("runtimeClass") + "\r\n");
                ((StringBuffer)charSequence).append("\tvalidatorClass: " + iConfigurationElement.getAttribute("validatorClass") + "\r\n");
                ((StringBuffer)charSequence).append("\tapplicationInterface: " + iConfigurationElement.getAttribute("applicationInterface") + "\r\n");
                ((StringBuffer)charSequence).append("\tdeviceInterface: " + iConfigurationElement.getAttribute("deviceInterface") + "\r\n");
                ((StringBuffer)charSequence).append("\tkind: " + iConfigurationElement.getAttribute("kind") + "\r\n");
                ((StringBuffer)charSequence).append("\tplatform: " + iConfigurationElement.getAttribute("platform") + "\r\n");
                ((StringBuffer)charSequence).append("\tid: " + iConfigurationElement.getAttribute("id"));
                Tr.debug(tc, ((StringBuffer)charSequence).toString());
            }
            this._shortName = iConfigurationElement.getAttribute("configurationClass");
            this._configurationClass = iConfigurationElement.getAttribute("configurationClass");
            this._runtimeClass = iConfigurationElement.getAttribute("runtimeClass");
            this._validatorClass = iConfigurationElement.getAttribute("validatorClass");
            this._appInterface = iConfigurationElement.getAttribute("applicationInterface");
            this._deviceInterface = new ArrayList();
            charSequence = iConfigurationElement.getAttribute("deviceInterface");
            if (charSequence != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)charSequence, " ");
                int n = stringTokenizer.countTokens();
                String string = null;
                for (int i = 0; i < n; ++i) {
                    string = stringTokenizer.nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added device interface: " + string);
                    }
                    this._deviceInterface.add(string);
                }
            }
            this._kind = ChannelTypeManager.ChannelKind.getKind(iConfigurationElement.getAttribute("kind"));
            this._typeID = iConfigurationElement.getAttribute("id");
            this._platform = iConfigurationElement.getAttribute("platform");
            this._hash = this._bundleName + '#' + this._typeID;
        }

        public Class getClass(final String string) throws ClassNotFoundException {
            Class clazz = null;
            if (string != null) {
                final Bundle bundle = Platform.getBundle((String)this._bundleName);
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(string);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)privilegedActionException.getCause();
                    }
                    throw new ClassNotFoundException(string, privilegedActionException);
                }
            }
            return clazz;
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._shortName);
                stringBuffer.append(" (jarFile=");
                stringBuffer.append(this._jarFile);
                stringBuffer.append(", typeID=");
                stringBuffer.append(this._typeID);
                stringBuffer.append(") (kind=");
                stringBuffer.append(this._kind);
                stringBuffer.append(", configChannel=");
                stringBuffer.append(this._configurationClass);
                stringBuffer.append(", runtimeFactory=");
                stringBuffer.append(this._runtimeClass);
                if (this._validatorClass != null) {
                    stringBuffer.append(", validator=");
                    stringBuffer.append(this._validatorClass);
                }
                if (this._setDefaultWeight) {
                    stringBuffer.append(", weight=");
                    stringBuffer.append(this._defaultWeight);
                }
                if (this._deviceInterface != null && !this._deviceInterface.isEmpty()) {
                    stringBuffer.append(", deviceInterface=[");
                    Iterator iterator = this._deviceInterface.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(']');
                }
                stringBuffer.append(')');
                this._string = stringBuffer.toString();
            }
            return this._string;
        }

        public String getApplicationInterface() {
            return this._appInterface;
        }

        public String getConfigurationClass() {
            return this._configurationClass;
        }

        public int getDefaultWeight() {
            return this._defaultWeight;
        }

        public List getDeviceInterface() {
            return this._deviceInterface;
        }

        public ChannelTypeManager.ChannelKind getKind() {
            return this._kind;
        }

        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        public String getValidatorClass() {
            return this._validatorClass;
        }

        public boolean isSetDefaultWeight() {
            return this._setDefaultWeight;
        }

        public String getJARFile() {
            return this._jarFile;
        }

        public String getTypeID() {
            return this._typeID;
        }

        public String getPlatform() {
            return this._platform;
        }
    }

    private static class WCCMChannelMetaDataImpl
    implements ChannelTypeManager.ChannelMetaData {
        private String _jarFile;
        private String _typeID;
        private String _shortName;
        private String _runtimeClass;
        private String _configurationClass;
        private String _validatorClass;
        private int _defaultWeight;
        private boolean _setDefaultWeight;
        private String _appInterface;
        private List _deviceInterface;
        private ChannelTypeManager.ChannelKind _kind;
        private String _platform;
        private String _string;
        private String _hash;

        public WCCMChannelMetaDataImpl(File file, ChannelType channelType) {
            this._shortName = channelType.getConfigurationClass();
            this._configurationClass = channelType.getConfigurationClass();
            this._runtimeClass = channelType.getRuntimeClass();
            this._validatorClass = channelType.getValidatorClass();
            this._defaultWeight = channelType.getDefaultWeight();
            this._setDefaultWeight = channelType.isSetDefaultWeight();
            this._kind = ChannelTypeManager.ChannelKind.getKind(channelType.getKind());
            this._appInterface = channelType.getApplicationInterface();
            this._deviceInterface = new ArrayList(channelType.getDeviceInterface());
            this._jarFile = file.getName();
            this._typeID = channelType.eResource().getURIFragment((EObject)channelType);
            this._hash = this._jarFile + '#' + this._typeID;
            Collections.sort(this._deviceInterface);
            if (this._shortName != null) {
                this._shortName = this._shortName.substring(this._shortName.lastIndexOf(46) + 1);
            }
        }

        public Class getClass(String string) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (string != null) {
                ClassLoader classLoader = ExtClassLoader.getInstance();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                clazz = Class.forName(string, true, classLoader);
            }
            return clazz;
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._shortName);
                stringBuffer.append(" (jarFile=");
                stringBuffer.append(this._jarFile);
                stringBuffer.append(", typeID=");
                stringBuffer.append(this._typeID);
                stringBuffer.append(") (kind=");
                stringBuffer.append(this._kind);
                stringBuffer.append(", configChannel=");
                stringBuffer.append(this._configurationClass);
                stringBuffer.append(", runtimeFactory=");
                stringBuffer.append(this._runtimeClass);
                if (this._validatorClass != null) {
                    stringBuffer.append(", validator=");
                    stringBuffer.append(this._validatorClass);
                }
                if (this._setDefaultWeight) {
                    stringBuffer.append(", weight=");
                    stringBuffer.append(this._defaultWeight);
                }
                if (this._deviceInterface != null && !this._deviceInterface.isEmpty()) {
                    stringBuffer.append(", deviceInterface=[");
                    Iterator iterator = this._deviceInterface.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(']');
                }
                stringBuffer.append(')');
                this._string = stringBuffer.toString();
            }
            return this._string;
        }

        public String getApplicationInterface() {
            return this._appInterface;
        }

        public String getConfigurationClass() {
            return this._configurationClass;
        }

        public int getDefaultWeight() {
            return this._defaultWeight;
        }

        public List getDeviceInterface() {
            return this._deviceInterface;
        }

        public ChannelTypeManager.ChannelKind getKind() {
            return this._kind;
        }

        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        public String getValidatorClass() {
            return this._validatorClass;
        }

        public boolean isSetDefaultWeight() {
            return this._setDefaultWeight;
        }

        public String getJARFile() {
            return this._jarFile;
        }

        public String getTypeID() {
            return this._typeID;
        }

        public String getPlatform() {
            return this._platform;
        }
    }
}

