/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.RASDelegator;
import com.ibm.ws.bootstrap.RASWsLoggerFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class WsLogManager
extends LogManager {
    private static final String CONFIGURE_BY_SERVER_PROPERTY_NAME = "java.util.logging.configureByServer";
    private static final String ERR_HEADING_CONTROL = "com.ibm.websphere.logging.errheading";
    private static final String[] errHeaderVals = new String[]{"limited", "full", "none"};
    private static final String CONFIGURE_BY_LOGGING_PROPERTIES_FILE = "java.util.logging.configureByLoggingPropertiesFile";
    private static final boolean CHECK_CALLING_METHOD_FOR_GETLOGGER = "false".equals(System.getProperty("com.ibm.ws.bootstrap.logmanager.createNewLogger"));
    private static boolean configureByServer = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByServer"));
    private static boolean configureByLoggingProperties = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByLoggingPropertiesFile"));
    private static String errHeaderString = System.getProperty("com.ibm.websphere.logging.errheading");
    private static Boolean errHeadingCkd = new Boolean(false);
    private static RASDelegator svRASDelegator = RASDelegator.getSingleton();
    private boolean isTrLoaded = false;
    private boolean resetEnabled = true;

    public void readConfiguration() throws IOException, SecurityException {
        if (!configureByServer || configureByLoggingProperties) {
            super.readConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Logger getLogger(String string) {
        Logger logger;
        if (!this.isTrLoaded) {
            try {
                Class.forName("com.ibm.ejs.ras.Tr", true, WsLogManager.getClassLoader(WsLogManager.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            finally {
                this.isTrLoaded = true;
            }
        }
        if ((logger = super.getLogger(string)) == null) {
            boolean bl = true;
            if (CHECK_CALLING_METHOD_FOR_GETLOGGER) {
                bl = false;
                boolean bl2 = false;
                Exception exception = new Exception();
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (bl2) {
                        if (!stackTraceElementArray[i].getClassName().equals("java.util.logging.Logger") || !stackTraceElementArray[i].getMethodName().equals("getLogger")) break;
                        bl = true;
                        break;
                    }
                    if (!stackTraceElementArray[i].getClassName().equals("com.ibm.ws.bootstrap.WsLogManager") || !stackTraceElementArray[i].getMethodName().equals("getLogger")) continue;
                    bl2 = true;
                }
            }
            if (bl && (logger = svRASDelegator.createWsLogger(string)) != null) {
                this.addLogger(logger);
            }
        }
        return logger;
    }

    public void initWsLoggerFactory(RASWsLoggerFactory rASWsLoggerFactory) {
        svRASDelegator.setRASWsLogerFactory(rASWsLoggerFactory);
    }

    public void reset() throws SecurityException {
        if (this.resetEnabled) {
            super.reset();
        }
    }

    public void enableReset() {
        this.resetEnabled = true;
    }

    public void disableReset() {
        this.resetEnabled = false;
    }

    public boolean isResetEnabled() {
        return this.resetEnabled;
    }

    public static boolean isConfigureByLoggingProperties() {
        return configureByLoggingProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorHeaderControl() {
        Boolean bl = errHeadingCkd;
        synchronized (bl) {
            if (!errHeadingCkd.booleanValue()) {
                errHeaderString = errHeaderString == null ? "limited" : errHeaderString.toLowerCase();
                for (int i = 0; i < errHeaderVals.length; ++i) {
                    if (!errHeaderString.equals(errHeaderVals[i])) continue;
                    errHeadingCkd = new Boolean(true);
                }
                if (!errHeadingCkd.booleanValue()) {
                    errHeaderString = "limited";
                    errHeadingCkd = new Boolean(true);
                }
            }
        }
        return errHeaderString;
    }

    private static ClassLoader getClassLoader(final Class clazz) throws PrivilegedActionException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return clazz.getClassLoader();
            }
        });
    }
}

