/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;

public class JavaObject
implements com.ibm.dtfj.java.JavaObject {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;

    private JavaObject(JavaRuntime javaRuntime, ImagePointer imagePointer) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("A Java Object cannot exist in a null VM");
        }
        this._basePointer = imagePointer;
        this._javaVM = javaRuntime;
    }

    public static JavaObject createJavaObject(JavaRuntime javaRuntime, ImagePointer imagePointer) {
        if (null == imagePointer || 0L == imagePointer.getAddress()) {
            return null;
        }
        return new JavaObject(javaRuntime, imagePointer);
    }

    public JavaClass getJavaClass() throws CorruptDataException {
        if (0L != this._basePointer.getAddress()) {
            ImagePointer imagePointer;
            try {
                imagePointer = this._basePointer.getPointerAt(0L);
            }
            catch (MemoryAccessException memoryAccessException) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to access class pointer", this._basePointer));
            }
            long l = imagePointer.getAddress();
            return this._javaVM.getClassForID(l);
        }
        throw new NullPointerException();
    }

    public boolean isArray() throws CorruptDataException {
        return this.getJavaClass().isArray();
    }

    public int getArraySize() throws CorruptDataException {
        JavaClass javaClass = this.getJavaClass();
        if (javaClass instanceof JavaArrayClass) {
            JavaArrayClass javaArrayClass = (JavaArrayClass)javaClass;
            int n = javaArrayClass.getSizeOffset();
            int n2 = javaArrayClass.getNumberOfSizeBytes();
            try {
                int n3 = 0;
                if (4 == n2) {
                    n3 = this._basePointer.getIntAt((long)n);
                } else if (8 == n2) {
                    long l = this._basePointer.getLongAt((long)n);
                    n3 = (int)l;
                    if ((long)n3 != l) {
                        System.err.println("Error:  Array element count overflow or underflow.");
                    }
                } else {
                    System.err.println("Error:  unable to read array size as we weren't expecting to read " + n2 + " bytes.");
                }
                return n3;
            }
            catch (MemoryAccessException memoryAccessException) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to read the number of elements", this._basePointer.add((long)n)));
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void arraycopy(int n, Object object, int n2, int n3) throws CorruptDataException, MemoryAccessException {
        JavaClass javaClass = this.getJavaClass();
        if (!(javaClass instanceof JavaArrayClass)) throw new IllegalArgumentException();
        JavaArrayClass javaArrayClass = (JavaArrayClass)javaClass;
        int n4 = this.getArraySize();
        int n5 = Math.min(n4, n3);
        long l = javaArrayClass.getFirstElementOffset() + n;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n5; ++i) {
                byArray[i + n2] = this._basePointer.getByteAt(l + (long)(i * 1));
            }
            return;
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < n5; ++i) {
                blArray[i + n2] = 0 != this._basePointer.getByteAt(l + (long)(i * 1));
            }
            return;
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            for (int i = 0; i < n5; ++i) {
                cArray[i + n2] = (char)this._basePointer.getShortAt(l + (long)(i * 2));
            }
            return;
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            for (int i = 0; i < n5; ++i) {
                sArray[i + n2] = this._basePointer.getShortAt(l + (long)(i * 2));
            }
            return;
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < n5; ++i) {
                nArray[i + n2] = this._basePointer.getIntAt(l + (long)(i * 4));
            }
            return;
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            for (int i = 0; i < n5; ++i) {
                lArray[i + n2] = this._basePointer.getLongAt(l + (long)(i * 8));
            }
            return;
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            for (int i = 0; i < n5; ++i) {
                fArray[i + n2] = this._basePointer.getFloatAt(l + (long)(i * 4));
            }
            return;
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            for (int i = 0; i < n5; ++i) {
                dArray[i + n2] = this._basePointer.getDoubleAt(l + (long)(i * 8));
            }
            return;
        } else {
            if (!(object instanceof Object[])) return;
            Object[] objectArray = (Object[])object;
            ImageProcess imageProcess = this._basePointer.getAddressSpace().getCurrentProcess();
            if (null == imageProcess) throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("no current process", null));
            int n6 = imageProcess.getPointerSize();
            int n7 = (n6 + 1) / 8;
            for (int i = 0; i < n5; ++i) {
                ImagePointer imagePointer = this._basePointer.getPointerAt(l + (long)(i * n7));
                objectArray[i + n2] = JavaObject.createJavaObject(this._javaVM, imagePointer);
            }
        }
    }

    public long getSize() throws CorruptDataException {
        return ((JavaAbstractClass)this.getJavaClass()).getInstanceSize(this);
    }

    public long getHashcode() throws DataUnavailable, CorruptDataException {
        return this.getPersistentHashcode();
    }

    public long getPersistentHashcode() throws DataUnavailable, CorruptDataException {
        if (this._javaVM.objectShouldInferHash()) {
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)this._basePointer.getAddressSpace();
            int n = imageAddressSpace.bytesPerPointer();
            try {
                int n2 = this._basePointer.getIntAt((long)n);
                int n3 = n2 & 0x7FFF0000;
                long l = n3 >> 16 | n3;
                return l;
            }
            catch (MemoryAccessException memoryAccessException) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Address in object header but unreadable", this._basePointer.add((long)n)));
            }
        }
        throw new DataUnavailable("Unknown hash strategy for this VM version");
    }

    public ImagePointer getID() {
        return this._basePointer;
    }

    public Iterator getSections() {
        long l = 0L;
        try {
            l = this.getSize();
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        JavaObjectImageSection javaObjectImageSection = new JavaObjectImageSection(this._basePointer, l);
        return Collections.singletonList(javaObjectImageSection).iterator();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaObject) {
            JavaObject javaObject = (JavaObject)object;
            bl = this._javaVM.equals(javaObject._javaVM) && this._basePointer.equals(javaObject._basePointer);
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._basePointer.hashCode();
    }

    class JavaObjectImageSection
    extends ImageSection {
        public JavaObjectImageSection(ImagePointer imagePointer, long l) {
            super(imagePointer, l);
        }

        public String getName() {
            return "In-memory Object section at 0x" + Long.toHexString(this.getBaseAddress().getAddress()) + " (0x" + Long.toHexString(this.getSize()) + " bytes)";
        }
    }
}

