/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaMonitor
implements com.ibm.dtfj.java.JavaMonitor {
    private JavaRuntime _javaVM;
    private ImagePointer _monitorID;
    private String _monitorName;
    private JavaObject _encompassingObject;
    private long _owningThreadID;
    private Vector _blockList;
    private Vector _waitList;

    public JavaMonitor(JavaRuntime javaRuntime, ImagePointer imagePointer, String string, JavaObject javaObject, long l) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("A Java Monitor cannot exist in a null Java VM");
        }
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java Monitor requires a non-null ID");
        }
        this._javaVM = javaRuntime;
        this._monitorID = imagePointer;
        this._encompassingObject = javaObject;
        this._owningThreadID = l;
        this._monitorName = null == string ? (null != this._encompassingObject ? "(un-named monitor @0x" + Long.toHexString(imagePointer.getAddress()) + " for object @0x" + Long.toHexString(this._encompassingObject.getID().getAddress()) + ")" : "(un-named monitor @0x" + Long.toHexString(imagePointer.getAddress()) + ")") : string;
    }

    public JavaObject getObject() {
        return this._encompassingObject;
    }

    public String getName() throws CorruptDataException {
        return this._monitorName;
    }

    public JavaThread getOwner() throws CorruptDataException {
        JavaThread javaThread = null;
        Iterator iterator = this._javaVM.getThreads();
        while (iterator.hasNext()) {
            JavaThread javaThread2 = (JavaThread)iterator.next();
            if (javaThread2.getJNIEnv().getAddress() != this._owningThreadID) continue;
            javaThread = javaThread2;
            break;
        }
        return javaThread;
    }

    public Iterator getEnterWaiters() {
        if (null == this._blockList) {
            this._blockList = new Vector();
        }
        return this._blockList.iterator();
    }

    public Iterator getNotifyWaiters() {
        if (null == this._waitList) {
            this._waitList = new Vector();
        }
        return this._waitList.iterator();
    }

    public void setBlockedThreads(Vector vector) {
        this._blockList = vector;
    }

    public void setWaitingThreads(Vector vector) {
        this._waitList = vector;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaMonitor) {
            JavaMonitor javaMonitor = (JavaMonitor)object;
            bl = this._javaVM.equals(javaMonitor._javaVM) && this._monitorID.equals(javaMonitor._monitorID);
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._monitorID.hashCode();
    }

    public ImagePointer getID() {
        return this._monitorID;
    }
}

