/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;

public class JavaInstanceField
extends JavaField {
    private int _offset;

    public JavaInstanceField(JavaRuntime javaRuntime, String string, String string2, int n, int n2, long l) {
        super(javaRuntime, string, string2, n, l);
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for an instance field cannot be null");
        }
        this._offset = n2;
    }

    private ImagePointer _getDirectPointer(com.ibm.dtfj.java.JavaObject javaObject) {
        return javaObject.getID().add((long)this._offset);
    }

    public Object getReferenceType(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            String string = this.getSignature();
            if (string.startsWith("L") || string.startsWith("[")) {
                ImagePointer imagePointer = this._getDirectPointer(javaObject).getPointerAt(0L);
                return JavaObject.createJavaObject(this._javaVM, imagePointer);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public boolean getBoolean(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("Z")) {
                return 0 != this._getDirectPointer(javaObject).getByteAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public byte getByte(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("B")) {
                return this._getDirectPointer(javaObject).getByteAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public char getChar(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("C")) {
                return (char)this._getDirectPointer(javaObject).getShortAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public double getDouble(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("D")) {
                return this._getDirectPointer(javaObject).getDoubleAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public float getFloat(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("F")) {
                return this._getDirectPointer(javaObject).getFloatAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public int getInt(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("I")) {
                return this._getDirectPointer(javaObject).getIntAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public long getLong(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("J")) {
                return this._getDirectPointer(javaObject).getLongAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public short getShort(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            if (this.getSignature().equals("S")) {
                return this._getDirectPointer(javaObject).getShortAt(0L);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    private boolean _isSafeToAccess(com.ibm.dtfj.java.JavaObject javaObject) {
        return null != javaObject && 0L != javaObject.getID().getAddress();
    }
}

