/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaClass
extends JavaAbstractClass {
    private long _superClassID;
    private String _className;
    private Vector _methods = new Vector();
    private Vector _fields = new Vector();
    private Vector _constantPoolClassRefs = new Vector();
    private Vector _constantPoolObjects = new Vector();
    private int _instanceSize;
    private String _fileName;

    public JavaClass(JavaRuntime javaRuntime, ImagePointer imagePointer, long l, String string, int n, long l2, int n2, String string2) {
        super(javaRuntime, imagePointer, n2, l2);
        this._superClassID = l;
        this._className = string;
        this._instanceSize = n;
        this._fileName = string2;
    }

    public String getName() throws CorruptDataException {
        return this._className;
    }

    public com.ibm.dtfj.java.JavaClass getSuperclass() throws CorruptDataException {
        return this._javaVM.getClassForID(this._superClassID);
    }

    public boolean isArray() throws CorruptDataException {
        return false;
    }

    public com.ibm.dtfj.java.JavaClass getComponentType() throws CorruptDataException {
        if (this.isArray()) {
            long l = this._javaVM.getClassIDForClassName(this._className.substring(1));
            return this._javaVM.getClassForID(l);
        }
        throw new IllegalArgumentException("Only array types have component types");
    }

    public Iterator getDeclaredFields() {
        return this._fields.iterator();
    }

    public Iterator getDeclaredMethods() {
        return this._methods.iterator();
    }

    public Iterator getConstantPoolReferences() {
        Iterator iterator = this._constantPoolClassRefs.iterator();
        Vector<com.ibm.dtfj.java.JavaObject> vector = new Vector<com.ibm.dtfj.java.JavaObject>();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            com.ibm.dtfj.java.JavaClass javaClass = this._javaVM.getClassForID(l);
            com.ibm.dtfj.java.JavaObject javaObject = null;
            try {
                javaObject = javaClass.getObject();
            }
            catch (CorruptDataException corruptDataException) {
                javaObject = corruptDataException.getCorruptData();
            }
            vector.add(javaObject);
        }
        vector.addAll(this._constantPoolObjects);
        return vector.iterator();
    }

    public void addMethod(JavaMethod javaMethod) {
        this._methods.add(javaMethod);
    }

    public void addField(JavaField javaField) {
        this._fields.add(javaField);
    }

    public void addConstantPoolClassRef(long l) {
        if (0L != l) {
            this._constantPoolClassRefs.add(new Long(l));
        }
    }

    public void addConstantPoolObjectRef(JavaObject javaObject) {
        if (null != javaObject) {
            this._constantPoolObjects.add(javaObject);
        }
    }

    public int getInstanceSize(com.ibm.dtfj.java.JavaObject javaObject) {
        return this._instanceSize;
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        if (this._fileName != null) {
            return this._fileName;
        }
        throw new DataUnavailable();
    }
}

