/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.j9.BuilderShutdownHook;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageModule;
import com.ibm.dtfj.image.j9.ImagePointer;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.dtfj.image.j9.ImageRegister;
import com.ibm.dtfj.image.j9.ImageStackFrame;
import com.ibm.dtfj.image.j9.ImageSymbol;
import com.ibm.dtfj.image.j9.ImageThread;
import com.ibm.dtfj.image.j9.ModuleImageSection;
import com.ibm.dtfj.image.j9.PartialProcess;
import com.ibm.dtfj.image.j9.StackImageSection;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class Builder
implements com.ibm.dtfj.corereaders.Builder {
    private IAbstractAddressSpace _memory;
    private Vector _addressSpaces = new Vector();
    private long _environmentAddress;
    private DataUnavailable _executableException;
    private DataUnavailable _libraryException;
    private String _cpuSubType;
    private long _creationTimeMillis;
    private IFileLocationResolver _resolvingAgent;
    private BuilderShutdownHook _fileTracker = new BuilderShutdownHook();

    public Builder(ICoreFileReader iCoreFileReader, ClosingFileReader closingFileReader, long l, IFileLocationResolver iFileLocationResolver) {
        this._memory = iCoreFileReader.getAddressSpace();
        this._environmentAddress = l;
        this._resolvingAgent = iFileLocationResolver;
        Runtime.getRuntime().addShutdownHook(this._fileTracker);
        this._fileTracker.addFile(closingFileReader);
    }

    public Object buildProcess(Object object, String string, String string2, Properties properties, Object object2, Iterator iterator, Object object3, Iterator iterator2, int n) {
        ImageProcess imageProcess = null;
        imageProcess = null == this._executableException && null == this._libraryException ? new ImageProcess(string, string2, properties, (ImageThread)object2, iterator, (ImageModule)object3, iterator2, n) : new PartialProcess(string, string2, properties, (ImageThread)object2, iterator, (ImageModule)object3, iterator2, n, this._executableException, this._libraryException);
        ImageAddressSpace imageAddressSpace = (ImageAddressSpace)object;
        imageAddressSpace.addProcess(imageProcess);
        return imageProcess;
    }

    public Object buildAddressSpace(String string, int n) {
        ImageAddressSpace imageAddressSpace = new ImageAddressSpace(this._memory);
        this._addressSpaces.add(imageAddressSpace);
        return imageAddressSpace;
    }

    public Object buildRegister(String string, Number number) {
        return new ImageRegister(string, number);
    }

    public Object buildStackSection(Object object, long l, long l2) {
        return new StackImageSection(this.pointer(object, l), l2 - l);
    }

    private ImagePointer pointer(Object object, long l) {
        return new ImagePointer((ImageAddressSpace)object, l);
    }

    public Object buildThread(String string, Iterator iterator, Iterator iterator2, Iterator iterator3, Properties properties, int n) {
        return new ImageThread(string, iterator, iterator2, iterator3, properties, n);
    }

    public Object buildModuleSection(Object object, String string, long l, long l2) {
        return new ModuleImageSection(string, this.pointer(object, l), l2 - l);
    }

    public Object buildModule(String string, Properties properties, Iterator iterator, Iterator iterator2) {
        return new ImageModule(string, properties, iterator, iterator2);
    }

    public Iterator getAddressSpaces() {
        return this._addressSpaces.iterator();
    }

    public long getEnvironmentAddress() {
        return this._environmentAddress;
    }

    public long getValueOfNamedRegister(List list, String string) {
        for (ImageRegister imageRegister : list) {
            if (!imageRegister.getName().equals(string)) continue;
            try {
                return imageRegister.getValue().longValue();
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        return -1L;
    }

    public Object buildStackFrame(Object object, long l, long l2) {
        ImageAddressSpace imageAddressSpace = (ImageAddressSpace)object;
        return new ImageStackFrame(imageAddressSpace, imageAddressSpace.getPointer(l2), imageAddressSpace.getPointer(l));
    }

    public ClosingFileReader openFile(String string) throws FileNotFoundException {
        File file = this._resolvingAgent.findFileWithFullPath(string);
        ClosingFileReader closingFileReader = new ClosingFileReader(file);
        this._fileTracker.addFile(closingFileReader);
        return closingFileReader;
    }

    public Object buildSymbol(Object object, String string, long l) {
        return new ImageSymbol(string, ((ImageAddressSpace)object).getPointer(l));
    }

    public void setExecutableUnavailable(String string) {
        this._libraryException = this._executableException = new DataUnavailable(string);
    }

    public String getCPUSubType() {
        return this._cpuSubType;
    }

    public long getCreationTime() {
        return this._creationTimeMillis;
    }

    public void setCPUSubType(String string) {
        this._cpuSubType = string;
    }

    public void setCreationTime(long l) {
        this._creationTimeMillis = l;
    }

    public Object buildCorruptData(Object object, String string, long l) {
        return new CorruptData(string, this.pointer(object, l));
    }
}

