/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.util.Arrays;
import java.util.Iterator;

public abstract class CommonAddressSpace
implements IAbstractAddressSpace {
    private static final int BUFFER_MAX = 4096;
    private MemoryRange[] _translations;
    private boolean _isLittleEndian;
    private boolean _is64Bit;

    protected CommonAddressSpace(MemoryRange[] memoryRangeArray, boolean bl, boolean bl2) {
        this._translations = memoryRangeArray;
        this._isLittleEndian = bl;
        this._is64Bit = bl2;
    }

    public Iterator getMemoryRanges() {
        return Arrays.asList(this._translations).iterator();
    }

    protected MemoryRange _residentRange(long l) throws MemoryAccessException {
        int n = this.findWhichMemoryRange(l);
        if (n >= 0) {
            return this._translations[n];
        }
        throw new MemoryAccessException(0, l);
    }

    public int findWhichMemoryRange(long l) {
        long l2;
        int n;
        int n2 = -1;
        int n3 = this._translations.length - 1;
        int n4 = 0;
        while (n4 <= n3) {
            n = n4 + (n3 - n4 >>> 1);
            l2 = this._translations[n].getVirtualAddress();
            if (CommonAddressSpace.compareAddress(l, l2) >= 0) {
                if (CommonAddressSpace.compareAddress(l, l2 + this._translations[n].getSize()) < 0) {
                    n2 = n;
                    break;
                }
                n4 = n + 1;
                continue;
            }
            n3 = n - 1;
        }
        if (-1 == n2) {
            for (n = 0; n < n4; ++n) {
                l2 = this._translations[n].getVirtualAddress();
                if (CommonAddressSpace.compareAddress(l, l2) < 0 || CommonAddressSpace.compareAddress(l, l2 + this._translations[n].getSize()) >= 0) continue;
                n2 = n;
                break;
            }
        }
        return n2;
    }

    private static int compareAddress(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return l < l2 ? -1 : 1;
        }
        return l < l2 ? 1 : -1;
    }

    public byte[] getMemoryBytes(long l, int n) {
        byte[] byArray = null;
        if (0L != l) {
            byArray = new byte[n];
            try {
                this.getBytesAt(0, l, byArray);
            }
            catch (MemoryAccessException memoryAccessException) {
                byArray = null;
            }
        }
        return byArray;
    }

    public long findPattern(byte[] byArray, int n, long l) {
        int n2 = 4096;
        int n3 = 0 == n ? 1 : n;
        if (n2 < n3) {
            n2 = n3;
        } else if (0 != n2 % n3) {
            n2 -= n2 % n3;
        }
        long l2 = -1L;
        Iterator iterator = this.getMemoryRanges();
        while (-1L == l2 && iterator.hasNext()) {
            MemoryRange memoryRange = (MemoryRange)iterator.next();
            l2 = this.findPatternInRange(byArray, n3, l, memoryRange, n2);
        }
        return l2;
    }

    private static int match(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        for (int i = n2; i < byArray2.length && n3 < byArray.length; ++i, ++n3) {
            if (byArray2[i] == byArray[n3]) continue;
            return 0;
        }
        return n3;
    }

    private long findPatternInRange(byte[] byArray, int n, long l, MemoryRange memoryRange, int n2) {
        if (memoryRange.getVirtualAddress() >= l || memoryRange.contains(l)) {
            long l2 = l;
            if (l2 < memoryRange.getVirtualAddress()) {
                l2 = memoryRange.getVirtualAddress();
            }
            if (0L != l2 % (long)n) {
                l2 += (long)n - l2 % (long)n;
            }
            long l3 = memoryRange.getVirtualAddress() + memoryRange.getSize();
            int n3 = 0;
            long l4 = -1L;
            while (l2 < l3) {
                long l5;
                long l6 = l3 - l2;
                long l7 = l5 = (long)n2 < l6 ? (long)n2 : l6;
                if (0L != l2) {
                    byte[] byArray2 = this.getMemoryBytes(l2, (int)l5);
                    if (null != byArray2) {
                        if (0 != n3) {
                            n3 = CommonAddressSpace.match(byArray, n3, byArray2, 0);
                        }
                        for (int i = 0; i < byArray2.length && 0 == n3; i += n) {
                            l4 = l2 + (long)i;
                            n3 = CommonAddressSpace.match(byArray, 0, byArray2, i);
                        }
                        if (byArray.length == n3) {
                            return l4;
                        }
                    }
                } else {
                    System.err.println("Looking for address 0");
                }
                l2 += l5;
            }
        }
        return -1L;
    }

    public long getLongAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[8];
        this.getBytesAt(n, l, byArray);
        this._byteSwap(byArray);
        return 0xFF00000000000000L & (long)byArray[0] << 56 | 0xFF000000000000L & (long)byArray[1] << 48 | 0xFF0000000000L & (long)byArray[2] << 40 | 0xFF00000000L & (long)byArray[3] << 32 | 0xFF000000L & (long)byArray[4] << 24 | 0xFF0000L & (long)byArray[5] << 16 | 0xFF00L & (long)byArray[6] << 8 | 0xFFL & (long)byArray[7];
    }

    public int getIntAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[4];
        this.getBytesAt(n, l, byArray);
        this._byteSwap(byArray);
        return (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
    }

    public short getShortAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[2];
        this.getBytesAt(n, l, byArray);
        this._byteSwap(byArray);
        return (short)((0xFF & byArray[0]) << 8 | 0xFF & byArray[1]);
    }

    public byte getByteAt(int n, long l) throws MemoryAccessException {
        byte[] byArray = new byte[1];
        this.getBytesAt(n, l, byArray);
        return byArray[0];
    }

    private void _byteSwap(byte[] byArray) {
        if (this._isLittleEndian) {
            int n = byArray.length / 2;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[byArray.length - 1 - i];
                byArray[byArray.length - 1 - i] = byArray[i];
                byArray[i] = by;
            }
        }
    }

    public long getPointerAt(int n, long l) throws MemoryAccessException {
        long l2 = 0L;
        l2 = this._is64Bit ? this.getLongAt(n, l) : 0xFFFFFFFFL & (long)this.getIntAt(n, l);
        return l2;
    }

    public abstract int getBytesAt(int var1, long var2, byte[] var4) throws MemoryAccessException;

    public int bytesPerPointer() {
        return this._is64Bit ? 8 : 4;
    }
}

