/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Vector;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.QSort;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclList
implements InternalRep {
    private Vector vector;

    private TclList() {
        this.vector = new Vector();
    }

    private TclList(int size) {
        this.vector = new Vector(size);
    }

    public void dispose() {
        int size = this.vector.size();
        for (int i = 0; i < size; ++i) {
            ((TclObject)this.vector.elementAt(i)).release();
        }
    }

    public InternalRep duplicate() {
        int size = this.vector.size();
        TclList newList = new TclList(size);
        for (int i = 0; i < size; ++i) {
            TclObject tobj = (TclObject)this.vector.elementAt(i);
            tobj.preserve();
            newList.vector.addElement(tobj);
        }
        return newList;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        int size = this.vector.size();
        try {
            for (int i = 0; i < size; ++i) {
                Object elm = this.vector.elementAt(i);
                if (elm != null) {
                    Util.appendElement(null, sbuf, elm.toString());
                    continue;
                }
                Util.appendElement(null, sbuf, "");
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        return sbuf.toString();
    }

    public static TclObject newInstance() {
        return new TclObject(new TclList());
    }

    static void setListFromAny(Interp interp, TclObject tobj) throws TclException {
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclList)) {
            TclList tlist = new TclList();
            TclList.splitList(interp, tlist.vector, tobj.toString());
            tobj.setInternalRep(tlist);
        }
    }

    private static final void splitList(Interp interp, Vector v, String s) throws TclException {
        FindElemResult res;
        int len = s.length();
        int i = 0;
        while (i < len && (res = Util.findElement(interp, s, i, len)) != null) {
            TclObject tobj = TclString.newInstance(res.elem);
            tobj.preserve();
            v.addElement(tobj);
            i = res.elemEnd;
        }
    }

    public static final void append(Interp interp, TclObject tobj, TclObject elemObj) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        elemObj.preserve();
        tlist.vector.addElement(elemObj);
    }

    public static final int getLength(Interp interp, TclObject tobj) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        return tlist.vector.size();
    }

    public static TclObject[] getElements(Interp interp, TclObject tobj) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.vector.size();
        TclObject[] objArray = new TclObject[size];
        for (int i = 0; i < size; ++i) {
            objArray[i] = (TclObject)tlist.vector.elementAt(i);
        }
        return objArray;
    }

    public static final TclObject index(Interp interp, TclObject tobj, int index) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        if (index < 0 || index >= tlist.vector.size()) {
            return null;
        }
        return (TclObject)tlist.vector.elementAt(index);
    }

    static final void insert(Interp interp, TclObject tobj, int index, TclObject[] elements, int from, int to) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.insert() called with shared object");
        }
        TclList.replace(interp, tobj, index, 0, elements, from, to);
    }

    public static final void replace(Interp interp, TclObject tobj, int index, int count, TclObject[] elements, int from, int to) throws TclException {
        int i;
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.replace() called with shared object");
        }
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.vector.size();
        if (index >= size) {
            index = size;
        } else {
            if (index < 0) {
                index = 0;
            }
            if (count > size - index) {
                count = size - index;
            }
            for (i = 0; i < count; ++i) {
                TclObject obj = (TclObject)tlist.vector.elementAt(index);
                obj.release();
                tlist.vector.removeElementAt(index);
            }
        }
        for (i = from; i <= to; ++i) {
            elements[i].preserve();
            tlist.vector.insertElementAt(elements[i], index++);
        }
    }

    static void sort(Interp interp, TclObject tobj, int sortMode, int sortIndex, boolean sortIncreasing, String command) throws TclException {
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.vector.size();
        if (size <= 1) {
            return;
        }
        TclObject[] objArray = new TclObject[size];
        for (int i = 0; i < size; ++i) {
            objArray[i] = (TclObject)tlist.vector.elementAt(i);
        }
        QSort s = new QSort();
        s.sort(interp, objArray, sortMode, sortIndex, sortIncreasing, command);
        for (int i = 0; i < size; ++i) {
            tlist.vector.setElementAt(objArray[i], i);
            objArray[i] = null;
        }
    }
}

