/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.WrappedCommand;

class Procedure
implements Command,
CommandWithDispose {
    TclObject[][] argList;
    boolean isVarArgs;
    CharPointer body;
    int body_length;
    NamespaceCmd.Namespace ns;
    String srcFileName;
    int srcLineNumber;

    Procedure(Interp interp, NamespaceCmd.Namespace ns, String name, TclObject args, TclObject b, String sFileName, int sLineNumber) throws TclException {
        this.ns = ns;
        this.srcFileName = sFileName;
        this.srcLineNumber = sLineNumber;
        int numArgs = TclList.getLength(interp, args);
        this.argList = new TclObject[numArgs][2];
        for (int i = 0; i < numArgs; ++i) {
            TclObject argSpec = TclList.index(interp, args, i);
            int specLen = TclList.getLength(interp, argSpec);
            if (specLen == 0) {
                throw new TclException(interp, "procedure \"" + name + "\" has argument with no name");
            }
            if (specLen > 2) {
                throw new TclException(interp, "too many fields in argument specifier \"" + argSpec + "\"");
            }
            this.argList[i][0] = TclList.index(interp, argSpec, 0);
            this.argList[i][0].preserve();
            if (specLen == 2) {
                this.argList[i][1] = TclList.index(interp, argSpec, 1);
                this.argList[i][1].preserve();
                continue;
            }
            this.argList[i][1] = null;
        }
        this.isVarArgs = numArgs > 0 && this.argList[numArgs - 1][0].toString().equals("args");
        this.body = new CharPointer(b.toString());
        this.body_length = this.body.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        block12: {
            CallFrame frame = interp.newCallFrame(this, argv);
            interp.pushDebugStack(this.srcFileName, this.srcLineNumber);
            try {
                Parser.eval2(interp, this.body.array, this.body.index, this.body_length, 0);
            }
            catch (TclException e) {
                int code = e.getCompletionCode();
                if (code == 2) {
                    int realCode = interp.updateReturnInfo();
                    if (realCode != 0) {
                        e.setCompletionCode(realCode);
                        throw e;
                    }
                    break block12;
                }
                if (code == 1) {
                    interp.addErrorInfo("\n    (procedure \"" + argv[0] + "\" line " + interp.errorLine + ")");
                    throw e;
                }
                if (code == 3) {
                    throw new TclException(interp, "invoked \"break\" outside of a loop");
                }
                if (code == 4) {
                    throw new TclException(interp, "invoked \"continue\" outside of a loop");
                }
                throw e;
            }
            finally {
                interp.popDebugStack();
                if (interp.errInProgress) {
                    frame.dispose();
                    interp.errInProgress = true;
                } else {
                    frame.dispose();
                }
            }
        }
    }

    public void disposeCmd() {
        this.body = null;
        for (int i = 0; i < this.argList.length; ++i) {
            this.argList[i][0].release();
            this.argList[i][0] = null;
            if (this.argList[i][1] == null) continue;
            this.argList[i][1].release();
            this.argList[i][1] = null;
        }
        this.argList = null;
    }

    static boolean isProc(WrappedCommand cmd) {
        return cmd.cmd instanceof Procedure;
    }

    static Procedure findProc(Interp interp, String procName) {
        WrappedCommand cmd;
        try {
            cmd = NamespaceCmd.findCommand(interp, procName, null, 0);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
        if (cmd == null) {
            return null;
        }
        WrappedCommand origCmd = NamespaceCmd.getOriginalCommand(cmd);
        if (origCmd != null) {
            cmd = origCmd;
        }
        if (!(cmd.cmd instanceof Procedure)) {
            return null;
        }
        return (Procedure)cmd.cmd;
    }
}

