/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.internal.impl.ResourceRefImpl;
import org.eclipse.jst.j2ee.common.internal.impl.SecurityRoleImpl;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEMessageConstants;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidationResourceHandler;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public abstract class J2EEValidator
implements IValidatorJob,
J2EEMessageConstants {
    protected IReporter _reporter;
    protected IValidationContext _helper;
    protected IStatus status = OK_STATUS;

    public J2EEValidator() {
        this.initialize();
    }

    public void addError(String msgId) {
        this.addError(this.getBaseName(), msgId, null);
    }

    public void addError(String msgId, String[] msgArgs) {
        this.addError(this.getBaseName(), msgId, msgArgs);
    }

    public void addError(String msgCategory, String msgId) {
        this.addError(msgCategory, msgId, null);
    }

    public void addError(String bundleName, String msgId, String[] msgArgs) {
        this.addError(bundleName, msgId, msgArgs, null);
    }

    public void addError(String bundleName, String msgId, String[] msgArgs, Object target) {
        this._reporter.addMessage(this, new Message(bundleName, 1, msgId, msgArgs, target));
    }

    public void addError(String bundleName, String msgId, String[] msgArgs, Object target, String groupName) {
        Message message = new Message(bundleName, 1, msgId, msgArgs, target);
        message.setGroupName(groupName);
        this._reporter.addMessage(this, message);
    }

    public void addError(String bundleName, String msgId, String[] msgArgs, Object target, String groupName, int lineNumber) {
        Message message = new Message(bundleName, 1, msgId, msgArgs, target);
        message.setLineNo(lineNumber);
        message.setGroupName(groupName);
        this._reporter.addMessage(this, message);
    }

    public void addLocalizedError(String msg, Object target) {
        this._reporter.addMessage(this, new LocalizedMessage(1, msg, target));
    }

    public void addLocalizedError(String msg, Object target, int lineNumber) {
        this.addLocalizedError(msg, target, null, lineNumber);
    }

    public void addLocalizedError(String msg, Object target, String groupName, int lineNumber) {
        LocalizedMessage message = new LocalizedMessage(1, msg, target);
        message.setGroupName(groupName);
        message.setLineNo(lineNumber);
        this._reporter.addMessage(this, message);
    }

    public void addLocalizedError(String msg, Object target, String groupName) {
        LocalizedMessage message = new LocalizedMessage(1, msg, target);
        message.setGroupName(groupName);
        this._reporter.addMessage(this, message);
    }

    public void addInfo(String msgId) {
        this.addInfo(this.getBaseName(), msgId, null);
    }

    public void addInfo(String msgId, String[] msgArgs) {
        this.addInfo(this.getBaseName(), msgId, msgArgs);
    }

    public void addInfo(String msgCategory, String msgId) {
        this.addInfo(msgCategory, msgId, null);
    }

    public void addInfo(String bundleName, String msgId, String[] msgArgs) {
        this.addInfo(bundleName, msgId, msgArgs, null);
    }

    public void addInfo(String bundleName, String msgId, String[] msgArgs, Object target) {
        this._reporter.addMessage(this, new Message(bundleName, 4, msgId, msgArgs, target));
    }

    public void addLocalizedInfo(String msg, Object target) {
        this._reporter.addMessage(this, new LocalizedMessage(4, msg, target));
    }

    public void addWarning(String msgId) {
        this.addWarning(this.getBaseName(), msgId, null);
    }

    public void addWarning(String msgId, String[] msgArgs) {
        this.addWarning(this.getBaseName(), msgId, msgArgs);
    }

    public void addWarning(String msgCategory, String msgId) {
        this.addWarning(msgCategory, msgId, null);
    }

    public void addWarning(String bundleName, String msgId, String[] msgArgs) {
        this.addWarning(bundleName, msgId, msgArgs, null);
    }

    public void addWarning(String bundleName, String msgId, String[] msgArgs, Object target) {
        this._reporter.addMessage(this, new Message(bundleName, 2, msgId, msgArgs, target));
    }

    public void addWarning(String bundleName, String msgId, String[] msgArgs, Object target, String groupName) {
        Message message = new Message(bundleName, 2, msgId, msgArgs, target);
        message.setGroupName(groupName);
        this._reporter.addMessage(this, message);
    }

    public void addLocalizedWarning(String msg, Object target) {
        this._reporter.addMessage(this, new LocalizedMessage(2, msg, target));
    }

    public void addLocalizedWarning(String msg, Object target, String groupName) {
        LocalizedMessage message = new LocalizedMessage(2, msg, target);
        message.setGroupName(groupName);
        this._reporter.addMessage(this, message);
    }

    public void cleanup() {
        this._reporter = null;
    }

    public void cleanup(IReporter reporter) {
        this._reporter = null;
    }

    public String[] get1Param(String string1) {
        String[] parms = new String[]{string1};
        return parms;
    }

    public String[] get2Param(String string1, String string2) {
        String[] parms = new String[]{string1, string2};
        return parms;
    }

    public String[] get3Param(String string1, String string2, String string3) {
        String[] parms = new String[]{string1, string2};
        parms[2] = string3;
        return parms;
    }

    public abstract String getBaseName();

    public String getMessage(String msgCategory, String msgId, String[] msgArgs, Locale locale) {
        return J2EEValidationResourceHandler.getExternalizedMessage(msgCategory, msgId, this.getClass(), msgArgs, locale);
    }

    public String getMessage(String msgCategory, String msgId, Locale locale) {
        return J2EEValidationResourceHandler.getExternalizedMessage(msgCategory, msgId, this.getClass(), locale);
    }

    public String getName() {
        return this.getName(Locale.getDefault());
    }

    public String getName(Locale locale) {
        return this.getMessage(this.getBaseName(), "validator.name", locale);
    }

    public String[] getParam1(String string1) {
        String[] parms = new String[]{string1};
        return parms;
    }

    protected void initialize() {
    }

    public void validate(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        this._helper = inHelper;
        this._reporter = inReporter;
        if (inHelper == null || inReporter == null) {
            return;
        }
    }

    public IStatus validateInJob(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        this._helper = inHelper;
        this._reporter = inReporter;
        this.status = OK_STATUS;
        return this.status;
    }

    protected void validateEJBRefManadatoryElements(EjbRef eref, String ownerName) {
        String refHome;
        String[] parms = new String[]{eref.getName(), ownerName};
        if (eref.getName() == null || eref.getName().trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFNAME", parms, eref);
        }
        if (eref.isSetType()) {
            if (eref.getType() == null) {
                this.addWarning("erefvalidation", "ERROR_EAR_INVALID_EREFTYPE", parms);
            }
        } else {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFTYPE", parms);
        }
        if ((refHome = eref.getHome()) == null || refHome.trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFHOME", parms, eref);
        }
        if (eref.getRemote() == null || eref.getRemote().trim().length() == 0) {
            this.addWarning("erefvalidation", "ERROR_EAR_MISSING_EREFREMOTE", parms, eref);
        }
    }

    protected void validateResourceRefs(List resourceRefs) {
        int numRefs = resourceRefs.size();
        HashSet<String> refSet = new HashSet<String>(numRefs);
        int refNo = 0;
        while (refNo < numRefs) {
            String refName = ((ResourceRefImpl)resourceRefs.get(refNo)).getName();
            String[] parms = new String[]{refName};
            if (!refSet.add(refName)) {
                this.addError("erefvalidation", "ERROR_EAR_DUPLICATE_RESREF", parms, resourceRefs.get(refNo));
            }
            ++refNo;
        }
    }

    protected void validateWEBRolesWithEARRoles(EList earRoleList, EList warRoles) {
        int numRoles = warRoles.size();
        int roleNo = 0;
        while (roleNo < numRoles) {
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createErrorStatus(msg);
            }
            SecurityRoleImpl nextRole = (SecurityRoleImpl)warRoles.get(roleNo);
            String[] parms = new String[]{nextRole.getRoleName()};
            if (!earRoleList.contains(nextRole)) {
                this.addWarning("warvalidation", "ERROR_EAR_MISSING_EJB_ROLE", parms, nextRole);
            }
            ++roleNo;
        }
    }
}

