/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservices;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.j2ee.internal.webservices.WebServiceClientGenerator;

public class WebServicesClientDataRegistry
extends RegistryReader {
    private static WebServicesClientDataRegistry INSTANCE = null;
    public static final String WS_CLIENT_EXTENSION_POINT = "WebServiceClientGenerator";
    public static final String GENERATOR = "generator";
    public static final String CLASS_NAME = "className";
    public static final String SERVER_TARGET = "serverTarget";
    public static final String RUNTIME = "runtime";
    private List wsClientDataExtensions = null;

    public WebServicesClientDataRegistry() {
        super("org.eclipse.jst.j2ee", WS_CLIENT_EXTENSION_POINT);
    }

    public static WebServicesClientDataRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebServicesClientDataRegistry();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(GENERATOR)) {
            return false;
        }
        WebServiceClientGenerator helper = null;
        try {
            helper = (WebServiceClientGenerator)element.createExecutableExtension(CLASS_NAME);
            IConfigurationElement[] runtimes = element.getChildren(RUNTIME);
            ArrayList<String> runtimeList = new ArrayList<String>();
            int i = 0;
            while (i < runtimes.length) {
                IConfigurationElement runtime2 = runtimes[i];
                String serverTarget = runtime2.getAttribute(SERVER_TARGET);
                runtimeList.add(serverTarget);
                ++i;
            }
            helper.setRuntime(runtimeList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (helper != null) {
            this.getWSClientGeneratorExtensions().add(helper);
            return true;
        }
        return false;
    }

    public List getWSClientGeneratorExtensions() {
        if (this.wsClientDataExtensions == null) {
            this.wsClientDataExtensions = new ArrayList();
        }
        return this.wsClientDataExtensions;
    }
}

