/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.IRoleShapeStrategy;

public abstract class RoleShapeStrategy
implements IRoleShapeStrategy {
    protected boolean busy = false;
    protected CommonRelationshipRole role;
    protected ArrayList visitedKeyTypes = new ArrayList(5);

    public RoleShapeStrategy(CommonRelationshipRole aRole) {
        this.setRole(aRole);
    }

    protected String appendName(String fullName, String additionalName) {
        return String.valueOf(fullName) + "_" + additionalName;
    }

    protected boolean canContinue() {
        return !this.busy && this.role.isForward() && this.role.getName() != null;
    }

    protected boolean canComputeNames() {
        return true;
    }

    public CommonRelationshipRole getRole() {
        return this.role;
    }

    public boolean isFlat() {
        return false;
    }

    public boolean isRound() {
        return false;
    }

    public static String makeJavaName(String firstName, String secondName) {
        StringBuffer nameBuffer = new StringBuffer(firstName);
        nameBuffer.append(Character.toUpperCase(secondName.charAt(0)));
        int i = 1;
        while (i < secondName.length()) {
            nameBuffer.append(secondName.charAt(i));
            ++i;
        }
        return nameBuffer.toString();
    }

    public void reconcileAttributes(List roleAttributes) {
        if (this.canContinue()) {
            this.busy = true;
            String attributeName = this.getRole().getName();
            ArrayList computedNames = new ArrayList();
            if (this.canComputeNames()) {
                this.visitedKeyTypes.clear();
                this.reconcileAttributes(this.getRole(), attributeName, roleAttributes, computedNames);
            }
            this.removeExtraAttributes(computedNames);
            this.busy = false;
        }
    }

    protected abstract void reconcileAttributes(CommonRelationshipRole var1, String var2, List var3, List var4);

    protected void removeExtraAttributes(List computedNames) {
        if (!this.getRole().getAttributes().isEmpty()) {
            Iterator it = this.getRole().getAttributes().iterator();
            ContainerManagedEntity cmp = this.getRole().getSourceEntity();
            while (it.hasNext()) {
                CMPAttribute attribute = (CMPAttribute)it.next();
                if (computedNames.contains(attribute.getName())) continue;
                it.remove();
                cmp.getKeyAttributes().remove(attribute);
                cmp.getPersistentAttributes().remove(attribute);
            }
        }
    }

    public void setRole(CommonRelationshipRole newRole) {
        this.role = newRole;
    }
}

